/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyNodeMerge;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.Job;
import com.sun.electric.util.math.AbstractFixpPoint;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;

public class PolyBase
implements Shape,
PolyNodeMerge {
    private static final boolean ALLOWTINYPOLYGONS = false;
    private Poly.Type style;
    protected Point[] points;
    private Layer layer;
    protected FixpRectangle bounds;
    private PortProto pp;
    private char bitRectangle = (char)2;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int XY = 4;
    private static Comparator<PolyBase> AREA_COMPARATOR = new Comparator<PolyBase>(){

        @Override
        public int compare(PolyBase p1, PolyBase p2) {
            double diff = p1.getArea() - p2.getArea();
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }
    };

    public static Point from(Point2D p) {
        if (p instanceof AbstractFixpPoint) {
            AbstractFixpPoint fp = (AbstractFixpPoint)p;
            return PolyBase.fromFixp(fp.getFixpX(), fp.getFixpY());
        }
        return PolyBase.fromLambda(p.getX(), p.getY());
    }

    public static Point from(ECoord x, ECoord y) {
        return new Point(x.getFixp(), y.getFixp());
    }

    public static Point fromLambda(double lambdaX, double lambdaY) {
        return new Point(FixpCoord.lambdaToFixp(lambdaX), FixpCoord.lambdaToFixp(lambdaY));
    }

    public static Point fromFixp(long fixpX, long fixpY) {
        return new Point(fixpX, fixpY);
    }

    public static Point fromGrid(long gridX, long gridY) {
        return new Point(gridX << 20, gridY << 20);
    }

    public PolyBase(Point ... points) {
        this.initialize(points);
    }

    public PolyBase(double cX, double cY, double width, double height) {
        double halfWidth = width / 2.0;
        double halfHeight = height / 2.0;
        this.initialize(PolyBase.makePoints(cX - halfWidth, cX + halfWidth, cY - halfHeight, cY + halfHeight));
    }

    public PolyBase(Rectangle2D rect) {
        this.initialize(PolyBase.makePoints(rect));
    }

    public static Point[] makePoints(double lX, double hX, double lY, double hY) {
        return new Point[]{PolyBase.fromLambda(lX, lY), PolyBase.fromLambda(hX, lY), PolyBase.fromLambda(hX, hY), PolyBase.fromLambda(lX, hY)};
    }

    public static Point[] makePoints(Rectangle2D rect) {
        double lX = rect.getMinX();
        double hX = rect.getMaxX();
        double lY = rect.getMinY();
        double hY = rect.getMaxY();
        return new Point[]{PolyBase.fromLambda(lX, lY), PolyBase.fromLambda(hX, lY), PolyBase.fromLambda(hX, hY), PolyBase.fromLambda(lX, hY)};
    }

    private void initialize(Point[] points) {
        this.style = Poly.Type.CLOSED;
        this.points = points;
        this.layer = null;
        this.bounds = null;
        this.pp = null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.layer != null) {
            buf.append(this.layer.getName() + ": ");
        }
        for (Point p : this.points) {
            buf.append("(" + ((Point2D)p).getX() + ", " + ((Point2D)p).getY() + "), ");
        }
        if (this.style != null) {
            buf.append(this.style.toString());
        }
        return buf.toString();
    }

    public Poly.Type getStyle() {
        return this.style;
    }

    public void setStyle(Poly.Type style) {
        this.style = style;
    }

    public Point[] getPoints() {
        return this.points;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Layer getLayerOrPseudoLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public PortProto getPort() {
        return this.pp;
    }

    public void setPort(PortProto pp) {
        this.pp = pp;
    }

    public void transform(FixpTransform af) {
        double det;
        if (af.getType() == 0) {
            return;
        }
        if ((this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) && (det = af.getDeterminant()) < 0.0) {
            for (int i = 0; i < this.points.length; i += 3) {
                double x = this.points[i + 1].getX();
                double y = this.points[i + 1].getY();
                this.points[i + 1].setLocation(this.points[i + 2].getX(), this.points[i + 2].getY());
                this.points[i + 2].setLocation(x, y);
            }
        }
        af.transform(this.points, 0, this.points, 0, this.points.length);
        this.bounds = null;
        this.bitRectangle = (char)2;
    }

    public FixpRectangle getBox() {
        if (this.bitRectangle == '\u0001') {
            return this.getBounds2D();
        }
        if (this.bitRectangle == '\u0000') {
            return null;
        }
        this.bitRectangle = '\u0000';
        if (this.points.length == 4) {
            if (this.style != Poly.Type.FILLED && this.style != Poly.Type.CLOSED && this.style != Poly.Type.TEXTBOX && this.style != Poly.Type.CROSSED) {
                return null;
            }
        } else if (this.points.length == 5) {
            if (this.style != Poly.Type.FILLED && this.style != Poly.Type.CLOSED && this.style != Poly.Type.OPENED && this.style != Poly.Type.OPENEDT1 && this.style != Poly.Type.OPENEDT2 && this.style != Poly.Type.OPENEDT3) {
                return null;
            }
            if (this.points[0].getFixpX() != this.points[4].getFixpX() || this.points[0].getFixpY() != this.points[4].getFixpY()) {
                return null;
            }
        } else {
            return null;
        }
        if (this.points[0].getFixpX() == this.points[1].getFixpX() && this.points[2].getFixpX() == this.points[3].getFixpX() && this.points[0].getFixpY() == this.points[3].getFixpY() && this.points[1].getFixpY() == this.points[2].getFixpY()) {
            this.bitRectangle = '\u0001';
            return this.getBounds2D();
        }
        if (this.points[0].getFixpX() == this.points[3].getFixpX() && this.points[1].getFixpX() == this.points[2].getFixpX() && this.points[0].getFixpY() == this.points[1].getFixpY() && this.points[2].getFixpY() == this.points[3].getFixpY()) {
            this.bitRectangle = '\u0001';
            return this.getBounds2D();
        }
        return null;
    }

    public double getMinSize() {
        FixpRectangle box = this.getBox();
        if (box == null) {
            return 0.0;
        }
        return Math.min(((RectangularShape)box).getWidth(), ((RectangularShape)box).getHeight());
    }

    public double getMaxSize() {
        FixpRectangle box = this.getBox();
        if (box == null) {
            return 0.0;
        }
        return Math.max(((RectangularShape)box).getWidth(), ((RectangularShape)box).getHeight());
    }

    public boolean polySame(PolyBase polyOther) {
        Point[] pointsO;
        Point[] points = this.getPoints();
        if (points.length != (pointsO = polyOther.getPoints()).length) {
            return false;
        }
        FixpRectangle box = this.getBox();
        FixpRectangle boxO = polyOther.getBox();
        if (box != null && boxO != null) {
            return box.equals(boxO);
        }
        if (box != null || boxO != null) {
            return false;
        }
        for (int i = 0; i < points.length; ++i) {
            if (((Point2D)points[i]).equals(pointsO[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isPointInsideCutAlgorithm(Point2D pt) {
        Point lastPoint = this.points[this.points.length - 1];
        if (DBMath.areEquals(pt, lastPoint)) {
            return true;
        }
        FixpRectangle box = this.getBounds2D();
        if (!DBMath.pointInRect(pt, (Rectangle2D)box)) {
            return false;
        }
        int count = 0;
        for (Point thisPoint : this.points) {
            boolean skip;
            if (DBMath.areEquals(pt, thisPoint)) {
                return true;
            }
            if (DBMath.isOnLine(thisPoint, lastPoint, pt)) {
                return true;
            }
            double ptY = pt.getY();
            double lastY = ((Point2D)lastPoint).getY();
            double thisY = ((Point2D)thisPoint).getY();
            boolean bl = skip = DBMath.areEquals(ptY, thisY) && DBMath.areEquals(ptY, lastY);
            if (!skip) {
                boolean thisPointGreaterY = DBMath.isGreaterThan(thisY, ptY);
                boolean lastPointGreaterY = DBMath.isGreaterThan(lastY, ptY);
                boolean bl2 = skip = thisPointGreaterY && lastPointGreaterY || DBMath.isGreaterThan(ptY, thisY) && DBMath.isGreaterThan(ptY, lastY);
                if (!skip) {
                    double ptX = pt.getX();
                    if (!DBMath.areEquals(thisY, lastY)) {
                        ptX = ((Point2D)thisPoint).getX() + (ptY - thisY) * (((Point2D)lastPoint).getX() - ((Point2D)thisPoint).getX()) / (lastY - thisY);
                    }
                    boolean pointGreaterX = DBMath.isGreaterThan(ptX, pt.getX());
                    if ((thisPointGreaterY || lastPointGreaterY) && pointGreaterX) {
                        ++count;
                    }
                }
            }
            lastPoint = thisPoint;
        }
        boolean inside = count != 0 && count % 2 != 0;
        return inside;
    }

    public boolean isInside(Point2D pt) {
        if (this.style == Poly.Type.FILLED || this.style == Poly.Type.CLOSED || this.style == Poly.Type.CROSSED || this.style.isText()) {
            FixpRectangle bounds2D = this.getBounds2D();
            if (!DBMath.pointInRect(pt, (Rectangle2D)bounds2D)) {
                return false;
            }
            FixpRectangle bounds = this.getBox();
            if (bounds != null) {
                if (DBMath.pointInRect(pt, (Rectangle2D)bounds)) {
                    return true;
                }
                return ((RectangularShape)bounds).getWidth() == 0.0 && ((RectangularShape)bounds).getHeight() == 0.0 && DBMath.areEquals(pt.getX(), ((RectangularShape)bounds).getX()) && DBMath.areEquals(pt.getY(), ((RectangularShape)bounds).getY());
            }
            boolean method = this.isPointInsideCutAlgorithm(pt);
            return method;
        }
        if (this.style == Poly.Type.CROSS || this.style == Poly.Type.BIGCROSS) {
            return DBMath.areEquals(this.getCenterX(), pt.getX()) && DBMath.areEquals(this.getCenterY(), pt.getY());
        }
        if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3 || this.style == Poly.Type.VECTORS) {
            for (Point point : this.points) {
                if (!DBMath.areEquals(pt, point)) continue;
                return true;
            }
            if (this.style == Poly.Type.VECTORS) {
                for (int i = 0; i < this.points.length; i += 2) {
                    if (!DBMath.isOnLine(this.points[i], this.points[i + 1], pt)) continue;
                    return true;
                }
            } else {
                for (int i = 1; i < this.points.length; ++i) {
                    if (!DBMath.isOnLine(this.points[i - 1], this.points[i], pt)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.style == Poly.Type.CIRCLE || this.style == Poly.Type.THICKCIRCLE || this.style == Poly.Type.DISC) {
            double dist = this.points[0].distance(this.points[1]);
            double odist = this.points[0].distance(pt);
            return odist < dist;
        }
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            double wantdist;
            double angrange;
            int startangle;
            int ang = DBMath.figureAngle(this.points[0], pt);
            int endangle = DBMath.figureAngle(this.points[0], this.points[1]);
            if (endangle > (startangle = DBMath.figureAngle(this.points[0], this.points[2]))) {
                if (ang < startangle || ang > endangle) {
                    return false;
                }
                angrange = endangle - startangle;
            } else {
                if (ang < startangle && ang > endangle) {
                    return false;
                }
                angrange = 3600 - startangle + endangle;
            }
            double dist = this.points[0].distance(pt);
            if (ang == startangle || angrange == 0.0) {
                wantdist = this.points[0].distance(this.points[1]);
            } else if (ang == endangle) {
                wantdist = this.points[0].distance(this.points[2]);
            } else {
                double startdist = this.points[0].distance(this.points[1]);
                double enddist = this.points[0].distance(this.points[2]);
                wantdist = enddist == startdist ? startdist : startdist + (double)(ang - startangle) / angrange * (enddist - startdist);
            }
            return DBMath.areEquals(dist, wantdist);
        }
        return false;
    }

    public boolean isInside(Rectangle2D bounds) {
        if (this.style == Poly.Type.CIRCLE || this.style == Poly.Type.THICKCIRCLE || this.style == Poly.Type.DISC) {
            Point ctr = this.points[0];
            double dx = Math.abs(((Point2D)ctr).getX() - this.points[1].getX());
            double dy = Math.abs(((Point2D)ctr).getY() - this.points[1].getY());
            double rad = Math.max(dx, dy);
            if (!DBMath.pointInRect(new Point2D.Double(((Point2D)ctr).getX() + rad, ((Point2D)ctr).getY() + rad), bounds)) {
                return false;
            }
            return DBMath.pointInRect(new Point2D.Double(((Point2D)ctr).getX() - rad, ((Point2D)ctr).getY() - rad), bounds);
        }
        for (Point p : this.points) {
            if (DBMath.pointInRect((Point2D)p, bounds)) continue;
            return false;
        }
        return true;
    }

    public boolean isPointOnCorner(Point2D point) {
        for (Point p : this.points) {
            if (!DBMath.areEquals(point, p)) continue;
            return true;
        }
        return false;
    }

    public void reducePortPoly(PortInst pi, double wid, int angle) {
        PortOriginal fp = new PortOriginal(pi);
        NodeInst ni = fp.getBottomNodeInst();
        if (this.getStyle() != Poly.Type.FILLED && this.getStyle() != Poly.Type.CROSSED && this.getStyle() != Poly.Type.DISC) {
            return;
        }
        if (ni.getTrace() != null) {
            return;
        }
        double realWid = wid / 2.0;
        FixpRectangle portBounds = this.getBox();
        if (portBounds == null) {
            if (this.getStyle() == Poly.Type.DISC) {
                double dist = this.points[0].distance(this.points[1]);
                dist = Math.max(0.0, dist - realWid);
                this.points[1].setLocation(this.points[0].getX() + dist, this.points[0].getY());
                return;
            }
            return;
        }
        double bx = ((RectangularShape)portBounds).getMinX();
        double ux = ((RectangularShape)portBounds).getMaxX();
        double by = ((RectangularShape)portBounds).getMinY();
        double uy = ((RectangularShape)portBounds).getMaxY();
        FixpRectangle r = ni.getBaseShape().getBounds2D();
        double lx = ((RectangularShape)r).getMinX();
        double hx = ((RectangularShape)r).getMaxX();
        double ly = ((RectangularShape)r).getMinY();
        double hy = ((RectangularShape)r).getMaxY();
        if (angle != -1 && angle != 0 && angle != 1800) {
            lx = Math.max(bx, lx + realWid);
            if ((hx = Math.min(ux, hx - realWid)) < lx) {
                hx = lx = (hx + lx) / 2.0;
            }
            if (ux >= lx && bx <= hx) {
                for (Point point : this.points) {
                    double x = ((Point2D)point).getX();
                    if (x < lx) {
                        x = lx;
                    }
                    if (x > hx) {
                        x = hx;
                    }
                    ((Point2D)point).setLocation(x, ((Point2D)point).getY());
                }
            }
        }
        if (angle != -1 && angle != 900 && angle != 2700) {
            ly = Math.max(by, ly + realWid);
            if ((hy = Math.min(uy, hy - realWid)) < ly) {
                hy = ly = (hy + ly) / 2.0;
            }
            if (uy >= ly && by <= hy) {
                for (Point point : this.points) {
                    double y = ((Point2D)point).getY();
                    if (y < ly) {
                        y = ly;
                    }
                    if (y > hy) {
                        y = hy;
                    }
                    ((Point2D)point).setLocation(((Point2D)point).getX(), y);
                }
            }
        }
    }

    public static Poly.Type rotateType(Poly.Type origType, ElectricObject eObj) {
        return origType;
    }

    public static Poly.Type unRotateType(Poly.Type origType, ElectricObject eObj) {
        return origType;
    }

    protected double getTextScale(EditWindow0 wnd, Rectangle2D glyphBounds, Poly.Type style, double lX, double hX, double lY, double hY) {
        double textWidth;
        double textScale = 1.0 / wnd.getScale();
        if (style == Poly.Type.TEXTBOX && (textWidth = glyphBounds.getWidth() * textScale) > hX - lX) {
            textScale *= (hX - lX) / textWidth;
        }
        return textScale;
    }

    public double polyDistance(double x, double y) {
        return this.polyDistance(new Rectangle2D.Double(x, y, 0.0, 0.0));
    }

    public double polyDistance(Rectangle2D otherBounds) {
        FixpRectangle polyBounds = this.getBounds2D();
        double polyCX = ((RectangularShape)polyBounds).getCenterX();
        double polyCY = ((RectangularShape)polyBounds).getCenterY();
        Point2D.Double polyCenter = new Point2D.Double(polyCX, polyCY);
        Poly.Type localStyle = this.style;
        boolean thisIsPoint = ((RectangularShape)polyBounds).getWidth() == 0.0 && ((RectangularShape)polyBounds).getHeight() == 0.0;
        boolean otherIsPoint = otherBounds.getWidth() == 0.0 && otherBounds.getHeight() == 0.0;
        double otherCX = otherBounds.getCenterX();
        double otherCY = otherBounds.getCenterY();
        Point2D.Double otherPt = new Point2D.Double(otherCX, otherCY);
        if (thisIsPoint) {
            if (otherIsPoint ? polyCX == otherCX && polyCY == otherCY : otherBounds.contains(polyCenter)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.FILLED || localStyle == Poly.Type.CROSSED || localStyle.isText()) {
            if (otherIsPoint) {
                if (this.isInside(otherPt)) {
                    return otherPt.distance(polyCenter) - Double.MAX_VALUE;
                }
                FixpRectangle box = this.getBox();
                if (box != null) {
                    polyCX = otherCX > ((RectangularShape)box).getMaxX() ? otherCX - ((RectangularShape)box).getMaxX() : (otherCX < ((RectangularShape)box).getMinX() ? ((RectangularShape)box).getMinX() - otherCX : 0.0);
                    polyCY = otherCY > ((RectangularShape)box).getMaxY() ? otherCY - ((RectangularShape)box).getMaxY() : (otherCY < ((RectangularShape)box).getMinY() ? ((RectangularShape)box).getMinY() - otherCY : 0.0);
                    if (polyCX == 0.0 || polyCY == 0.0) {
                        return polyCX + polyCY;
                    }
                    ((Point2D)polyCenter).setLocation(polyCX, polyCY);
                    return polyCenter.distance(new Point2D.Double(0.0, 0.0));
                }
                localStyle = Poly.Type.CLOSED;
            } else {
                if (DBMath.rectsIntersect(otherBounds, polyBounds)) {
                    return Double.MIN_VALUE;
                }
                return otherPt.distance(polyCenter);
            }
        }
        if (localStyle == Poly.Type.CLOSED) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                Point lastPt = this.points[this.points.length - 1];
                for (int i = 0; i < this.points.length; ++i) {
                    Point thisPt;
                    double dist;
                    if (i != 0) {
                        lastPt = this.points[i - 1];
                    }
                    if (!((dist = DBMath.distToLine(lastPt, thisPt = this.points[i], otherPt)) < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (DBMath.rectsIntersect(otherBounds, polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.OPENED || localStyle == Poly.Type.OPENEDT1 || localStyle == Poly.Type.OPENEDT2 || localStyle == Poly.Type.OPENEDT3) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                for (int i = 1; i < this.points.length; ++i) {
                    Point lastPt = this.points[i - 1];
                    Point thisPt = this.points[i];
                    double dist = DBMath.distToLine(lastPt, thisPt, otherPt);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (DBMath.rectsIntersect(otherBounds, polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.VECTORS) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                for (int i = 0; i < this.points.length; i += 2) {
                    Point lastPt = this.points[i];
                    Point thisPt = this.points[i + 1];
                    double dist = DBMath.distToLine(lastPt, thisPt, otherPt);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (DBMath.rectsIntersect(otherBounds, polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.CIRCLE || localStyle == Poly.Type.THICKCIRCLE || localStyle == Poly.Type.DISC) {
            double odist = this.points[0].distance(this.points[1]);
            double dist = this.points[0].distance(otherPt);
            if (otherIsPoint) {
                if (localStyle == Poly.Type.DISC && dist < odist) {
                    return dist - Double.MAX_VALUE;
                }
                return Math.abs(dist - odist);
            }
            if (this.points[0].getX() + dist < otherBounds.getMinX()) {
                return dist;
            }
            if (this.points[0].getX() - dist > otherBounds.getMaxX()) {
                return dist;
            }
            if (this.points[0].getY() + dist < otherBounds.getMinY()) {
                return dist;
            }
            if (this.points[0].getY() - dist > otherBounds.getMaxY()) {
                return dist;
            }
            return Double.MIN_VALUE;
        }
        if (localStyle == Poly.Type.CIRCLEARC || localStyle == Poly.Type.THICKCIRCLEARC) {
            if (otherIsPoint) {
                double sdist = otherPt.distance(this.points[1]);
                double edist = otherPt.distance(this.points[2]);
                double dist = Math.min(sdist, edist);
                int pang = DBMath.figureAngle(this.points[0], otherPt);
                int sang = DBMath.figureAngle(this.points[0], this.points[1]);
                int eang = DBMath.figureAngle(this.points[0], this.points[2]);
                if (eang > sang ? pang < eang && pang > sang : pang < eang || pang > sang) {
                    return dist;
                }
                double odist = this.points[0].distance(this.points[1]);
                dist = this.points[0].distance(otherPt);
                return Math.abs(dist - odist);
            }
            Point[] savePoints = this.points;
            this.clipArc(otherBounds.getMinX(), otherBounds.getMaxX(), otherBounds.getMinY(), otherBounds.getMaxY());
            Point[] newPoints = this.points;
            this.points = savePoints;
            if (newPoints.length > 0) {
                return Double.MIN_VALUE;
            }
            double dist = this.points[0].distance(this.points[1]);
            return this.points[0].distance(otherPt) - dist;
        }
        return otherPt.distance(polyCenter);
    }

    public double separationBox(PolyBase polyOther) {
        FixpRectangle thisBounds = this.getBox();
        FixpRectangle otherBounds = polyOther.getBox();
        if (thisBounds == null || otherBounds == null) {
            return -1.0;
        }
        double lX1 = ((RectangularShape)thisBounds).getMinX();
        double hX1 = ((RectangularShape)thisBounds).getMaxX();
        double lY1 = ((RectangularShape)thisBounds).getMinY();
        double hY1 = ((RectangularShape)thisBounds).getMaxY();
        double lX2 = ((RectangularShape)otherBounds).getMinX();
        double hX2 = ((RectangularShape)otherBounds).getMaxX();
        double lY2 = ((RectangularShape)otherBounds).getMinY();
        double hY2 = ((RectangularShape)otherBounds).getMaxY();
        double pdx = Math.max(lX2 - hX1, lX1 - hX2);
        double pdy = Math.max(lY2 - hY1, lY1 - hY2);
        double pd = pdx > 0.0 && pdy > 0.0 ? Math.hypot(pdx, pdy) : Math.max(pdx, pdy);
        return pd;
    }

    public double separation(PolyBase polyOther) {
        if (this.intersects(polyOther)) {
            return 0.0;
        }
        double minPD = 0.0;
        for (int i = 0; i < this.points.length; ++i) {
            Point2D c = polyOther.closestPoint(this.points[i]);
            double pd = c.distance(this.points[i]);
            if (pd <= 0.0) {
                return 0.0;
            }
            if (i == 0) {
                minPD = pd;
                continue;
            }
            if (!(pd < minPD)) continue;
            minPD = pd;
        }
        for (Point point : polyOther.points) {
            Point2D c = this.closestPoint(point);
            double pd = c.distance(point);
            if (pd <= 0.0) {
                return 0.0;
            }
            if (!(pd < minPD)) continue;
            minPD = pd;
        }
        double minPDman = this.separationBox(polyOther);
        if (minPDman != -1.0 && minPDman < minPD) {
            minPD = minPDman;
        }
        return minPD;
    }

    public Point2D closestPoint(Point2D pt) {
        FixpRectangle bounds;
        Poly.Type localStyle = this.style;
        if (localStyle == Poly.Type.FILLED || localStyle == Poly.Type.CROSSED || localStyle == Poly.Type.TEXTCENT || localStyle.isText()) {
            bounds = this.getBox();
            if (bounds != null) {
                double x = pt.getX();
                double y = pt.getY();
                if (x < ((RectangularShape)bounds).getMinX()) {
                    x = ((RectangularShape)bounds).getMinX();
                }
                if (x > ((RectangularShape)bounds).getMaxX()) {
                    x = ((RectangularShape)bounds).getMaxX();
                }
                if (y < ((RectangularShape)bounds).getMinY()) {
                    y = ((RectangularShape)bounds).getMinY();
                }
                if (y > ((RectangularShape)bounds).getMaxY()) {
                    y = ((RectangularShape)bounds).getMaxY();
                }
                return new Point2D.Double(x, y);
            }
            if (localStyle == Poly.Type.FILLED && this.isInside(pt)) {
                return pt;
            }
            localStyle = Poly.Type.CLOSED;
        }
        if (localStyle == Poly.Type.CLOSED) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 0; i < this.points.length; ++i) {
                int lastI = i == 0 ? this.points.length - 1 : i - 1;
                Point2D pc = DBMath.closestPointToSegment((Point2D)this.points[lastI], (Point2D)this.points[i], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        if (localStyle == Poly.Type.OPENED || localStyle == Poly.Type.OPENEDT1 || localStyle == Poly.Type.OPENEDT2 || localStyle == Poly.Type.OPENEDT3) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 1; i < this.points.length; ++i) {
                Point2D pc = DBMath.closestPointToSegment((Point2D)this.points[i - 1], (Point2D)this.points[i], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        if (localStyle == Poly.Type.VECTORS) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 0; i < this.points.length; i += 2) {
                Point2D pc = DBMath.closestPointToSegment((Point2D)this.points[i], (Point2D)this.points[i + 1], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        bounds = this.getBounds2D();
        return new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.isInside(new Point2D.Double(x, y));
    }

    @Override
    public boolean contains(Point2D p) {
        return this.isInside(p);
    }

    @Override
    public boolean contains(double lX, double lY, double w, double h) {
        double hX = lX + w;
        double hY = lY + h;
        if (!(this.isInside(new Point2D.Double(lX, lY)) && this.isInside(new Point2D.Double(hX, lY)) && this.isInside(new Point2D.Double(lX, hY)) && this.isInside(new Point2D.Double(hX, hY)))) {
            return false;
        }
        for (int i = 0; i < this.points.length; ++i) {
            int last = i - 1;
            if (last < 0) {
                last = this.points.length - 1;
            }
            Point2D.Double thisPt = new Point2D.Double(this.points[i].getX(), this.points[i].getY());
            Point2D.Double lastPt = new Point2D.Double(this.points[last].getX(), this.points[last].getY());
            boolean invisible = GenMath.clipLine(lastPt, thisPt, lX, hX, lY, hY);
            if (invisible || ((Point2D)lastPt).getX() == ((Point2D)thisPt).getX() && (((Point2D)lastPt).getY() != ((Point2D)thisPt).getY() ? ((Point2D)thisPt).getX() <= lX || ((Point2D)thisPt).getX() >= hX : ((Point2D)thisPt).getX() <= lX || ((Point2D)thisPt).getX() >= hX || ((Point2D)thisPt).getY() <= lY || ((Point2D)thisPt).getY() >= hY)) continue;
            if (((Point2D)lastPt).getY() == ((Point2D)thisPt).getY() && (((Point2D)thisPt).getY() <= lY || ((Point2D)thisPt).getY() >= hY)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        throw new Error("intersects method not implemented in Poly.intersects()");
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(PolyBase polyOther) {
        FixpRectangle thisBounds = this.getBounds2D();
        FixpRectangle otherBounds = polyOther.getBounds2D();
        if (((RectangularShape)thisBounds).getMaxX() < ((RectangularShape)otherBounds).getMinX() || ((RectangularShape)otherBounds).getMaxX() < ((RectangularShape)thisBounds).getMinX() || ((RectangularShape)thisBounds).getMaxY() < ((RectangularShape)otherBounds).getMinY() || ((RectangularShape)otherBounds).getMaxY() < ((RectangularShape)thisBounds).getMinY()) {
            return false;
        }
        int count = this.points.length;
        for (int i = 0; i < count; ++i) {
            Point p;
            if (i == 0) {
                if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3 || this.style == Poly.Type.VECTORS) continue;
                p = this.points[count - 1];
            } else {
                p = this.points[i - 1];
            }
            Point t = this.points[i];
            if (this.style == Poly.Type.VECTORS && (i & 1) != 0) {
                ++i;
            }
            if (((Point2D)p).getX() == ((Point2D)t).getX() && ((Point2D)p).getY() == ((Point2D)t).getY() || Math.min(((Point2D)p).getX(), ((Point2D)t).getX()) > ((RectangularShape)otherBounds).getMaxX() || Math.max(((Point2D)p).getX(), ((Point2D)t).getX()) < ((RectangularShape)otherBounds).getMinX() || Math.min(((Point2D)p).getY(), ((Point2D)t).getY()) > ((RectangularShape)otherBounds).getMaxY() || Math.max(((Point2D)p).getY(), ((Point2D)t).getY()) < ((RectangularShape)otherBounds).getMinY() || !polyOther.lineIntersect(p, t)) continue;
            return true;
        }
        return false;
    }

    public List<PolyBase> getIntersection(PolyBase polyOther, List<Line2D> overlappingEdges) {
        if (overlappingEdges != null) {
            List<Line2D> overlaps = this.getOverlappingEdges(polyOther);
            overlappingEdges.addAll(overlaps);
        }
        Area myArea = new Area(this);
        Area otherArea = new Area(polyOther);
        myArea.intersect(otherArea);
        List<PolyBase> polys = PolyBase.getPointsInArea(myArea, this.layer, true, false);
        if (polys == null) {
            return null;
        }
        return polys;
    }

    public List<Line2D> getOverlappingEdges(PolyBase polyOther) {
        ArrayList<Line2D> overlappingSegs = new ArrayList<Line2D>();
        FixpRectangle thisBounds = this.getBounds2D();
        FixpRectangle otherBounds = polyOther.getBounds2D();
        if (((RectangularShape)thisBounds).getMaxX() < ((RectangularShape)otherBounds).getMinX() || ((RectangularShape)otherBounds).getMaxX() < ((RectangularShape)thisBounds).getMinX() || ((RectangularShape)thisBounds).getMaxY() < ((RectangularShape)otherBounds).getMinY() || ((RectangularShape)otherBounds).getMaxY() < ((RectangularShape)thisBounds).getMinY()) {
            return overlappingSegs;
        }
        List<Line2D> myLineSegs = this.getLineSegments();
        List<Line2D> otherLineSegs = polyOther.getLineSegments();
        for (Line2D line1 : myLineSegs) {
            for (Line2D line2 : otherLineSegs) {
                Line2D seg = PolyBase.getLineOverlap(line1, line2);
                if (seg == null) continue;
                overlappingSegs.add(seg);
            }
        }
        ArrayList<Line2D> realLines = new ArrayList<Line2D>();
        ArrayList<Line2D> points = new ArrayList<Line2D>();
        for (Line2D seg : overlappingSegs) {
            if (seg.getP1().equals(seg.getP2())) {
                points.add(seg);
                continue;
            }
            realLines.add(seg);
        }
        for (Line2D p : points) {
            boolean redundant = false;
            for (Line2D seg : realLines) {
                if (!p.getP1().equals(seg.getP1()) && !p.getP1().equals(seg.getP2())) continue;
                redundant = true;
                break;
            }
            if (redundant) continue;
            realLines.add(p);
        }
        return realLines;
    }

    private List<Line2D> getLineSegments() {
        ArrayList<Line2D> lineSegs = new ArrayList<Line2D>();
        for (int i = 0; i < this.points.length; ++i) {
            Point p;
            if (i == 0) {
                if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3 || this.style == Poly.Type.VECTORS) continue;
                p = this.points[this.points.length - 1];
            } else {
                p = this.points[i - 1];
            }
            Point t = this.points[i];
            if (this.style == Poly.Type.VECTORS && (i & 1) != 0) {
                ++i;
            }
            if (((Point2D)p).getX() == ((Point2D)t).getX() && ((Point2D)p).getY() == ((Point2D)t).getY()) continue;
            lineSegs.add(new Line2D.Double(p, t));
        }
        return lineSegs;
    }

    public static Point2D getLineSegmentIntersection(Line2D line1, Line2D line2) {
        double[] co2;
        if (!line1.intersectsLine(line2)) {
            return null;
        }
        double[] co1 = PolyBase.getLineCoeffs(line1);
        double det = co1[0] * (co2 = PolyBase.getLineCoeffs(line2))[1] - co2[0] * co1[1];
        if (det == 0.0) {
            return null;
        }
        double x = (co2[1] * co1[2] - co1[1] * co2[2]) / det;
        double y = (co1[0] * co2[2] - co2[0] * co1[2]) / det;
        if (x == -0.0) {
            x = 0.0;
        }
        if (y == -0.0) {
            y = 0.0;
        }
        return new Point2D.Double(x, y);
    }

    public static Line2D getLineOverlap(Line2D line1, Line2D line2) {
        double[] co2;
        if (!line1.intersectsLine(line2)) {
            return null;
        }
        double[] co1 = PolyBase.getLineCoeffs(line1);
        double det = co1[0] * (co2 = PolyBase.getLineCoeffs(line2))[1] - co2[0] * co1[1];
        if (det != 0.0) {
            return null;
        }
        double minX1 = Math.min(line1.getX1(), line1.getX2());
        double minX2 = Math.min(line2.getX1(), line2.getX2());
        double minX = Math.max(minX1, minX2);
        double minY1 = Math.min(line1.getY1(), line1.getY2());
        double minY2 = Math.min(line2.getY1(), line2.getY2());
        double minY = Math.max(minY1, minY2);
        double maxX1 = Math.max(line1.getX1(), line1.getX2());
        double maxX2 = Math.max(line2.getX1(), line2.getX2());
        double maxX = Math.min(maxX1, maxX2);
        double maxY1 = Math.max(line1.getY1(), line1.getY2());
        double maxY2 = Math.max(line2.getY1(), line2.getY2());
        double maxY = Math.min(maxY1, maxY2);
        Point2D.Double p1 = new Point2D.Double(minX, minY);
        Point2D.Double p2 = new Point2D.Double(maxX, maxY);
        return new Line2D.Double(p1, p2);
    }

    private static double[] getLineCoeffs(Line2D line) {
        double A = line.getP2().getY() - line.getP1().getY();
        double B = line.getP1().getX() - line.getP2().getX();
        double C = A * line.getP1().getX() + B * line.getP1().getY();
        return new double[]{A, B, C};
    }

    private boolean lineIntersect(Point2D p1, Point2D t1) {
        int count = this.points.length;
        for (int i = 0; i < count; ++i) {
            int ang;
            Point p2;
            if (i == 0) {
                if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3 || this.style == Poly.Type.VECTORS) continue;
                p2 = this.points[count - 1];
            } else {
                p2 = this.points[i - 1];
            }
            Point t2 = this.points[i];
            if (this.style == Poly.Type.VECTORS && (i & 1) != 0) {
                ++i;
            }
            if (((Point2D)t2).getX() == p1.getX() && ((Point2D)t2).getY() == p1.getY()) {
                return true;
            }
            if (((Point2D)t2).getX() == t1.getX() && ((Point2D)t2).getY() == t1.getY()) {
                return true;
            }
            if (((Point2D)p2).getX() == ((Point2D)t2).getX() && ((Point2D)p2).getY() == ((Point2D)t2).getY()) continue;
            if (((Point2D)p2).getX() == ((Point2D)t2).getX()) {
                if (Math.min(p1.getX(), t1.getX()) > ((Point2D)p2).getX() || Math.max(p1.getX(), t1.getX()) < ((Point2D)p2).getX()) continue;
                if (p1.getX() == t1.getX()) {
                    if (Math.min(p1.getY(), t1.getY()) > Math.max(((Point2D)p2).getY(), ((Point2D)t2).getY()) || Math.max(p1.getY(), t1.getY()) < Math.min(((Point2D)p2).getY(), ((Point2D)t2).getY())) continue;
                    return true;
                }
                if (p1.getY() == t1.getY()) {
                    if (Math.min(((Point2D)p2).getY(), ((Point2D)t2).getY()) > p1.getY() || Math.max(((Point2D)p2).getY(), ((Point2D)t2).getY()) < p1.getY()) continue;
                    return true;
                }
                ang = DBMath.figureAngle(p1, t1);
                Point2D inter = DBMath.intersect(p2, 900, p1, ang);
                if (inter == null || inter.getX() != ((Point2D)p2).getX() || inter.getY() < Math.min(((Point2D)p2).getY(), ((Point2D)t2).getY()) || inter.getY() > Math.max(((Point2D)p2).getY(), ((Point2D)t2).getY())) continue;
                return true;
            }
            if (((Point2D)p2).getY() == ((Point2D)t2).getY()) {
                if (Math.min(p1.getY(), t1.getY()) > ((Point2D)p2).getY() || Math.max(p1.getY(), t1.getY()) < ((Point2D)p2).getY()) continue;
                if (p1.getY() == t1.getY()) {
                    if (Math.min(p1.getX(), t1.getX()) > Math.max(((Point2D)p2).getX(), ((Point2D)t2).getX()) || Math.max(p1.getX(), t1.getX()) < Math.min(((Point2D)p2).getX(), ((Point2D)t2).getX())) continue;
                    return true;
                }
                if (p1.getX() == t1.getX()) {
                    if (Math.min(((Point2D)p2).getX(), ((Point2D)t2).getX()) > p1.getX() || Math.max(((Point2D)p2).getX(), ((Point2D)t2).getX()) < p1.getX()) continue;
                    return true;
                }
                ang = DBMath.figureAngle(p1, t1);
                Point2D inter = DBMath.intersect(p2, 0, p1, ang);
                if (inter == null || inter.getY() != ((Point2D)p2).getY() || inter.getX() < Math.min(((Point2D)p2).getX(), ((Point2D)t2).getX()) || inter.getX() > Math.max(((Point2D)p2).getX(), ((Point2D)t2).getX())) continue;
                return true;
            }
            if (Math.min(p1.getX(), t1.getX()) > Math.max(((Point2D)p2).getX(), ((Point2D)t2).getX()) || Math.max(p1.getX(), t1.getX()) < Math.min(((Point2D)p2).getX(), ((Point2D)t2).getX()) || Math.min(p1.getY(), t1.getY()) > Math.max(((Point2D)p2).getY(), ((Point2D)t2).getY()) || Math.max(p1.getY(), t1.getY()) < Math.min(((Point2D)p2).getY(), ((Point2D)t2).getY())) continue;
            int ang1 = DBMath.figureAngle(p1, t1);
            int ang2 = DBMath.figureAngle(p2, t2);
            Point2D inter = DBMath.intersect(p2, ang2, p1, ang1);
            if (inter == null || inter.getX() < Math.min(((Point2D)p2).getX(), ((Point2D)t2).getX()) || inter.getX() > Math.max(((Point2D)p2).getX(), ((Point2D)t2).getX()) || inter.getY() < Math.min(((Point2D)p2).getY(), ((Point2D)t2).getY()) || inter.getY() > Math.max(((Point2D)p2).getY(), ((Point2D)t2).getY()) || inter.getX() < Math.min(p1.getX(), t1.getX()) || inter.getX() > Math.max(p1.getX(), t1.getX()) || inter.getY() < Math.min(p1.getY(), t1.getY()) || inter.getY() > Math.max(p1.getY(), t1.getY())) continue;
            return true;
        }
        return false;
    }

    public double getPerimeter() {
        double perim = 0.0;
        int start = 0;
        if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3) {
            start = 1;
        }
        for (int i = start; i < this.points.length; ++i) {
            int j = i - 1;
            if (j < 0) {
                j = this.points.length - 1;
            }
            perim += this.points[i].distance(this.points[j]);
        }
        return perim;
    }

    public double getMaxLength() {
        double max = 0.0;
        int start = 0;
        if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3) {
            start = 1;
        }
        for (int i = start; i < this.points.length; ++i) {
            double distance;
            int j = i - 1;
            if (j < 0) {
                j = this.points.length - 1;
            }
            if (!(max < (distance = this.points[i].distance(this.points[j])))) continue;
            max = distance;
        }
        return max;
    }

    public double getArea() {
        if (this.style == Poly.Type.FILLED || this.style == Poly.Type.CLOSED || this.style == Poly.Type.CROSSED || this.style.isText()) {
            FixpRectangle bounds = this.getBox();
            if (bounds != null) {
                double area = GenMath.getArea(bounds);
                return Math.abs(area);
            }
            return GenMath.getAreaOfPoints(this.points);
        }
        return 0.0;
    }

    public double getCenterX() {
        FixpRectangle b = this.getBounds2D();
        return ((RectangularShape)b).getCenterX();
    }

    public double getCenterY() {
        FixpRectangle b = this.getBounds2D();
        return ((RectangularShape)b).getCenterY();
    }

    public EPoint getCenter() {
        FixpRectangle b = this.getBounds2D();
        return EPoint.fromLambda(((RectangularShape)b).getCenterX(), ((RectangularShape)b).getCenterY());
    }

    @Override
    public FixpRectangle getBounds2D() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        return this.bounds;
    }

    @Override
    @Deprecated
    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        FixpRectangle r = this.getBounds2D();
        return new Rectangle((int)((RectangularShape)r).getMinX(), (int)((RectangularShape)r).getMinY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
    }

    public void setPoint(int pt, double x, double y) {
        this.points[pt].setLocation(x, y);
        this.bounds = null;
    }

    private void calcBounds() {
        this.bounds = null;
        if (this.style == Poly.Type.CIRCLE || this.style == Poly.Type.THICKCIRCLE || this.style == Poly.Type.DISC) {
            long cX = this.points[0].getFixpX();
            long cY = this.points[0].getFixpY();
            long radius = FixpCoord.lambdaToFixp(this.points[0].distance(this.points[1]));
            this.bounds = FixpRectangle.fromFixpDiagonal(cX - radius, cY - radius, cX + radius, cY + radius);
            return;
        }
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            this.bounds = FixpRectangle.from(GenMath.arcBBox(this.points[1], this.points[2], this.points[0]));
            return;
        }
        if (this.points.length > 0) {
            long lY;
            long lX;
            long hX = lX = this.points[0].getFixpX();
            long hY = lY = this.points[0].getFixpY();
            for (int i = 1; i < this.points.length; ++i) {
                long x = this.points[i].getFixpX();
                long y = this.points[i].getFixpY();
                if (x < lX) {
                    lX = x;
                }
                if (x > hX) {
                    hX = x;
                }
                if (y < lY) {
                    lY = y;
                }
                if (y <= hY) continue;
                hY = y;
            }
            this.bounds = FixpRectangle.fromFixpDiagonal(lX, lY, hX, hY);
        } else {
            this.bounds = FixpRectangle.fromFixpDiagonal(0L, 0L, 0L, 0L);
        }
    }

    public void roundPoints() {
        this.bounds = null;
        for (Point point : this.points) {
            ((Point2D)point).setLocation(DBMath.round(((Point2D)point).getX()), DBMath.round(((Point2D)point).getY()));
        }
    }

    public static List<PolyBase> getPointsInArea(Area area, Layer layer, boolean simple, boolean includeLastPoint) {
        if (area == null) {
            return null;
        }
        boolean isSingular = area.isSingular();
        if (!isSingular) {
            return PolyBase.getPointsFromComplex(area, layer);
        }
        double[] coords = new double[6];
        ArrayList<Point> pointList = new ArrayList<Point>();
        Point lastMoveTo = null;
        ArrayList<PolyBase> toDelete = new ArrayList<PolyBase>();
        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                if (includeLastPoint && lastMoveTo != null) {
                    pointList.add(lastMoveTo);
                }
                PolyBase poly = new PolyBase(pointList.toArray(new Point[pointList.size()]));
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                lastMoveTo = null;
                toDelete.clear();
                if (!simple && !isSingular) {
                    for (PolyBase pn : polyList) {
                        if (!pn.contains((Point2D)pointList.get(0)) && !poly.contains(pn.getPoints()[0])) continue;
                        poly = new PolyBase((Point[])pn.getPoints().clone());
                        toDelete.add(pn);
                    }
                }
                if (poly != null) {
                    polyList.add(poly);
                }
                polyList.removeAll(toDelete);
                pointList.clear();
            } else if (type == 0 || type == 1) {
                Point pt = PolyBase.fromLambda(coords[0], coords[1]);
                pointList.add(pt);
                if (type == 0) {
                    lastMoveTo = pt;
                }
            }
            pIt.next();
        }
        return polyList;
    }

    public static List<PolyBaseTree> getPolyTrees(Area area, Layer layer) {
        List<PolyBase> list = PolyBase.getLoopsFromArea(area, layer);
        List<PolyBaseTree> roots = PolyBase.getTreesFromLoops(list);
        return roots;
    }

    public static List<PolyBaseTree> getTreesFromLoops(List<PolyBase> list) {
        ArrayList<PolyBaseTree> roots = new ArrayList<PolyBaseTree>();
        for (int i = list.size() - 1; i > -1; --i) {
            PolyBaseTreeImpl t = new PolyBaseTreeImpl(list.get(i));
            boolean added = false;
            for (PolyBaseTree r : roots) {
                if (!((PolyBaseTreeImpl)r).add(t)) continue;
                added = true;
                break;
            }
            if (added) continue;
            roots.add(t);
        }
        return roots;
    }

    public static List<PolyBase> getLoopsFromArea(Area area, Layer layer) {
        if (area == null) {
            return null;
        }
        double[] coords = new double[6];
        ArrayList<Point> pointList = new ArrayList<Point>();
        ArrayList<PolyBase> list = new ArrayList<PolyBase>();
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                boolean hasArea = false;
                for (int i = 1; i < pointList.size(); ++i) {
                    if (!(((Point)pointList.get(i - 1)).distance((Point2D)pointList.get(i)) > 1.0E-5)) continue;
                    hasArea = true;
                    break;
                }
                if (hasArea) {
                    PolyBase poly = new PolyBase(pointList.toArray(new Point[pointList.size()]));
                    poly.setLayer(layer);
                    poly.setStyle(Poly.Type.FILLED);
                    list.add(poly);
                }
                pointList.clear();
            } else if (type == 0 || type == 1) {
                Point pt = PolyBase.fromLambda(coords[0], coords[1]);
                pointList.add(pt);
            }
            pIt.next();
        }
        Collections.sort(list, AREA_COMPARATOR);
        return list;
    }

    private static List<PolyBase> getPointsFromComplex(Area area, Layer layer) {
        List<PolyBase> list = PolyBase.getLoopsFromArea(area, layer);
        List<PolyBaseTree> roots = PolyBase.getTreesFromLoops(list);
        list.clear();
        for (PolyBaseTree r : roots) {
            int count = 0;
            Stack<PolyBase> s = new Stack<PolyBase>();
            ((PolyBaseTreeImpl)r).getLoops(count, s);
            list.addAll(s);
        }
        return list;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new PolyPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Poly poly = (Poly)obj;
        if (this.getLayerOrPseudoLayer() != poly.getLayerOrPseudoLayer()) {
            return false;
        }
        boolean geometryCheck = this.polySame(poly);
        return geometryCheck;
    }

    public static int cropBox(Rectangle2D bounds, Rectangle2D PUBox) {
        double yoverlap;
        boolean uhY;
        double bX = PUBox.getMinX();
        double uX = PUBox.getMaxX();
        double bY = PUBox.getMinY();
        double uY = PUBox.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (!(DBMath.isGreaterThan(hX, bX) && DBMath.isGreaterThan(hY, bY) && DBMath.isGreaterThan(uX, lX) && DBMath.isGreaterThan(uY, lY))) {
            return 0;
        }
        boolean blX = !DBMath.isGreaterThan(bX, lX);
        boolean uhX = !DBMath.isGreaterThan(hX, uX);
        boolean blY = !DBMath.isGreaterThan(bY, lY);
        boolean bl = uhY = !DBMath.isGreaterThan(hY, uY);
        if (blX && uhX && blY && uhY) {
            return 1;
        }
        double xoverlap = Math.min(hX, uX) - Math.max(lX, bX);
        if (xoverlap > (yoverlap = Math.min(hY, uY) - Math.max(lY, bY))) {
            if (blX && uhX) {
                if (!DBMath.isGreaterThan(hY, uY)) {
                    hY = bY;
                }
                if (blY) {
                    lY = uY;
                }
                if (!DBMath.isGreaterThan(hY, lY)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
        } else if (blY && uhY) {
            if (!DBMath.isGreaterThan(hX, uX)) {
                hX = bX;
            }
            if (blX) {
                lX = uX;
            }
            if (!DBMath.isGreaterThan(hX, lX)) {
                return 1;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            return 0;
        }
        return -1;
    }

    public static int cropBoxComplete(Rectangle2D bounds, Rectangle2D PUBox) {
        boolean uhY;
        double bX = PUBox.getMinX();
        double uX = PUBox.getMaxX();
        double bY = PUBox.getMinY();
        double uY = PUBox.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (!(DBMath.isGreaterThan(hX, bX) && DBMath.isGreaterThan(hY, bY) && DBMath.isGreaterThan(uX, lX) && DBMath.isGreaterThan(uY, lY))) {
            return -2;
        }
        boolean blX = !DBMath.isGreaterThan(bX, lX);
        boolean uhX = !DBMath.isGreaterThan(hX, uX);
        boolean blY = !DBMath.isGreaterThan(bY, lY);
        boolean bl = uhY = !DBMath.isGreaterThan(hY, uY);
        if (blX && uhX && blY && uhY) {
            return 1;
        }
        if (bX <= lX) {
            lX = uX;
        }
        if (bY >= lY) {
            hY = bY;
        }
        if (uY <= hY) {
            lY = hY;
        }
        if (hX <= uX) {
            hX = bX;
        }
        bounds.setRect(lX, lY, hX - lX, hY - lY);
        return 0;
    }

    public static int halfCropBox(Rectangle2D bounds, Rectangle2D limit) {
        boolean uhY;
        double bX = limit.getMinX();
        double uX = limit.getMaxX();
        double bY = limit.getMinY();
        double uY = limit.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (!(DBMath.isGreaterThan(hX, bX) && DBMath.isGreaterThan(hY, bY) && DBMath.isGreaterThan(uX, lX) && DBMath.isGreaterThan(uY, lY))) {
            return 0;
        }
        boolean blX = !DBMath.isGreaterThan(bX, lX);
        boolean uhX = !DBMath.isGreaterThan(hX, uX);
        boolean blY = !DBMath.isGreaterThan(bY, lY);
        boolean bl = uhY = !DBMath.isGreaterThan(hY, uY);
        if (blX && uhX && blY && uhY) {
            double lxe = lX - bX;
            double hxe = uX - hX;
            double lye = lY - bY;
            double hye = uY - hY;
            double biggestExt = Math.max(Math.max(lxe, hxe), Math.max(lye, hye));
            if (DBMath.areEquals(biggestExt, 0.0)) {
                return 1;
            }
            if (DBMath.areEquals(lxe, biggestExt)) {
                if (!DBMath.isGreaterThan(hX, lX = (lX + uX) / 2.0)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (DBMath.areEquals(hxe, biggestExt)) {
                if (!DBMath.isGreaterThan(hX = (hX + bX) / 2.0, lX)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (DBMath.areEquals(lye, biggestExt)) {
                if (!DBMath.isGreaterThan(hY, lY = (lY + uY) / 2.0)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (DBMath.areEquals(hye, biggestExt)) {
                if (!DBMath.isGreaterThan(hY = (hY + bY) / 2.0, lY)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
        }
        boolean crops = false;
        if (blX && uhX) {
            if (!DBMath.isGreaterThan(hY, uY)) {
                hY = (hY + bY) / 2.0;
            }
            if (blY) {
                lY = (lY + uY) / 2.0;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            crops = true;
        }
        if (blY && uhY) {
            if (!DBMath.isGreaterThan(hX, uX)) {
                hX = (hX + bX) / 2.0;
            }
            if (blX) {
                lX = (lX + uX) / 2.0;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            crops = true;
        }
        if (!crops) {
            return -1;
        }
        return 0;
    }

    public void clipArc(double lx, double hx, double ly, double hy) {
        double plx = this.bounds.getMinX();
        double phx = this.bounds.getMaxX();
        double ply = this.bounds.getMinY();
        double phy = this.bounds.getMaxY();
        if (plx >= lx && phx <= hx && ply >= ly && phy <= hy) {
            return;
        }
        if (plx > hx || phx < lx || ply > hy || phy < ly) {
            this.points = new Point[0];
            return;
        }
        double xc = this.points[0].getX();
        double yc = this.points[0].getY();
        double xp = this.points[1].getX();
        double yp = this.points[1].getY();
        ArrayList<AngleList> curveList = new ArrayList<AngleList>();
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            AngleList al1 = new AngleList(this.points[1]);
            double dx = xp - xc;
            double dy = yp - yc;
            if (dx == 0.0 && dy == 0.0) {
                System.out.println("Domain error doing circle/circle tangents");
                this.points = new Point[0];
                return;
            }
            al1.angle = Math.atan2(dy, dx);
            curveList.add(al1);
            AngleList al2 = new AngleList(this.points[2]);
            dx = al1.x - xc;
            dy = al1.y - yc;
            if (dx == 0.0 && dy == 0.0) {
                System.out.println("Domain error doing circle/circle tangents");
                this.points = new Point[0];
                return;
            }
            al2.angle = Math.atan2(dy, dx);
            curveList.add(al2);
        }
        int initialCount = curveList.size();
        Point2D.Double i1 = new Point2D.Double(lx, ly);
        Point2D.Double i2 = new Point2D.Double(lx, hy);
        int ints = this.circlelineintersection(this.points[0], this.points[1], i1, i2, 0.0);
        if (ints > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i2));
        }
        if ((ints = this.circlelineintersection(this.points[0], this.points[1], i1 = new Point2D.Double(lx, hy), i2 = new Point2D.Double(hx, hy), 0.0)) > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i2));
        }
        if ((ints = this.circlelineintersection(this.points[0], this.points[1], i1 = new Point2D.Double(hx, hy), i2 = new Point2D.Double(hx, ly), 0.0)) > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i2));
        }
        if ((ints = this.circlelineintersection(this.points[0], this.points[1], i1 = new Point2D.Double(hx, ly), i2 = new Point2D.Double(lx, ly), 0.0)) > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i2));
        }
        if (curveList.size() == initialCount) {
            this.points = new Point[0];
            return;
        }
        for (int i = initialCount; i < curveList.size(); ++i) {
            AngleList al = (AngleList)curveList.get(i);
            if (al.y == yc && al.x == xc) {
                System.out.println("Warning: instability ahead");
                this.points = new Point[0];
                return;
            }
            double dx = al.x - xc;
            double dy = al.y - yc;
            if (dx == 0.0 && dy == 0.0) {
                System.out.println("Domain error doing circle/circle tangents");
                this.points = new Point[0];
                return;
            }
            al.angle = Math.atan2(dy, dx);
        }
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            int j = 2;
            AngleList al0 = (AngleList)curveList.get(0);
            AngleList al1 = (AngleList)curveList.get(1);
            for (int i = 2; i < curveList.size(); ++i) {
                AngleList al = (AngleList)curveList.get(i);
                if (al0.angle > al1.angle ? al.angle > al0.angle || al.angle < al1.angle : al.angle > al0.angle && al.angle < al1.angle) continue;
                AngleList alj = (AngleList)curveList.get(j);
                alj.x = al.x;
                alj.y = al.y;
                alj.angle = al.angle;
                ++j;
            }
            while (curveList.size() > j) {
                curveList.remove(curveList.size() - 1);
            }
            al0 = (AngleList)curveList.get(0);
            for (AngleList al : curveList) {
                if (!(al.angle > al0.angle)) continue;
                al.angle -= Math.PI * 2;
            }
        } else {
            for (AngleList al : curveList) {
                if (!(al.angle > 0.0)) continue;
                al.angle -= Math.PI * 2;
            }
        }
        Collections.sort(curveList, new AngleListDescending());
        if (this.style != Poly.Type.CIRCLEARC && this.style != Poly.Type.THICKCIRCLEARC) {
            AngleList al0 = (AngleList)curveList.get(0);
            AngleList alNew = new AngleList(new Point2D.Double(al0.x, al0.y));
            alNew.angle = al0.angle - Math.PI * 2;
            curveList.add(alNew);
        }
        double radius = this.points[0].distance(this.points[1]);
        ArrayList<Point> newIn = new ArrayList<Point>();
        for (int i = 1; i < curveList.size(); ++i) {
            double midAngle;
            int prev = i - 1;
            AngleList al = (AngleList)curveList.get(i);
            AngleList alP = (AngleList)curveList.get(prev);
            for (midAngle = (alP.angle + al.angle) / 2.0; midAngle < -Math.PI; midAngle += Math.PI * 2) {
            }
            double midx = xc + radius * Math.cos(midAngle);
            double midy = yc + radius * Math.sin(midAngle);
            if (midx < lx || midx > hx || midy < ly || midy > hy) continue;
            newIn.add(PolyBase.fromLambda(xc, yc));
            newIn.add(PolyBase.fromLambda(alP.x, alP.y));
            newIn.add(PolyBase.fromLambda(al.x, al.y));
        }
        this.points = newIn.toArray(new Point[newIn.size()]);
        if (this.style == Poly.Type.THICKCIRCLE) {
            this.style = Poly.Type.THICKCIRCLEARC;
        } else if (this.style == Poly.Type.CIRCLE) {
            this.style = Poly.Type.CIRCLEARC;
        }
    }

    private int circlelineintersection(Point2D ctr, Point2D edge, Point2D from, Point2D to, double tolerance) {
        double fy;
        double fx;
        double icx = ctr.getX();
        double icy = ctr.getY();
        double isx = edge.getX();
        double isy = edge.getY();
        double lx1 = from.getX();
        double ly1 = from.getY();
        double lx2 = to.getX();
        double ly2 = to.getY();
        double segx = 0.0;
        double segy = 0.0;
        if (ly1 == ly2) {
            segx = icx;
            segy = ly1;
        } else if (lx1 == lx2) {
            segx = lx1;
            segy = icy;
        } else {
            fx = lx1 - lx2;
            fy = ly1 - ly2;
            double m = fy / fx;
            double b = -lx1;
            b *= m;
            double mi = -1.0 / m;
            double bi = -icx;
            bi *= mi;
            segx = ((bi += icy) - (b += ly1)) / (m - mi);
            segy = m * segx + b;
        }
        if (segx == icx && segy == icy) {
            fx = isx - icx;
            fy = isy - icy;
            radius = Math.hypot(fx, fy);
            fx = lx2 - lx1;
            fy = ly2 - ly1;
            if (fx == 0.0 && fy == 0.0) {
                System.out.println("Domain error doing circle/line intersection");
                return 0;
            }
            double angle = Math.atan2(fy, fx);
            from.setLocation(icx + Math.cos(angle) * radius, icy + Math.sin(angle) * radius);
            to.setLocation(icx + Math.cos(-angle) * radius, icy + Math.sin(-angle) * radius);
        } else {
            fx = isx - icx;
            fy = isy - icy;
            radius = Math.hypot(fx, fy);
            fx = segx - icx;
            fy = segy - icy;
            double adjacent = Math.hypot(fx, fy);
            if (Math.abs(adjacent - radius) < tolerance) {
                from.setLocation(segx, segy);
                return 1;
            }
            if (adjacent > radius) {
                return 0;
            }
            if (radius == 0.0) {
                from.setLocation(icx, icy);
                to.setLocation(icx, icy);
            } else {
                double angle = Math.acos(adjacent / radius);
                fx = segx - icx;
                fy = segy - icy;
                if (fx == 0.0 && fy == 0.0) {
                    System.out.println("Domain error doing line/circle intersection");
                    return 0;
                }
                double intangle = Math.atan2(fy, fx);
                double a1 = intangle - angle;
                double a2 = intangle + angle;
                from.setLocation(icx + Math.cos(a1) * radius, icy + Math.sin(a1) * radius);
                to.setLocation(icx + Math.cos(a2) * radius, icy + Math.sin(a2) * radius);
            }
        }
        if (from.getX() == to.getX() && from.getY() == to.getY()) {
            return 1;
        }
        return 2;
    }

    @Override
    public PolyBase getPolygon() {
        return this;
    }

    public static class Point
    extends AbstractFixpPoint {
        private long fixpX;
        private long fixpY;

        private Point(long fixpX, long fixpY) {
            this.fixpX = fixpX;
            this.fixpY = fixpY;
        }

        @Override
        public long getFixpX() {
            return this.fixpX;
        }

        @Override
        public long getFixpY() {
            return this.fixpY;
        }

        @Override
        public void setFixpLocation(long fixpX, long fixpY) {
            this.fixpX = fixpX;
            this.fixpY = fixpY;
        }

        @Override
        protected AbstractFixpPoint create(long fixpX, long fixpY) {
            return new Point(fixpX, fixpY);
        }
    }

    public static class PolyBaseTreeImpl
    implements PolyBaseTree {
        List<PolyBaseTree> sons;
        PolyBase poly;

        public PolyBaseTreeImpl(PolyBase p) {
            if (p == null) {
                throw new NullPointerException();
            }
            this.poly = p;
        }

        @Override
        public Iterable<PolyBaseTree> getSons() {
            if (this.sons != null) {
                return this.sons;
            }
            return Collections.emptyList();
        }

        @Override
        public PolyBase getPoly() {
            return this.poly;
        }

        void getLoops(int level, Stack<PolyBase> stack) {
            if (level % 2 == 0) {
                stack.push(this.poly);
            } else {
                PolyBase top = stack.pop();
                Point[] points = new Point[top.getPoints().length + this.poly.getPoints().length + 2];
                System.arraycopy(top.getPoints(), 0, points, 0, top.getPoints().length);
                points[top.getPoints().length] = (Point)top.getPoints()[0].clone();
                System.arraycopy(this.poly.getPoints(), 0, points, top.getPoints().length + 1, this.poly.getPoints().length);
                points[points.length - 1] = (Point)this.poly.getPoints()[0].clone();
                PolyBase p = new PolyBase(points);
                p.setLayer(this.poly.getLayerOrPseudoLayer());
                stack.push(p);
            }
            ++level;
            if (this.sons != null) {
                for (PolyBaseTree t : this.sons) {
                    ((PolyBaseTreeImpl)t).getLoops(level, stack);
                }
            }
        }

        boolean add(PolyBaseTreeImpl t) {
            if (!this.poly.contains(t.poly.getPoints()[0])) {
                return false;
            }
            if (this.sons == null || this.sons.size() == 0) {
                double a = this.poly.getArea();
                double b = t.poly.getArea();
                this.addSonLowLevel(t);
                if (a < b) {
                    assert (false);
                    System.out.println("Should this happen");
                    PolyBase c = t.poly;
                    t.poly = this.poly;
                    this.poly = c;
                }
            } else {
                for (PolyBaseTree b : this.sons) {
                    PolyBaseTreeImpl bi = (PolyBaseTreeImpl)b;
                    PolyBase pn = bi.poly;
                    if (pn.contains(t.poly.getPoints()[0])) {
                        return bi.add(t);
                    }
                    if (!Job.getDebug() || !t.poly.contains(pn.getPoints()[0])) continue;
                    assert (false);
                    System.out.println("Bad happen");
                }
                this.sons.add(t);
            }
            return true;
        }

        public void addSonLowLevel(PolyBaseTree son) {
            if (this.sons == null) {
                this.sons = new ArrayList<PolyBaseTree>();
            }
            this.sons.add(son);
        }
    }

    public static interface PolyBaseTree {
        public Iterable<PolyBaseTree> getSons();

        public PolyBase getPoly();
    }

    private class PolyPathIterator
    implements PathIterator {
        int idx = 0;
        AffineTransform trans;

        public PolyPathIterator(AffineTransform at) {
            this.trans = at;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.idx > PolyBase.this.points.length;
        }

        @Override
        public void next() {
            ++this.idx;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.idx >= PolyBase.this.points.length) {
                return 4;
            }
            coords[0] = (float)PolyBase.this.points[this.idx].getX();
            coords[1] = (float)PolyBase.this.points[this.idx].getY();
            if (this.trans != null) {
                this.trans.transform(coords, 0, coords, 0, 1);
            }
            return this.idx == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.idx >= PolyBase.this.points.length) {
                return 4;
            }
            coords[0] = PolyBase.this.points[this.idx].getX();
            coords[1] = PolyBase.this.points[this.idx].getY();
            if (this.trans != null) {
                this.trans.transform(coords, 0, coords, 0, 1);
            }
            return this.idx == 0 ? 0 : 1;
        }
    }

    private static class AngleList {
        private double angle;
        private double x;
        private double y;

        AngleList(Point2D pt) {
            this.x = pt.getX();
            this.y = pt.getY();
        }
    }

    private static class AngleListDescending
    implements Comparator<AngleList> {
        private AngleListDescending() {
        }

        @Override
        public int compare(AngleList c1, AngleList c2) {
            double diff = c2.angle - c1.angle;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

