/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.variable.AbstractTextDescriptor;

public class MutableTextDescriptor
extends AbstractTextDescriptor {
    private AbstractTextDescriptor.Display display;
    private long bits;
    private int colorIndex;

    public MutableTextDescriptor(AbstractTextDescriptor descriptor) {
        this.display = descriptor.getDisplay();
        this.bits = descriptor.lowLevelGet();
        this.colorIndex = descriptor.getColorIndex();
    }

    public MutableTextDescriptor() {
        this(0x10000000000L, 0, true);
    }

    public MutableTextDescriptor(long descriptor, int colorIndex, boolean display) {
        this.display = display ? AbstractTextDescriptor.Display.SHOWN : AbstractTextDescriptor.Display.NONE;
        this.bits = descriptor;
        this.colorIndex = colorIndex;
    }

    public void setCBits(int descriptor0, int descriptor1) {
        this.display = AbstractTextDescriptor.Display.SHOWN;
        this.bits = (long)descriptor1 << 32 | (long)descriptor0 & 0xFFFFFFFFL;
        this.colorIndex = 0;
    }

    public void setCBits(int descriptor0, int descriptor1, int cFlags) {
        this.display = (cFlags & 0x40) != 0 ? AbstractTextDescriptor.Display.SHOWN : AbstractTextDescriptor.Display.NONE;
        this.bits = (long)descriptor1 << 32 | (long)descriptor0 & 0xFFFFFFFFL;
        this.colorIndex = 0;
    }

    @Override
    public AbstractTextDescriptor.Display getDisplay() {
        return this.display;
    }

    @Override
    public long lowLevelGet() {
        return this.bits;
    }

    @Override
    public int getColorIndex() {
        return this.colorIndex;
    }

    private void setField(long mask, int shift, int value) {
        this.bits = this.bits & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << shift & mask;
    }

    private void setFlag(long mask, boolean state) {
        this.bits = state ? this.bits | mask : this.bits & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void setDisplay(boolean state) {
        this.setDisplay(state ? AbstractTextDescriptor.Display.SHOWN : AbstractTextDescriptor.Display.NONE);
    }

    public void setDisplay(AbstractTextDescriptor.Display display) {
        this.display = display;
    }

    public void setColorWithEGraphicsIndex(int color) {
        int newColorIndex = color;
        if (color > 0) {
            int[] colorIndices = EGraphics.getColorIndices();
            newColorIndex = colorIndices[color - 1];
        }
        this.setColorIndex(newColorIndex);
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public void setPos(AbstractTextDescriptor.Position p) {
        this.setField(15L, 0, p.getIndex());
    }

    public void setAbsSize(int s) {
        AbstractTextDescriptor.Size size = AbstractTextDescriptor.Size.newAbsSize(s);
        if (size == null) {
            System.out.println("Invalid absolute size of " + s);
            return;
        }
        this.setField(0x7FFF00000000L, 32, size.getBits());
    }

    public void setRelSize(double s) {
        AbstractTextDescriptor.Size size = AbstractTextDescriptor.Size.newRelSize(s);
        if (size == null) {
            System.out.println("Invalid relative size of " + s);
            return;
        }
        this.setField(0x7FFF00000000L, 32, size.getBits());
    }

    public void setFaceWithActiveFont(String fontName) {
        if (fontName.equals("DEFAULT FONT")) {
            this.setFace(0);
        } else {
            AbstractTextDescriptor.ActiveFont newFont = AbstractTextDescriptor.ActiveFont.findActiveFont(fontName);
            int newFontIndex = newFont != null ? newFont.getIndex() : 0;
            this.setFace(newFontIndex);
        }
    }

    public void setFace(int f) {
        this.setField(17873661021126656L, 47, f);
    }

    public void setRotation(AbstractTextDescriptor.Rotation r) {
        this.setField(0xC0000000000000L, 54, r.getIndex());
    }

    public void setDispPart(AbstractTextDescriptor.DispPos d) {
        this.setField(48L, 4, d.getIndex());
    }

    public void setItalic(boolean state) {
        this.setFlag(64L, state);
    }

    public void setBold(boolean state) {
        this.setFlag(128L, state);
    }

    public void setUnderline(boolean state) {
        this.setFlag(256L, state);
    }

    public void setInterior(boolean state) {
        this.setFlag(1024L, state);
    }

    public void setInherit(boolean state) {
        this.setFlag(2048L, state);
    }

    public void setParam(boolean state) {
        this.setFlag(512L, state);
    }

    public void setOff(double xd, double yd) {
        int scale;
        boolean xneg = xd < 0.0;
        this.setFlag(0x200000L, xneg);
        if (xneg) {
            xd = -xd;
        }
        boolean yneg = yd < 0.0;
        this.setFlag(0x80000000L, yneg);
        if (yneg) {
            yd = -yd;
        }
        if ((scale = (int)(Math.max(xd, yd) * 4.0) >> 9) > 31) {
            scale = 31;
        }
        int x = Math.min((int)(xd * 4.0 / (double)(scale + 1) + 0.5), 511);
        int y = Math.min((int)(yd * 4.0 / (double)(scale + 1) + 0.5), 511);
        this.setField(0x1FF000L, 12, x);
        this.setField(2143289344L, 22, y);
        this.setField(0x1F00000000000000L, 56, scale);
    }

    public void setUnit(AbstractTextDescriptor.Unit u) {
        this.setField(-2305843009213693952L, 61, u.getIndex());
    }
}

