/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassInitializer;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import gnu.mapping.PropertySet;
import gnu.text.SourceLocator;
import java.util.Vector;

public class ClassExp
extends LambdaExp {
    boolean simple;
    public static final int IS_ABSTRACT = 8192;
    public static final int INTERFACE_SPECIFIED = 16384;
    public static final int CLASS_SPECIFIED = 32768;
    boolean explicitInit;
    ClassType instanceType;
    public String classNameSpecifier;
    public Expression[] supers;
    public int superClassIndex = -1;
    public LambdaExp initMethod;
    public LambdaExp clinitMethod;
    boolean partsDeclared;

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public final boolean isAbstract() {
        return this.getFlag(8192);
    }

    public boolean isMakingClassPair() {
        return this.type != this.instanceType;
    }

    public ClassExp() {
        this.type = null;
        this.setCanRead(true);
    }

    public ClassExp(boolean bl) {
        this.simple = bl;
        this.instanceType = bl ? (this.type = new ClassType()) : (this.type = new PairClassType());
        this.setCanRead(true);
    }

    protected boolean mustCompile() {
        return true;
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        this.compileMembers(compilation);
        this.compilePushClass(compilation, target);
    }

    public void compilePushClass(Compilation compilation, Target target) {
        int n;
        ClassType classType;
        ClassType classType2 = this.type;
        CodeAttr codeAttr = compilation.getCode();
        compilation.loadClassRef(classType2);
        boolean bl = this.getNeedsClosureEnv();
        if (this.isSimple() && !bl) {
            return;
        }
        if (this.isMakingClassPair() || bl) {
            if (classType2 == this.instanceType) {
                codeAttr.emitDup(this.instanceType);
            } else {
                compilation.loadClassRef(this.instanceType);
            }
            classType = ClassType.make("gnu.expr.PairClassType");
            n = bl ? 3 : 2;
        } else {
            classType = ClassType.make("gnu.bytecode.Type");
            n = 1;
        }
        Type[] typeArray = new Type[n];
        if (bl) {
            this.getOwningLambda().loadHeapFrame(compilation);
            typeArray[--n] = Type.pointer_type;
        }
        ClassType classType3 = ClassType.make("java.lang.Class");
        while (--n >= 0) {
            typeArray[n] = classType3;
        }
        Method method = classType.addMethod("make", typeArray, classType, 9);
        codeAttr.emitInvokeStatic(method);
        target.compileFromStack(compilation, classType);
    }

    protected ClassType getCompiledClassType(Compilation compilation) {
        return this.type;
    }

    public void setTypes(Compilation compilation) {
        ClassType[] classTypeArray;
        int n;
        Object object2;
        int n2 = this.supers == null ? 0 : this.supers.length;
        ClassType[] classTypeArray2 = new ClassType[n2];
        ClassType classType = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ClassType classType2;
            block31: {
                object2 = Language.getDefaultLanguage().getTypeFor(this.supers[i]);
                if (!(object2 instanceof ClassType)) {
                    compilation.setLine(this.supers[i]);
                    compilation.error('e', "invalid super type");
                    continue;
                }
                classType2 = (ClassType)object2;
                try {
                    n = classType2.getModifiers();
                }
                catch (RuntimeException runtimeException) {
                    n = 0;
                    if (compilation == null) break block31;
                    compilation.error('e', "unknown super-type " + classType2.getName());
                }
            }
            if ((n & 0x200) == 0) {
                if (n3 < i) {
                    compilation.error('e', "duplicate superclass for " + this);
                }
                classType = classType2;
                this.superClassIndex = i;
                continue;
            }
            classTypeArray2[n3++] = classType2;
        }
        if (classType != null && (this.flags & 0x4000) != 0) {
            compilation.error('e', "cannot be interface since has superclass");
        }
        if (!this.simple && classType == null && (this.flags & 0x8000) == 0) {
            PairClassType pairClassType = (PairClassType)this.type;
            this.instanceType = new ClassType();
            pairClassType.setInterface(true);
            pairClassType.instanceType = this.instanceType;
            object2 = new ClassType[]{this.type};
            this.instanceType.setSuper(Type.pointer_type);
            this.instanceType.setInterfaces((ClassType[])object2);
        } else if (this.getFlag(16384)) {
            this.instanceType.setInterface(true);
        }
        this.type.setSuper(classType == null ? Type.pointer_type : classType);
        if (n3 == n2) {
            classTypeArray = classTypeArray2;
        } else {
            classTypeArray = new ClassType[n3];
            System.arraycopy(classTypeArray2, 0, classTypeArray, 0, n3);
        }
        this.type.setInterfaces(classTypeArray);
        if (this.type.getName() == null) {
            if (this.classNameSpecifier != null) {
                object2 = this.classNameSpecifier;
            } else {
                int n4;
                object2 = this.getName();
                if (object2 != null && (n4 = ((String)object2).length()) > 2 && ((String)object2).charAt(0) == '<' && ((String)object2).charAt(n4 - 1) == '>') {
                    object2 = ((String)object2).substring(1, n4 - 1);
                }
            }
            if (object2 == null) {
                StringBuffer stringBuffer = new StringBuffer(100);
                compilation.getModule().classFor(compilation);
                stringBuffer.append(compilation.mainClass.getName());
                stringBuffer.append('$');
                n = stringBuffer.length();
                int n5 = 0;
                while (true) {
                    stringBuffer.append(n5);
                    object2 = stringBuffer.toString();
                    if (compilation.findNamedClass((String)object2) != null) {
                        stringBuffer.setLength(n);
                        ++n5;
                        continue;
                    }
                    break;
                }
            } else if (!this.isSimple() || this instanceof ObjectExp) {
                object2 = compilation.generateClassName((String)object2);
            } else {
                int n6;
                int n7 = 0;
                StringBuffer stringBuffer = new StringBuffer(100);
                while ((n6 = ((String)object2).indexOf(46, n7)) >= 0) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(((String)object2).substring(n7, n6)));
                    n7 = n6 + 1;
                    if (n7 >= ((String)object2).length()) continue;
                    stringBuffer.append('.');
                }
                if (n7 == 0) {
                    int n8;
                    String string = compilation.mainClass == null ? null : compilation.mainClass.getName();
                    int n9 = n8 = string == null ? -1 : string.lastIndexOf(46);
                    if (n8 > 0) {
                        stringBuffer.append(string.substring(0, n8 + 1));
                    } else if (compilation.classPrefix != null) {
                        stringBuffer.append(compilation.classPrefix);
                    }
                } else if (n7 == 1 && n7 < ((String)object2).length()) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(compilation.mainClass.getName());
                    stringBuffer.append('$');
                }
                if (n7 < ((String)object2).length()) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(((String)object2).substring(n7)));
                }
                object2 = stringBuffer.toString();
            }
            this.type.setName((String)object2);
            compilation.addClass(this.type);
            if (this.isMakingClassPair()) {
                this.instanceType.setName(this.type.getName() + "$class");
                compilation.addClass(this.instanceType);
            }
        }
    }

    public void declareParts(Compilation compilation) {
        short s;
        SourceLocator sourceLocator;
        if (this.partsDeclared) {
            return;
        }
        this.partsDeclared = true;
        for (sourceLocator = this.firstDecl(); sourceLocator != null; sourceLocator = ((Declaration)sourceLocator).nextDecl()) {
            Object object2;
            if (!((Declaration)sourceLocator).getCanRead()) continue;
            int n = ((Declaration)sourceLocator).getAccessFlags((short)1);
            if (((Declaration)sourceLocator).getFlag(2048)) {
                n |= 8;
            }
            if (this.isMakingClassPair()) {
                object2 = ((Declaration)sourceLocator).getType().getImplementationType();
                this.type.addMethod(ClassExp.slotToMethodName("get", ((Declaration)sourceLocator).getName()), n |= 0x400, Type.typeArray0, (Type)object2);
                Type[] typeArray = new Type[]{object2};
                this.type.addMethod(ClassExp.slotToMethodName("set", ((Declaration)sourceLocator).getName()), n, typeArray, Type.voidType);
                continue;
            }
            object2 = Compilation.mangleNameIfNeeded(((Declaration)sourceLocator).getName());
            ((Declaration)sourceLocator).field = this.instanceType.addField((String)object2, ((Declaration)sourceLocator).getType(), n);
            ((Declaration)sourceLocator).setSimple(false);
        }
        sourceLocator = this.firstChild;
        while (sourceLocator != null) {
            if (((LambdaExp)sourceLocator).isAbstract()) {
                this.setFlag(8192);
            }
            if ("*init*".equals(((PropertySet)((Object)sourceLocator)).getName())) {
                this.explicitInit = true;
                if (((LambdaExp)sourceLocator).isAbstract()) {
                    compilation.error('e', "*init* method cannot be abstract", sourceLocator);
                }
            }
            ((LambdaExp)sourceLocator).outer = this;
            if (sourceLocator != this.initMethod && sourceLocator != this.clinitMethod && !((LambdaExp)sourceLocator).nameDecl.getFlag(2048) || !this.isMakingClassPair()) {
                ((LambdaExp)sourceLocator).addMethodFor(this.type, compilation, null);
            }
            if (this.isMakingClassPair()) {
                ((LambdaExp)sourceLocator).addMethodFor(this.instanceType, compilation, this.type);
            }
            sourceLocator = ((LambdaExp)sourceLocator).nextSibling;
        }
        if (!this.explicitInit && !this.instanceType.isInterface()) {
            Compilation.getConstructor(this.instanceType, this);
        }
        if (this.isAbstract()) {
            this.instanceType.setModifiers(this.instanceType.getModifiers() | 0x400);
        }
        if (this.nameDecl != null && (s = this.nameDecl.getAccessFlags((short)0)) != 0) {
            this.instanceType.setModifiers(this.instanceType.getModifiers() & 0xFFFFFFFE | s);
        }
    }

    static void getImplMethods(ClassType classType, String string, Type[] typeArray, Vector vector) {
        ClassType[] classTypeArray;
        Object object2;
        Type[] typeArray2;
        ClassType classType2;
        if (classType instanceof PairClassType) {
            classType2 = ((PairClassType)classType).instanceType;
        } else {
            if (!classType.isInterface()) {
                return;
            }
            try {
                typeArray2 = classType.getReflectClass();
                if (typeArray2 == null) {
                    return;
                }
                object2 = classType.getName() + "$class";
                classTypeArray = typeArray2.getClassLoader();
                Class<?> clazz = Class.forName((String)object2, false, (ClassLoader)classTypeArray);
                classType2 = (ClassType)Type.make(clazz);
            }
            catch (Throwable throwable) {
                return;
            }
        }
        typeArray2 = new Type[typeArray.length + 1];
        typeArray2[0] = classType;
        System.arraycopy(typeArray, 0, typeArray2, 1, typeArray.length);
        object2 = classType2.getDeclaredMethod(string, typeArray2);
        if (object2 != null) {
            int n = vector.size();
            if (n == 0 || !vector.elementAt(n - 1).equals(object2)) {
                vector.addElement(object2);
            }
        } else {
            classTypeArray = classType.getInterfaces();
            for (int i = 0; i < classTypeArray.length; ++i) {
                ClassExp.getImplMethods(classTypeArray[i], string, typeArray, vector);
            }
        }
    }

    private static void usedSuperClasses(ClassType classType, Compilation compilation) {
        compilation.usedClass(classType.getSuperclass());
        ClassType[] classTypeArray = classType.getInterfaces();
        if (classTypeArray != null) {
            int n = classTypeArray.length;
            while (--n >= 0) {
                compilation.usedClass(classTypeArray[n]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassType compileMembers(Compilation compilation) {
        ClassType classType = compilation.curClass;
        Method method = compilation.method;
        try {
            int n;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            CodeAttr codeAttr;
            Object object6;
            Object object7;
            String string;
            ClassType classType2;
            compilation.curClass = classType2 = this.getCompiledClassType(compilation);
            LambdaExp lambdaExp = this.outerLambda();
            AttrContainer attrContainer = null;
            if (lambdaExp instanceof ClassExp) {
                attrContainer = lambdaExp.type;
            } else if (lambdaExp != null && !(lambdaExp instanceof ModuleExp)) {
                attrContainer = method;
            } else if (lambdaExp instanceof ModuleExp && this.type.getName().indexOf(36) > 0) {
                attrContainer = lambdaExp.type;
            }
            if (attrContainer != null) {
                classType2.setEnclosingMember((Member)((Object)attrContainer));
                if (attrContainer instanceof ClassType) {
                    ((ClassType)attrContainer).addMemberClass(classType2);
                }
            }
            if (this.instanceType != classType2) {
                this.instanceType.setEnclosingMember(this.type);
                this.type.addMemberClass(this.instanceType);
            }
            ClassExp.usedSuperClasses(this.type, compilation);
            if (this.type != this.instanceType) {
                ClassExp.usedSuperClasses(this.instanceType, compilation);
            }
            if ((string = this.getFileName()) != null) {
                classType2.setSourceFile(string);
            }
            LambdaExp lambdaExp2 = compilation.curLambda;
            compilation.curLambda = this;
            this.allocFrame(compilation);
            Method[] methodArray = this.firstChild;
            while (methodArray != null) {
                if (!methodArray.isAbstract()) {
                    Method method2 = compilation.method;
                    LambdaExp lambdaExp3 = compilation.curLambda;
                    object7 = compilation.getFileName();
                    int n2 = compilation.getLineNumber();
                    int n3 = compilation.getColumnNumber();
                    compilation.setLine((Expression)methodArray);
                    compilation.method = methodArray.getMainMethod();
                    object6 = methodArray.nameDecl;
                    if (object6 == null || !((Declaration)object6).getFlag(2048)) {
                        methodArray.declareThis(compilation.curClass);
                    }
                    compilation.curClass = this.instanceType;
                    compilation.curLambda = methodArray;
                    compilation.method.initCode();
                    methodArray.allocChildClasses(compilation);
                    methodArray.allocParameters(compilation);
                    if ("*init*".equals(methodArray.getName())) {
                        Object object8;
                        codeAttr = compilation.getCode();
                        if (this.staticLinkField != null) {
                            codeAttr.emitPushThis();
                            codeAttr.emitLoad(codeAttr.getCurrentScope().getVariable(1));
                            codeAttr.emitPutField(this.staticLinkField);
                        }
                        object5 = methodArray.body;
                        while (object5 instanceof BeginExp) {
                            object8 = (BeginExp)object5;
                            if (((BeginExp)object8).length == 0) {
                                object5 = null;
                                continue;
                            }
                            object5 = ((BeginExp)object8).exps[0];
                        }
                        object8 = null;
                        if (object5 instanceof ApplyExp && (object4 = ((ApplyExp)object5).func) instanceof QuoteExp && (object3 = ((QuoteExp)object4).getValue()) instanceof PrimProcedure && ((PrimProcedure)(object2 = (PrimProcedure)object3)).isSpecial() && "<init>".equals(((PrimProcedure)object2).method.getName())) {
                            object8 = ((PrimProcedure)object2).method.getDeclaringClass();
                        }
                        object2 = this.instanceType.getSuperclass();
                        if (object8 != null) {
                            ((Expression)object5).compileWithPosition(compilation, Target.Ignore);
                            if (object8 != this.instanceType && object8 != object2) {
                                compilation.error('e', "call to <init> for not this or super class");
                            }
                        } else if (object8 != object2) {
                            ClassExp.invokeDefaultSuperConstructor((ClassType)object2, compilation, this);
                        }
                        methodArray.enterFunction(compilation);
                        if (object8 != this.instanceType) {
                            compilation.callInitMethods(this.getCompiledClassType(compilation), new Vector(10));
                        }
                        if (object8 != null) {
                            Expression.compileButFirst(methodArray.body, compilation);
                        } else {
                            methodArray.compileBody(compilation);
                        }
                    } else {
                        methodArray.enterFunction(compilation);
                        methodArray.compileBody(compilation);
                    }
                    methodArray.compileEnd(compilation);
                    methodArray.generateApplyMethods(compilation);
                    compilation.method = method2;
                    compilation.curClass = classType2;
                    compilation.curLambda = lambdaExp3;
                    compilation.setLine((String)object7, n2, n3);
                }
                methodArray = methodArray.nextSibling;
            }
            if (!this.explicitInit && !this.instanceType.isInterface()) {
                compilation.generateConstructor(this.instanceType, this);
            } else if (this.initChain != null) {
                this.initChain.reportError("unimplemented: explicit constructor cannot initialize ", compilation);
            }
            if (this.isAbstract()) {
                methodArray = null;
                n = 0;
            } else {
                methodArray = this.type.getMethods((Filter)AbstractMethodFilter.instance, 2);
                n = methodArray.length;
            }
            for (int i = 0; i < n; ++i) {
                char c;
                object7 = methodArray[i];
                String string2 = ((Method)object7).getName();
                Type[] typeArray = ((Method)object7).getParameterTypes();
                object6 = ((Method)object7).getReturnType();
                object5 = this.instanceType.getMethod(string2, typeArray);
                if (object5 != null && !((Method)object5).isAbstract()) continue;
                if (string2.length() > 3 && string2.charAt(2) == 't' && string2.charAt(1) == 'e' && ((c = string2.charAt(0)) == 'g' || c == 's')) {
                    if (c == 's' && ((Type)object6).isVoid() && typeArray.length == 1) {
                        object3 = typeArray[0];
                    } else {
                        if (c != 'g' || typeArray.length != 0) continue;
                        object3 = object6;
                    }
                    object4 = Character.toLowerCase(string2.charAt(3)) + string2.substring(4);
                    object2 = this.instanceType.getField((String)object4);
                    if (object2 == null) {
                        object2 = this.instanceType.addField((String)object4, (Type)object3, 1);
                    }
                    Method method3 = this.instanceType.addMethod(string2, 1, typeArray, (Type)object6);
                    codeAttr = method3.startCode();
                    codeAttr.emitPushThis();
                    if (c == 'g') {
                        codeAttr.emitGetField((Field)object2);
                    } else {
                        codeAttr.emitLoad(codeAttr.getArg(1));
                        codeAttr.emitPutField((Field)object2);
                    }
                    codeAttr.emitReturn();
                    continue;
                }
                object3 = new Vector();
                ClassExp.getImplMethods(this.type, string2, typeArray, object3);
                if (((Vector)object3).size() != 1) {
                    object4 = ((Vector)object3).size() == 0 ? "missing implementation for " : "ambiguous implementation for ";
                    compilation.error('e', (String)object4 + object7 + " mname:" + string2);
                    continue;
                }
                object4 = this.instanceType.addMethod(string2, 1, typeArray, (Type)object6);
                codeAttr = ((Method)object4).startCode();
                for (object2 = codeAttr.getCurrentScope().firstVar(); object2 != null; object2 = ((Variable)object2).nextVar()) {
                    codeAttr.emitLoad((Variable)object2);
                }
                object2 = (Method)((Vector)object3).elementAt(0);
                codeAttr.emitInvokeStatic((Method)object2);
                codeAttr.emitReturn();
            }
            this.generateApplyMethods(compilation);
            compilation.curLambda = lambdaExp2;
            ClassType classType3 = classType2;
            return classType3;
        }
        finally {
            compilation.curClass = classType;
            compilation.method = method;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walk(ExpWalker expWalker) {
        Compilation compilation = expWalker.getCompilation();
        if (compilation == null) {
            return expWalker.walkClassExp(this);
        }
        ClassType classType = compilation.curClass;
        try {
            compilation.curClass = this.type;
            Expression expression = expWalker.walkClassExp(this);
            return expression;
        }
        finally {
            compilation.curClass = classType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void walkChildren(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        this.supers = expWalker.walkExps(this.supers, this.supers.length);
        try {
            LambdaExp lambdaExp2 = this.firstChild;
            while (lambdaExp2 != null && expWalker.exitValue == null) {
                Declaration declaration;
                if (this.instanceType != null && (declaration = lambdaExp2.firstDecl()) != null && declaration.isThisParameter()) {
                    declaration.setType(this.type);
                }
                expWalker.walkLambdaExp(lambdaExp2);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
        }
        finally {
            expWalker.currentLambda = lambdaExp;
        }
    }

    static void loadSuperStaticLink(Expression expression, ClassType classType, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        expression.compile(compilation, Target.pushValue(Compilation.typeClassType));
        codeAttr.emitInvokeStatic(ClassType.make("gnu.expr.PairClassType").getDeclaredMethod("extractStaticLink", 1));
        codeAttr.emitCheckcast(classType.getOuterLinkType());
    }

    static void invokeDefaultSuperConstructor(ClassType classType, Compilation compilation, LambdaExp lambdaExp) {
        CodeAttr codeAttr = compilation.getCode();
        Method method = classType.getDeclaredMethod("<init>", 0);
        if (method == null) {
            compilation.error('e', "super class does not have a default constructor");
        } else {
            codeAttr.emitPushThis();
            if (classType.hasOuterLink() && lambdaExp instanceof ClassExp) {
                ClassExp classExp = (ClassExp)lambdaExp;
                Expression expression = classExp.supers[classExp.superClassIndex];
                ClassExp.loadSuperStaticLink(expression, classType, compilation);
            }
            codeAttr.emitInvokeSpecial(method);
        }
    }

    public void print(OutPort outPort) {
        SourceLocator sourceLocator;
        outPort.startLogicalBlock("(" + this.getExpClassName() + "/", ")", 2);
        Object object2 = this.getSymbol();
        if (object2 != null) {
            outPort.print(object2);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print("/fl:");
        outPort.print(Integer.toHexString(this.flags));
        if (this.supers.length > 0) {
            outPort.print(" supers:");
            for (int i = 0; i < this.supers.length; ++i) {
                this.supers[i].print(outPort);
                outPort.print(' ');
            }
        }
        outPort.print('(');
        Object var3_4 = null;
        int n = 0;
        int n2 = this.keywords == null ? 0 : this.keywords.length;
        for (sourceLocator = this.firstDecl(); sourceLocator != null; sourceLocator = ((Declaration)sourceLocator).nextDecl()) {
            if (n > 0) {
                outPort.print(' ');
            }
            ((Declaration)sourceLocator).printInfo(outPort);
            ++n;
        }
        outPort.print(") ");
        sourceLocator = this.firstChild;
        while (sourceLocator != null) {
            outPort.writeBreakLinear();
            ((LambdaExp)sourceLocator).print(outPort);
            sourceLocator = ((LambdaExp)sourceLocator).nextSibling;
        }
        if (this.body != null) {
            outPort.writeBreakLinear();
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public Field compileSetField(Compilation compilation) {
        return new ClassInitializer((ClassExp)this, (Compilation)compilation).field;
    }

    public static String slotToMethodName(String string, String string2) {
        if (!Compilation.isValidJavaName(string2)) {
            string2 = Compilation.mangleName(string2, false);
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 3);
        stringBuffer.append(string);
        stringBuffer.append(Character.toTitleCase(string2.charAt(0)));
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }

    private static class AbstractMethodFilter
    implements Filter {
        public static final AbstractMethodFilter instance = new AbstractMethodFilter();

        private AbstractMethodFilter() {
        }

        public boolean select(Object object2) {
            Method method = (Method)object2;
            return method.isAbstract();
        }
    }
}

