/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.CatchClause;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;
import gnu.kawa.functions.AppendValues;
import gnu.text.SourceLocator;
import java.util.HashSet;

public class FindTailCalls
extends ExpWalker {
    Expression returnContinuation;

    public static void findTailCalls(Expression expression, Compilation compilation) {
        FindTailCalls findTailCalls = new FindTailCalls();
        findTailCalls.setContext(compilation);
        findTailCalls.walk(expression);
    }

    public boolean inTailContext() {
        return this.returnContinuation == this.currentLambda.body;
    }

    protected Expression walkExpression(Expression expression) {
        Expression expression2 = this.returnContinuation;
        this.returnContinuation = expression;
        Expression expression3 = super.walkExpression(expression);
        this.returnContinuation = expression2;
        return expression3;
    }

    public Expression[] walkExps(Expression[] expressionArray, int n) {
        Expression expression = this.returnContinuation;
        for (int i = 0; i < n; ++i) {
            Expression expression2;
            this.returnContinuation = expression2 = expressionArray[i];
            expressionArray[i] = this.walk(expression2);
        }
        this.returnContinuation = expression;
        return expressionArray;
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        boolean bl = this.inTailContext();
        if (bl) {
            applyExp.setTailCall(true);
        }
        applyExp.context = this.currentLambda;
        LambdaExp lambdaExp = null;
        boolean bl2 = false;
        if (applyExp.func instanceof ReferenceExp) {
            ReferenceExp referenceExp = (ReferenceExp)applyExp.func;
            Declaration declaration = Declaration.followAliases(referenceExp.binding);
            if (declaration != null) {
                Expression expression;
                if (!declaration.getFlag(2048)) {
                    applyExp.nextCall = declaration.firstCall;
                    declaration.firstCall = applyExp;
                }
                Compilation compilation = this.getCompilation();
                declaration.setCanCall();
                if (!compilation.mustCompile) {
                    declaration.setCanRead();
                }
                if ((expression = declaration.getValue()) instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)expression;
                }
            }
        } else if (applyExp.func instanceof LambdaExp && !(applyExp.func instanceof ClassExp)) {
            lambdaExp = (LambdaExp)applyExp.func;
            this.walkLambdaExp(lambdaExp, false);
            lambdaExp.setCanCall(true);
        } else if (applyExp.func instanceof QuoteExp && ((QuoteExp)applyExp.func).getValue() == AppendValues.appendValues) {
            bl2 = true;
        } else {
            Expression expression = this.returnContinuation;
            this.returnContinuation = applyExp.func;
            applyExp.func = applyExp.func.walk(this);
            this.returnContinuation = expression;
        }
        if (!(lambdaExp == null || lambdaExp.returnContinuation == this.returnContinuation || lambdaExp == this.currentLambda && bl)) {
            if (bl) {
                if (lambdaExp.tailCallers == null) {
                    lambdaExp.tailCallers = new HashSet<LambdaExp>();
                }
                lambdaExp.tailCallers.add(this.currentLambda);
            } else if (lambdaExp.returnContinuation == null) {
                lambdaExp.returnContinuation = this.returnContinuation;
                lambdaExp.inlineHome = this.currentLambda;
            } else {
                lambdaExp.returnContinuation = LambdaExp.unknownContinuation;
                lambdaExp.inlineHome = null;
            }
        }
        applyExp.args = this.walkExps(applyExp.args);
        return applyExp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkBlockExp(BlockExp blockExp) {
        Expression expression = this.returnContinuation;
        try {
            blockExp.body = blockExp.body.walk(this);
            if (blockExp.exitBody != null) {
                this.returnContinuation = blockExp.exitBody;
                blockExp.exitBody = blockExp.exitBody.walk(this);
            }
            BlockExp blockExp2 = blockExp;
            return blockExp2;
        }
        finally {
            this.returnContinuation = expression;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkBeginExp(BeginExp beginExp) {
        Expression expression = this.returnContinuation;
        try {
            int n = beginExp.length - 1;
            for (int i = 0; i <= n; ++i) {
                this.returnContinuation = i == n ? expression : beginExp.exps[i];
                beginExp.exps[i] = beginExp.exps[i].walk(this);
            }
            BeginExp beginExp2 = beginExp;
            return beginExp2;
        }
        finally {
            this.returnContinuation = expression;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        SourceLocator sourceLocator;
        for (sourceLocator = fluidLetExp.firstDecl(); sourceLocator != null; sourceLocator = ((Declaration)sourceLocator).nextDecl()) {
            ((Declaration)sourceLocator).setCanRead(true);
            if (((Declaration)sourceLocator).base == null) continue;
            ((Declaration)sourceLocator).base.setCanRead(true);
        }
        sourceLocator = this.returnContinuation;
        try {
            this.walkLetDecls(fluidLetExp);
            this.returnContinuation = fluidLetExp.body;
            fluidLetExp.body = fluidLetExp.body.walk(this);
        }
        finally {
            this.returnContinuation = sourceLocator;
        }
        this.postWalkDecls(fluidLetExp);
        return fluidLetExp;
    }

    void walkLetDecls(LetExp letExp) {
        Declaration declaration = letExp.firstDecl();
        int n = letExp.inits.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression;
            Expression expression2 = this.walkSetExp(declaration, letExp.inits[n2]);
            if (expression2 == QuoteExp.undefined_exp && ((expression = declaration.getValue()) instanceof LambdaExp || expression != expression2 && expression instanceof QuoteExp)) {
                expression2 = expression;
            }
            letExp.inits[n2] = expression2;
            ++n2;
            declaration = declaration.nextDecl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkLetExp(LetExp letExp) {
        Expression expression = this.returnContinuation;
        try {
            this.walkLetDecls(letExp);
        }
        finally {
            this.returnContinuation = expression;
        }
        letExp.body = letExp.body.walk(this);
        this.postWalkDecls(letExp);
        return letExp;
    }

    public void postWalkDecls(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            Declaration declaration2;
            Expression expression;
            Expression expression2 = declaration.getValue();
            if (expression2 instanceof LambdaExp) {
                expression = (LambdaExp)expression2;
                if (declaration.getCanRead()) {
                    ((LambdaExp)expression).setCanRead(true);
                }
                if (declaration.getCanCall()) {
                    ((LambdaExp)expression).setCanCall(true);
                }
            }
            if (!declaration.getFlag(1024) || !(expression2 instanceof ReferenceExp) || (declaration2 = ((AccessExp)(expression = (ReferenceExp)expression2)).contextDecl()) == null || !declaration2.isPrivate()) continue;
            declaration2.setFlag(524288);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkIfExp(IfExp ifExp) {
        Expression expression = this.returnContinuation;
        try {
            this.returnContinuation = ifExp.test;
            ifExp.test = ifExp.test.walk(this);
        }
        finally {
            this.returnContinuation = expression;
        }
        ifExp.then_clause = ifExp.then_clause.walk(this);
        Expression expression2 = ifExp.else_clause;
        if (expression2 != null) {
            ifExp.else_clause = expression2.walk(this);
        }
        return ifExp;
    }

    protected Expression walkLambdaExp(LambdaExp lambdaExp) {
        this.walkLambdaExp(lambdaExp, true);
        return lambdaExp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void walkLambdaExp(LambdaExp lambdaExp, boolean bl) {
        Expression expression = this.returnContinuation;
        this.returnContinuation = lambdaExp;
        LambdaExp lambdaExp2 = this.currentLambda;
        this.currentLambda = lambdaExp;
        if (bl) {
            lambdaExp.setCanRead(true);
        }
        try {
            this.returnContinuation = lambdaExp;
            if (lambdaExp.defaultArgs != null) {
                lambdaExp.defaultArgs = this.walkExps(lambdaExp.defaultArgs);
            }
            Expression expression2 = this.returnContinuation = lambdaExp.getInlineOnly() ? expression : lambdaExp.body;
            if (this.exitValue == null && lambdaExp.body != null) {
                lambdaExp.body = lambdaExp.body.walk(this);
            }
        }
        finally {
            this.returnContinuation = expression;
            this.currentLambda = lambdaExp2;
        }
        this.postWalkDecls(lambdaExp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkClassExp(ClassExp classExp) {
        Expression expression = this.returnContinuation;
        this.returnContinuation = classExp;
        LambdaExp lambdaExp = this.currentLambda;
        this.currentLambda = classExp;
        classExp.setCanRead(true);
        try {
            LambdaExp lambdaExp2 = classExp.firstChild;
            while (lambdaExp2 != null && this.exitValue == null) {
                this.walkLambdaExp(lambdaExp2, false);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
        }
        finally {
            this.returnContinuation = expression;
            this.currentLambda = lambdaExp;
        }
        return classExp;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Object object2;
        Declaration declaration = Declaration.followAliases(referenceExp.binding);
        if (declaration != null) {
            object2 = declaration.type;
            if (object2 != null && ((Type)object2).isVoid()) {
                return QuoteExp.voidExp;
            }
            declaration.setCanRead(true);
        }
        if ((object2 = referenceExp.contextDecl()) != null) {
            ((Declaration)object2).setCanRead(true);
        }
        return referenceExp;
    }

    final Expression walkSetExp(Declaration declaration, Expression expression) {
        this.returnContinuation = expression;
        if (declaration != null && declaration.getValue() == expression && expression instanceof LambdaExp && !(expression instanceof ClassExp) && !declaration.isPublic()) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            this.walkLambdaExp(lambdaExp, false);
            return lambdaExp;
        }
        return expression.walk(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkSetExp(SetExp setExp) {
        Expression expression = this.returnContinuation;
        try {
            Declaration declaration;
            Declaration declaration2 = setExp.binding;
            if (declaration2 != null && declaration2.isAlias()) {
                if (setExp.isDefining()) {
                    this.returnContinuation = setExp.new_value;
                    setExp.new_value = setExp.new_value.walk(this);
                    SetExp setExp2 = setExp;
                    return setExp2;
                }
                declaration2 = Declaration.followAliases(declaration2);
            }
            if ((declaration = setExp.contextDecl()) != null) {
                declaration.setCanRead(true);
            }
            Expression expression2 = this.walkSetExp(declaration2, setExp.new_value);
            if (declaration2 != null && declaration2.context instanceof LetExp && expression2 == declaration2.getValue() && (expression2 instanceof LambdaExp || expression2 instanceof QuoteExp)) {
                QuoteExp quoteExp = QuoteExp.voidExp;
                return quoteExp;
            }
            setExp.new_value = expression2;
            SetExp setExp3 = setExp;
            return setExp3;
        }
        finally {
            this.returnContinuation = expression;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkTryExp(TryExp tryExp) {
        Expression expression = this.returnContinuation;
        try {
            if (tryExp.finally_clause != null) {
                this.returnContinuation = tryExp.try_clause;
            }
            tryExp.try_clause = tryExp.try_clause.walk(this);
            for (CatchClause catchClause = tryExp.catch_clauses; this.exitValue == null && catchClause != null; catchClause = catchClause.getNext()) {
                if (tryExp.finally_clause != null) {
                    this.returnContinuation = catchClause.body;
                }
                catchClause.body = catchClause.body.walk(this);
            }
            Expression expression2 = tryExp.finally_clause;
            if (expression2 != null) {
                this.returnContinuation = expression2;
                tryExp.finally_clause = expression2.walk(this);
            }
            TryExp tryExp2 = tryExp;
            return tryExp2;
        }
        finally {
            this.returnContinuation = expression;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkSynchronizedExp(SynchronizedExp synchronizedExp) {
        Expression expression = this.returnContinuation;
        try {
            this.returnContinuation = synchronizedExp.object;
            synchronizedExp.object = synchronizedExp.object.walk(this);
            this.returnContinuation = synchronizedExp.body;
            synchronizedExp.body = synchronizedExp.body.walk(this);
            SynchronizedExp synchronizedExp2 = synchronizedExp;
            return synchronizedExp2;
        }
        finally {
            this.returnContinuation = expression;
        }
    }
}

