/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.kawa.functions.ObjectFormat;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.math.IntNum;
import java.io.IOException;
import java.io.PrintWriter;

public class TracedProcedure
extends ProcedureN {
    public Procedure proc;
    boolean enabled;
    static int indentationStep = 2;
    static Symbol curIndentSym = Symbol.makeUninterned("current-indentation");

    public TracedProcedure(Procedure procedure, boolean bl) {
        this.proc = procedure;
        this.enabled = bl;
        String string = procedure.getName();
        if (string != null) {
            this.setName(string);
        }
    }

    static void put(Object object2, PrintWriter printWriter) {
        try {
            if (!ObjectFormat.format(object2, printWriter, 50, true)) {
                printWriter.print("...");
            }
        }
        catch (IOException iOException) {
            printWriter.print("<caught ");
            printWriter.print(iOException);
            printWriter.print('>');
        }
    }

    static void indent(int n, PrintWriter printWriter) {
        while (--n >= 0) {
            printWriter.print(' ');
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        if (this.enabled) {
            Object object2;
            int n;
            Environment environment = Environment.getCurrent();
            Location location2 = environment.getLocation(curIndentSym);
            Object object3 = location2.get(null);
            if (!(object3 instanceof IntNum)) {
                n = 0;
                location2.set(IntNum.zero());
            } else {
                n = ((IntNum)object3).intValue();
            }
            OutPort outPort = OutPort.errDefault();
            String string = this.getName();
            if (string == null) {
                string = "??";
            }
            TracedProcedure.indent(n, outPort);
            ((PrintWriter)outPort).print("call to ");
            ((PrintWriter)outPort).print(string);
            int n2 = objectArray.length;
            ((PrintWriter)outPort).print(" (");
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    outPort.print(' ');
                }
                TracedProcedure.put(objectArray[i], outPort);
            }
            outPort.println(")");
            CallContext callContext = CallContext.getInstance();
            IntNum intNum = IntNum.make(n + indentationStep);
            Object object4 = location2.setWithSave(intNum, callContext);
            try {
                object2 = this.proc.applyN(objectArray);
            }
            catch (RuntimeException runtimeException) {
                TracedProcedure.indent(n, outPort);
                outPort.println("procedure " + string + " throws exception " + runtimeException);
                throw runtimeException;
            }
            finally {
                location2.setRestore(object4, callContext);
            }
            TracedProcedure.indent(n, outPort);
            ((PrintWriter)outPort).print("return from ");
            ((PrintWriter)outPort).print(string);
            ((PrintWriter)outPort).print(" => ");
            TracedProcedure.put(object2, outPort);
            outPort.println();
            return object2;
        }
        return this.proc.applyN(objectArray);
    }

    public static Procedure doTrace(Procedure procedure, boolean bl) {
        if (procedure instanceof TracedProcedure) {
            ((TracedProcedure)procedure).enabled = bl;
            return procedure;
        }
        return new TracedProcedure(procedure, bl);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<procedure ");
        String string = this.getName();
        if (string == null) {
            printWriter.print("<unnamed>");
        } else {
            printWriter.print(string);
        }
        printWriter.print(this.enabled ? ", traced>" : ">");
    }
}

