/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.PropertySet;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.util.Stack;
import kawa.lang.Macro;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class let_syntax
extends Syntax {
    public static final let_syntax let_syntax = new let_syntax(false, "let-syntax");
    public static final let_syntax letrec_syntax = new let_syntax(true, "letrec-syntax");
    boolean recursive;

    public let_syntax(boolean bl, String string) {
        super(string);
        this.recursive = bl;
    }

    public Expression rewrite(Object object2, Translator translator) {
        Object object3;
        Object object4;
        Object object5;
        Externalizable externalizable;
        if (!(object2 instanceof Pair)) {
            return translator.syntaxError("missing let-syntax arguments");
        }
        Pair pair = (Pair)object2;
        Object object6 = pair.getCar();
        Object object7 = pair.getCdr();
        int n = Translator.listLength(object6);
        if (n < 0) {
            return translator.syntaxError("bindings not a proper list");
        }
        Stack<Declaration> stack = null;
        int n2 = 0;
        Expression[] expressionArray = new Expression[n];
        Declaration[] declarationArray = new Declaration[n];
        Macro[] macroArray = new Macro[n];
        Pair[] pairArray = new Pair[n];
        SyntaxForm[] syntaxFormArray = new SyntaxForm[n];
        LetExp letExp = new LetExp(expressionArray);
        SyntaxForm syntaxForm = null;
        for (int i = 0; i < n; ++i) {
            TemplateScope templateScope;
            Macro macro;
            while (object6 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object6;
                object6 = syntaxForm.form;
            }
            SyntaxForm syntaxForm2 = syntaxForm;
            externalizable = (Pair)object6;
            object5 = ((Pair)externalizable).getCar();
            if (object5 instanceof SyntaxForm) {
                syntaxForm2 = (SyntaxForm)object5;
                object5 = syntaxForm2.form;
            }
            if (!(object5 instanceof Pair)) {
                return translator.syntaxError(this.getName() + " binding is not a pair");
            }
            object4 = (Pair)object5;
            object3 = ((Pair)object4).getCar();
            SyntaxForm syntaxForm3 = syntaxForm2;
            while (object3 instanceof SyntaxForm) {
                syntaxForm3 = (SyntaxForm)object3;
                object3 = syntaxForm3.form;
            }
            if (!(object3 instanceof String) && !(object3 instanceof Symbol)) {
                return translator.syntaxError("variable in " + this.getName() + " binding is not a symbol");
            }
            Object object8 = ((Pair)object4).getCdr();
            while (object8 instanceof SyntaxForm) {
                syntaxForm2 = (SyntaxForm)object8;
                object8 = syntaxForm2.form;
            }
            if (!(object8 instanceof Pair)) {
                return translator.syntaxError(this.getName() + " has no value for '" + object3 + "'");
            }
            object4 = (Pair)object8;
            if (((Pair)object4).getCdr() != LList.Empty) {
                return translator.syntaxError("let binding for '" + object3 + "' is improper list");
            }
            Declaration declaration = new Declaration(object3);
            macroArray[i] = macro = Macro.make(declaration);
            pairArray[i] = object4;
            syntaxFormArray[i] = syntaxForm2;
            letExp.addDeclaration(declaration);
            TemplateScope templateScope2 = templateScope = syntaxForm3 == null ? null : syntaxForm3.scope;
            if (templateScope != null) {
                Declaration declaration2 = translator.makeRenamedAlias(declaration, templateScope);
                if (stack == null) {
                    stack = new Stack<Declaration>();
                }
                stack.push(declaration2);
                ++n2;
            }
            macro.setCapturedScope(syntaxForm2 != null ? syntaxForm2.scope : (this.recursive ? letExp : translator.currentScope()));
            declarationArray[i] = declaration;
            expressionArray[i] = QuoteExp.nullExp;
            object6 = ((Pair)externalizable).getCdr();
        }
        if (this.recursive) {
            this.push(letExp, translator, stack);
        }
        Macro macro = translator.currentMacroDefinition;
        for (int i = 0; i < n; ++i) {
            externalizable = macroArray[i];
            translator.currentMacroDefinition = externalizable;
            expressionArray[i] = object5 = translator.rewrite_car(pairArray[i], syntaxFormArray[i]);
            object4 = declarationArray[i];
            ((Macro)externalizable).expander = object5;
            ((Declaration)object4).noteValue(new QuoteExp(externalizable));
            if (!(object5 instanceof LambdaExp)) continue;
            object3 = (LambdaExp)object5;
            ((LambdaExp)object3).nameDecl = object4;
            ((PropertySet)object3).setSymbol(((Declaration)object4).getSymbol());
        }
        translator.currentMacroDefinition = macro;
        if (!this.recursive) {
            this.push(letExp, translator, stack);
        }
        Expression expression = translator.rewrite_body(object7);
        translator.pop(letExp);
        translator.popRenamedAlias(n2);
        return expression;
    }

    private void push(LetExp letExp, Translator translator, Stack stack) {
        translator.push(letExp);
        if (stack != null) {
            int n = stack.size();
            while (--n >= 0) {
                translator.pushRenamedAlias((Declaration)stack.pop());
            }
        }
    }
}

