/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.core;

import com.tonbeller.jpivot.core.Extension;
import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;

public abstract class ExtensionSupport
implements Extension {
    static Logger logger = Logger.getLogger(ExtensionSupport.class);
    private String id;
    private Model model;
    private Resources resources = Resources.instance(ExtensionSupport.class);

    public String getId() {
        return this.id;
    }

    public Model getModel() {
        return this.model;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Model decorate(Model decoratedModel) {
        return decoratedModel;
    }

    public void modelInitialized() {
    }

    public void setZoomIn(Member member) {
        if (member == null) {
            return;
        }
        if (member instanceof MondrianMember) {
            ((MondrianMember)member).setZooming(true);
            ((MondrianLevel)member.getLevel()).setZooming(true);
        } else if (member instanceof XMLA_Member) {
            ((XMLA_Member)member).setZooming(true);
            ((XMLA_Level)member.getLevel()).setZooming(true);
        }
    }

    public void setZoomOut(Hierarchy hier) {
        block9: {
            Level[] levels;
            block10: {
                if (hier == null) {
                    return;
                }
                levels = hier.getLevels();
                if (levels == null || levels.length <= 0) break block9;
                if (levels[0] == null || !(levels[0] instanceof MondrianLevel)) break block10;
                for (int i = levels.length - 1; i >= 0; --i) {
                    MondrianLevel mLevel = (MondrianLevel)levels[i];
                    if (mLevel == null || !mLevel.isZooming()) continue;
                    mLevel.setZooming(false);
                    List members = mLevel.getMembers();
                    if (members == null) continue;
                    Iterator itr = members.iterator();
                    if (itr == null) {
                        return;
                    }
                    while (itr != null && itr.hasNext()) {
                        Object member = itr.next();
                        if (member == null) continue;
                        ((MondrianMember)member).setZooming(false);
                    }
                    break block9;
                }
                break block9;
            }
            if (levels[0] == null || !(levels[0] instanceof XMLA_Level)) break block9;
            for (int i = levels.length - 1; i >= 0; --i) {
                XMLA_Level xLevel = (XMLA_Level)levels[i];
                if (xLevel == null || !xLevel.isZooming()) continue;
                xLevel.setZooming(false);
                try {
                    XMLA_Member[] members = xLevel.getMembers();
                    if (members == null) {
                        return;
                    }
                    for (int j = 0; j < members.length; ++j) {
                        XMLA_Member member = members[j];
                        if (member == null) continue;
                        members[j].setZooming(false);
                    }
                    break;
                }
                catch (OlapException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setDrilling(Member m, boolean isDrillDown) {
        block19: {
            XMLA_Level xl;
            XMLA_Member member;
            block20: {
                block17: {
                    MondrianLevel ml;
                    MondrianMember member2;
                    block18: {
                        if (m == null) {
                            return;
                        }
                        if (!(m instanceof MondrianMember)) break block17;
                        member2 = (MondrianMember)m;
                        if (!isDrillDown) break block18;
                        member2.setDrilling(true);
                        Level level = member2.getLevel();
                        if (level == null) break block19;
                        ((MondrianLevel)level).setDrilling(true);
                        break block19;
                    }
                    member2.setDrilling(false);
                    Level level = member2.getLevel();
                    if (level == null) {
                        return;
                    }
                    Hierarchy hierarchy = level.getHierarchy();
                    if (hierarchy == null) {
                        return;
                    }
                    MondrianLevel[] mls = (MondrianLevel[])hierarchy.getLevels();
                    if (mls == null) {
                        return;
                    }
                    for (int idx = 0; !(idx >= mls.length || (ml = mls[idx]) != null && ml.equals(member2.getLevel())); ++idx) {
                    }
                    for (int j = idx; j < mls.length; ++j) {
                        if (mls[j] == null) continue;
                        mls[j].setDrilling(false);
                        List mlist = mls[j].getMembers();
                        if (mlist == null) {
                            return;
                        }
                        for (Object mm : mlist) {
                            if (mm == null) continue;
                            ((MondrianMember)mm).setDrilling(false);
                        }
                    }
                    break block19;
                }
                if (!(m instanceof XMLA_Member)) break block19;
                member = (XMLA_Member)m;
                if (!isDrillDown) break block20;
                member.setDrilling(true);
                Level level = member.getLevel();
                if (level == null) break block19;
                ((XMLA_Level)level).setDrilling(true);
                break block19;
            }
            member.setDrilling(false);
            Level level = member.getLevel();
            if (level == null) {
                return;
            }
            Hierarchy hierarchy = level.getHierarchy();
            if (hierarchy == null) {
                return;
            }
            XMLA_Level[] xls = (XMLA_Level[])hierarchy.getLevels();
            if (xls == null) {
                return;
            }
            for (int idx = 0; !(idx >= xls.length || (xl = xls[idx]) != null && xl.equals(member.getLevel())); ++idx) {
            }
            for (int j = idx; xls != null && j < xls.length; ++j) {
                if (xls[j] == null) continue;
                xls[j].setDrilling(false);
                try {
                    XMLA_Member[] xlist = xls[j].getMembers();
                    if (xlist == null) {
                        return;
                    }
                    for (int k = 0; k < xlist.length; ++k) {
                        XMLA_Member xm = xlist[k];
                        if (xm == null) continue;
                        xm.setDrilling(false);
                    }
                    continue;
                }
                catch (OlapException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void push(Step step) {
        if (step == null) {
            return;
        }
        if (step.getTarget() instanceof MondrianMember) {
            Stack navigationTrace;
            boolean exist = false;
            String action = step.getAction();
            if (action != null && action.startsWith("expand")) {
                if (this.model == null) {
                    return;
                }
                Stack navigationTrace2 = ((MondrianModel)this.model).getNavigationTrace();
                if (navigationTrace2 == null) {
                    return;
                }
                for (Step s : navigationTrace2) {
                    if (s == null || !s.getAction().equals("drillDown")) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    return;
                }
            }
            boolean found = false;
            MondrianMember member = (MondrianMember)step.getTarget();
            if (member == null) {
                return;
            }
            action = step.getAction();
            if (action != null && action.startsWith("expand")) {
                if (this.model == null) {
                    return;
                }
                navigationTrace = ((MondrianModel)this.model).getNavigationTrace();
                if (navigationTrace == null) {
                    return;
                }
                for (Step s : navigationTrace) {
                    if (s == null) {
                        return;
                    }
                    MondrianMember mm = (MondrianMember)s.getTarget();
                    if (mm == null) {
                        return;
                    }
                    MondrianLevel level = (MondrianLevel)mm.getLevel();
                    if (level == null || !level.equals(member.getLevel())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (this.model == null) {
                    return;
                }
                navigationTrace = ((MondrianModel)this.model).getNavigationTrace();
                if (navigationTrace != null) {
                    navigationTrace.push(step);
                }
            }
        } else if (step.getTarget() instanceof XMLA_Member) {
            Stack navigationTrace;
            boolean exist = false;
            if (step.action.startsWith("expand")) {
                if (this.model == null) {
                    return;
                }
                Stack navigationTrace3 = ((XMLA_Model)this.model).getNavigationTrace();
                if (navigationTrace3 == null) {
                    return;
                }
                for (Step s : navigationTrace3) {
                    if (s == null || s.getAction() == null || !s.getAction().equals("drillDown")) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    return;
                }
            }
            boolean found = false;
            XMLA_Member member = (XMLA_Member)step.getTarget();
            if (member == null) {
                return;
            }
            String action = step.getAction();
            if (action != null && action.startsWith("expand")) {
                if (this.model == null) {
                    return;
                }
                navigationTrace = ((XMLA_Model)this.model).getNavigationTrace();
                if (navigationTrace == null) {
                    return;
                }
                for (Step s : navigationTrace) {
                    if (s == null) {
                        return;
                    }
                    Object xm = s.getTarget();
                    if (xm == null) {
                        return;
                    }
                    XMLA_Level level = (XMLA_Level)((XMLA_Member)xm).getLevel();
                    if (level == null || !level.equals(member.getLevel())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (this.model == null) {
                    return;
                }
                navigationTrace = ((XMLA_Model)this.model).getNavigationTrace();
                if (navigationTrace != null) {
                    navigationTrace.push(step);
                }
            }
        }
    }

    protected void pop(Step step) {
        logger.debug((Object)this.resources.getString("jp.core.debug.handlePopAction", new Object[]{step.getAction(), step.getTarget()}));
        if (step != null && step.getAction().equals("drillUp")) {
            this.popLevel(step);
        }
    }

    private void popLevel(Step step) {
        block32: {
            boolean found;
            block31: {
                if (this.model == null) {
                    return;
                }
                found = false;
                if (!(this.model instanceof MondrianModel)) break block31;
                MondrianModel mm = (MondrianModel)this.model;
                Stack navigationTrace = mm.getNavigationTrace();
                if (navigationTrace == null) {
                    return;
                }
                while (!navigationTrace.isEmpty() && !found) {
                    MondrianMember mm1;
                    Step popStep = (Step)navigationTrace.pop();
                    if (popStep == null) {
                        return;
                    }
                    logger.debug((Object)this.resources.getString("jp.core.debug.expandPosition", new Object[]{popStep.getTarget()}));
                    String action = popStep.getAction();
                    if (action != null && action.startsWith("expand")) {
                        mm1 = (MondrianMember)popStep.getTarget();
                        if (mm1 == null) {
                            return;
                        }
                        Level level = mm1.getLevel();
                        if (level == null) {
                            return;
                        }
                        List members = ((MondrianLevel)level).getMembers();
                        if (members == null) {
                            return;
                        }
                        for (MondrianMember mm2 : members) {
                            if (mm2 == null) continue;
                            mm2.setDrilling(false);
                        }
                        continue;
                    }
                    if (action == null || !action.equals("drillDown")) continue;
                    logger.debug((Object)this.resources.getString("jp.core.debug.drillDown", new Object[]{popStep.getTarget()}));
                    if (step == null) {
                        return;
                    }
                    if (step.getAction() != null && step.getAction().equals("drillUp")) {
                        mm1 = (MondrianMember)popStep.getTarget();
                        if (mm1 == null) {
                            return;
                        }
                        MondrianLevel mlPopStep = (MondrianLevel)mm1.getLevel();
                        if (mlPopStep == null) {
                            return;
                        }
                        MondrianLevel mlStep = (MondrianLevel)step.getTarget();
                        if (mlStep == null) {
                            return;
                        }
                        if (mlPopStep.getHierarchy() != null && mlPopStep.getHierarchy().equals(mlStep.getHierarchy()) && mlStep.getDepth() - 1 == mlPopStep.getDepth()) {
                            found = true;
                        }
                    }
                    if (found) continue;
                    MondrianLevel nextLevel = (MondrianLevel)this.getNextLevel((Member)popStep.getTarget());
                    this.drillUpLevel(nextLevel, true);
                }
                break block32;
            }
            if (!(this.model instanceof XMLA_Model)) break block32;
            Stack navigationTrace = ((XMLA_Model)this.model).getNavigationTrace();
            if (navigationTrace == null) {
                return;
            }
            while (!navigationTrace.isEmpty() && !found) {
                Step popStep = (Step)navigationTrace.pop();
                if (popStep == null) {
                    return;
                }
                logger.debug((Object)this.resources.getString("jp.core.debug.xmlaExpandPosition", new Object[]{popStep.getTarget()}));
                if (popStep.getAction() != null && popStep.getAction().startsWith("expand")) {
                    try {
                        XMLA_Member xm = (XMLA_Member)popStep.getTarget();
                        if (xm == null) {
                            return;
                        }
                        Level level = xm.getLevel();
                        if (level == null) {
                            return;
                        }
                        XMLA_Member[] members = ((XMLA_Level)level).getMembers();
                        if (members == null) {
                            return;
                        }
                        for (int i = 0; i < members.length; ++i) {
                            XMLA_Member xm1 = members[i];
                            if (xm1 == null) continue;
                            xm1.setDrilling(false);
                        }
                        continue;
                    }
                    catch (OlapException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                if (!popStep.getAction().equals("drillDown")) continue;
                logger.debug((Object)this.resources.getString("jp.core.debug.xmlaDrillDown", new Object[]{popStep.getTarget()}));
                if (step == null) {
                    return;
                }
                if (step.getAction() != null && step.getAction().equals("drillUp")) {
                    XMLA_Member xm = (XMLA_Member)popStep.getTarget();
                    if (xm == null) {
                        return;
                    }
                    XMLA_Level xlPopStep = (XMLA_Level)xm.getLevel();
                    if (xlPopStep == null) {
                        return;
                    }
                    XMLA_Level xlStep = (XMLA_Level)step.getTarget();
                    if (xlStep == null) {
                        return;
                    }
                    if (xlPopStep.getHierarchy().equals(xlStep.getHierarchy()) && xlStep.getDepth() - 1 == xlPopStep.getDepth()) {
                        found = true;
                    }
                }
                if (found) continue;
                Level nextLevel = this.getNextLevel((Member)popStep.getTarget());
                this.drillUpLevel(nextLevel, true);
            }
        }
    }

    protected Level getNextLevel(Member member) {
        int i;
        if (member == null) {
            return null;
        }
        Level level = member.getLevel();
        if (level == null) {
            return null;
        }
        Hierarchy hierarchy = level.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        Level[] levels = hierarchy.getLevels();
        if (levels == null) {
            return null;
        }
        for (i = 0; !(i >= levels.length || levels[i] != null && levels[i].equals(level)); ++i) {
        }
        return levels[i + 1];
    }

    public void collapsePosition(Member[] pathMembers, boolean isHidden) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        if (model == null) {
            return;
        }
        QueryAdapter qa = model.getQueryAdapter();
        if (qa == null) {
            return;
        }
        qa.collapse(pathMembers);
        Member member = pathMembers[pathMembers.length - 1];
        this.setDrilling(member, false);
    }

    public void collapseMember(Member member, boolean isHidden) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        if (model == null) {
            return;
        }
        QueryAdapter qa = model.getQueryAdapter();
        if (qa == null) {
            return;
        }
        qa.collapse(member);
        this.setDrilling(member, false);
    }

    public void drillUpLevel(Level level, boolean isHidden) {
        QueryAdapter.QueryAdapterHolder model;
        if (!isHidden) {
            this.pop(new Step("drillUp", level));
        }
        if ((model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel())) == null) {
            return;
        }
        QueryAdapter qa = model.getQueryAdapter();
        if (qa == null) {
            return;
        }
        qa.drillUp(level);
        this.setZoomOut(level.getHierarchy());
    }

    public void drillUpHierarchy(Hierarchy hier, boolean isHidden) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        if (model == null) {
            return;
        }
        QueryAdapter qa = model.getQueryAdapter();
        if (qa == null) {
            return;
        }
        qa.drillUp(hier);
        this.setZoomOut(hier);
    }

    public class Step {
        String action;
        Object target;

        public Step(String action, Object target) {
            this.action = action;
            this.target = target;
        }

        public String getAction() {
            return this.action;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

