/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianPlaceHierarchies;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.PlaceMembersOnAxes;
import com.tonbeller.jpivot.olap.query.Quax;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MondrianPlaceMembers
extends MondrianPlaceHierarchies
implements PlaceMembersOnAxes {
    public MondrianPlaceMembers() {
        this.setId("membersOnAxes");
    }

    public Object createMemberExpression(List members) {
        ArrayList<mondrian.olap.Member> memberList = new ArrayList<mondrian.olap.Member>();
        for (MondrianMember mem : members) {
            memberList.add(mem.getMonMember());
        }
        return memberList;
    }

    public List findVisibleMembers(Hierarchy hier) {
        ArrayList<MondrianMember> memberList = null;
        MondrianModel model = (MondrianModel)this.getModel();
        MondrianQueryAdapter adapter = (MondrianQueryAdapter)model.getQueryAdapter();
        Quax quax = adapter.findQuax(hier.getDimension());
        if (quax == null) {
            return Collections.EMPTY_LIST;
        }
        int iDim = quax.dimIdx(hier.getDimension());
        Result res = null;
        memberList = new ArrayList<MondrianMember>();
        try {
            res = model.getResult();
        }
        catch (OlapException e) {
            e.printStackTrace();
            logger.error((Object)this.resources.getString("jpivot.MondrianPlaceMembers.error.getResultFailed"));
            return Collections.EMPTY_LIST;
        }
        int iAx = quax.getOrdinal();
        if (adapter.isSwapAxes()) {
            iAx = (iAx + 1) % 2;
        }
        Axis axis = res.getAxes()[iAx];
        List positions = axis.getPositions();
        for (Position pos : positions) {
            Member[] members = pos.getMembers();
            MondrianMember mem = (MondrianMember)members[iDim];
            if (mem == null || memberList.contains(mem)) continue;
            memberList.add(mem);
        }
        return memberList;
    }
}

