/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.SortRank;
import com.tonbeller.jpivot.test.olap.TestExtensionSupport;
import java.util.Arrays;

public class TestSortRank
extends TestExtensionSupport
implements SortRank {
    Position sortPosition;
    int sortMode = 1;
    int topBottomCount = 10;
    boolean sorting = true;

    public boolean isSortable(Position position) {
        Member[] members = position.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].getLevel().getHierarchy().getDimension().isMeasure()) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentSorting(Position position) {
        if (this.sortPosition == null) {
            return false;
        }
        return Arrays.equals(this.sortPosition.getMembers(), position.getMembers());
    }

    public void sort(Axis membersToSort, Position position) {
        this.sortPosition = position;
        this.fireModelChanged();
    }

    public int getSortMode() {
        return this.sortMode;
    }

    public int getTopBottomCount() {
        return this.topBottomCount;
    }

    public void setSortMode(int sortMode) {
        this.sortMode = sortMode;
        this.fireModelChanged();
    }

    public void setTopBottomCount(int topBottomCount) {
        this.topBottomCount = topBottomCount;
        this.fireModelChanged();
    }

    public boolean isSorting() {
        return this.sorting;
    }

    public void setSorting(boolean sorting) {
        this.sorting = sorting;
        this.fireModelChanged();
    }

    public boolean getSortAcrossCubeHierarchy() {
        return false;
    }

    public void setSortAcrossCubeHierarchy(boolean b) {
    }

    public boolean getSortInDescendingOrder() {
        return false;
    }

    public void setSortInDescendingOrder(boolean b) {
    }

    public boolean getDisplayFirstNumRows() {
        return false;
    }

    public void setDisplayFirstNumRows(boolean b) {
    }
}

