/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.lang.reflect.Method;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xom.NodeWrapper;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected int documentNumber;
    private HashMap idIndex;
    private static final Method saxon85Method = DocumentWrapper.findAllocateDocumentNumberMethod85();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DocumentWrapper(Node root, String baseURI, Configuration config) {
        super(root, null, 0);
        if (root.getParent() != null) {
            throw new IllegalArgumentException("root node must not have a parent node");
        }
        this.baseURI = baseURI;
        this.docWrapper = this;
        this.setConfiguration(config);
    }

    public NodeInfo wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = this.allocateDocumentNumber(config);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String id) {
        if (this.idIndex == null) {
            Element elem;
            switch (this.nodeKind) {
                case 9: {
                    elem = ((Document)this.node).getRootElement();
                    break;
                }
                case 1: {
                    elem = (Element)this.node;
                    break;
                }
                default: {
                    return null;
                }
            }
            this.idIndex = new HashMap(50);
            this.buildIDIndex(elem);
        }
        return (NodeInfo)this.idIndex.get(id);
    }

    private void buildIDIndex(Element elem) {
        int i = elem.getChildCount();
        while (--i >= 0) {
            Node child = elem.getChild(i);
            if (!(child instanceof Element)) continue;
            this.buildIDIndex((Element)child);
        }
        i = elem.getAttributeCount();
        while (--i >= 0) {
            Attribute att = elem.getAttribute(i);
            if (att.getType() != Attribute.Type.ID) continue;
            this.idIndex.put(att.getValue(), this.wrap((Node)elem));
        }
    }

    public String[] getUnparsedEntity(String name) {
        return null;
    }

    private int allocateDocumentNumber(Configuration config) {
        if (saxon85Method == null) {
            try {
                return this.allocateDocumentNumber851(config);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        try {
            Object result = saxon85Method.invoke((Object)config.getNamePool(), this);
            return (Integer)result;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private int allocateDocumentNumber851(Configuration config) {
        return config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    private static Method findAllocateDocumentNumberMethod85() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sf.saxon.om.NamePool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("net.sf.saxon.om.NodeInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            return clazz.getMethod("allocateDocumentNumber", classArray);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

