/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import nux.xom.xquery.XQueryUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.index.memory.PatternAnalyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

public class MemoryIndexBenchmark {
    private MemoryIndexBenchmark() {
    }

    public static void main(String[] args) throws Exception {
        int iters = Integer.parseInt(args[0]);
        int runs = Integer.parseInt(args[1]);
        Document doc = new Builder().build(new File(args[2]));
        String path = args[3];
        String queryExpr = args[4];
        PatternAnalyzer textAnalyzer = PatternAnalyzer.DEFAULT_ANALYZER;
        PatternAnalyzer queryAnalyzer = PatternAnalyzer.DEFAULT_ANALYZER;
        String field = "f";
        Nodes lines = XQueryUtil.xquery((Node)doc, path);
        System.out.println("lines=" + lines.size());
        MemoryIndex[] indexes = new MemoryIndex[lines.size()];
        int i = 0;
        while (i < lines.size()) {
            indexes[i] = new MemoryIndex();
            indexes[i].addField(field, lines.get(i).getValue(), textAnalyzer);
            ++i;
        }
        doc = null;
        lines = null;
        Query query = new QueryParser(field, (Analyzer)queryAnalyzer).parse(queryExpr);
        float sum = 0.0f;
        int run = 0;
        while (run < runs) {
            System.out.println("\nrun=" + run);
            long start = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < iters) {
                int j = 0;
                while (j < indexes.length) {
                    sum += indexes[j].search(query);
                    ++j;
                }
                ++i2;
            }
            long end = System.currentTimeMillis();
            System.out.println("secs = " + (float)(end - start) / 1000.0f);
            System.out.println("queries/sec = " + (float)(indexes.length * iters) / ((float)(end - start) / 1000.0f));
            ++run;
        }
        System.out.println("checksum=" + sum);
    }
}

