/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.xquery;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xom.DocumentWrapper;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.DocumentFactory;
import nux.xom.pool.DocumentURIResolver;
import nux.xom.xquery.DefaultResultSequence;
import nux.xom.xquery.ResultSequence;
import nux.xom.xquery.XQueryException;
import nux.xom.xquery.XQueryUtil;
import org.xml.sax.InputSource;

public class XQuery {
    private final XQueryExpression expression;
    private final StaticQueryContext staticContext;
    private static final boolean TRACE = XQueryUtil.getSystemProperty("nux.xom.xquery.XQuery.trace", false);
    private static final boolean DEBUG = XQueryUtil.getSystemProperty("nux.xom.xquery.XQuery.debug", false);
    private static final boolean ALLOW_EXTERNAL_FUNCTIONS = XQueryUtil.getSystemProperty("nux.xom.xquery.XQuery.allowExternalFunctions", true);
    private static final boolean SHARE_NAMEPOOLS = XQueryUtil.getSystemProperty("nux.xom.xquery.XQuery.shareNamePools", true);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public XQuery(String query, URI baseURI) throws XQueryException {
        this(query, baseURI, null, null);
    }

    public XQuery(String query, URI baseURI, StaticQueryContext staticContext, DocumentURIResolver resolver) throws XQueryException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        staticContext = staticContext == null ? new StaticQueryContext(XQuery.createConfiguration()) : staticContext.copy();
        this.staticContext = staticContext;
        if (baseURI != null) {
            staticContext.setBaseURI(baseURI.toASCIIString());
        }
        final Configuration config = staticContext.getConfiguration();
        if (resolver == null) {
            resolver = new DefaultDocumentURIResolver(config);
        }
        final DocumentURIResolver myResolver = resolver;
        config.setURIResolver(new URIResolver(){

            public Source resolve(String href, String baseURI) throws TransformerException {
                try {
                    Document doc = myResolver.resolve(href, baseURI);
                    if (doc == null) {
                        doc = new DefaultDocumentURIResolver(config).resolve(href, baseURI);
                    }
                    return XQuery.this.wrap((Node)doc, null);
                }
                catch (ParsingException e) {
                    throw new TransformerException(e);
                }
                catch (IOException e) {
                    throw new TransformerException(e);
                }
            }
        });
        try {
            this.expression = staticContext.compileQuery(query);
        }
        catch (TransformerException e) {
            throw new XQueryException(e);
        }
    }

    public ResultSequence execute(Node contextNode) throws XQueryException {
        return this.execute(contextNode, null, null);
    }

    public ResultSequence execute(Node contextNode, DynamicQueryContext dynamicContext, Map variables) throws XQueryException {
        if (dynamicContext == null) {
            dynamicContext = new DynamicQueryContext(this.getStaticContext().getConfiguration());
        }
        try {
            this.setupDynamicContext(contextNode, dynamicContext, variables);
        }
        catch (TransformerException e) {
            throw new XQueryException(e);
        }
        return this.newResultSequence(this.expression, dynamicContext);
    }

    public String explain() {
        try {
            return this.explain871();
        }
        catch (Throwable t) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Class[] classArray = new Class[3];
                classArray[0] = Integer.TYPE;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.sf.saxon.om.NamePool");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.io.PrintStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz2;
                Class[] types = classArray;
                Object[] args = new Object[]{new Integer(0), this.getStaticContext().getNamePool(), new PrintStream(out)};
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("net.sf.saxon.expr.Expression");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                clazz3.getMethod("display", types).invoke((Object)this.expression.getExpression(), args);
                return out.toString();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String explain871() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.expression.getExpression().display(0, new PrintStream(out), this.getStaticContext().getConfiguration());
        return out.toString();
    }

    protected ResultSequence newResultSequence(XQueryExpression expression, DynamicQueryContext dynamicContext) throws XQueryException {
        try {
            return new DefaultResultSequence(expression.iterator(dynamicContext), this.getStaticContext().getConfiguration());
        }
        catch (TransformerException e) {
            throw new XQueryException(e);
        }
    }

    private static Configuration createConfiguration() {
        Configuration config = new Configuration();
        config.setHostLanguage(51);
        config.setErrorListener((ErrorListener)new DefaultErrorListener());
        config.setAllowExternalFunctions(ALLOW_EXTERNAL_FUNCTIONS);
        if (!SHARE_NAMEPOOLS) {
            config.setNamePool(new NamePool());
        }
        if (TRACE) {
            config.setTraceListener((TraceListener)new XQueryTraceListener());
            config.setTraceExternalFunctions(true);
        }
        return config;
    }

    private NodeInfo wrap(Node node, HashMap docWrappers) throws TransformerException {
        if (node == null) {
            throw new TransformerException("node must not be null");
        }
        if (node instanceof DocType) {
            throw new TransformerException("DocType can't be queried by XQuery/XPath");
        }
        Node root = node;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        DocumentWrapper docWrapper = null;
        if (docWrappers != null) {
            docWrapper = (DocumentWrapper)docWrappers.get(root);
        }
        if (docWrapper == null) {
            docWrapper = new DocumentWrapper(root, root.getBaseURI(), this.getStaticContext().getConfiguration());
            if (docWrappers != null) {
                docWrappers.put(root, docWrapper);
            }
        }
        return docWrapper.wrap(node);
    }

    private void setupDynamicContext(Node contextNode, DynamicQueryContext dynamicContext, Map variables) throws TransformerException {
        HashMap docWrappers = null;
        if (variables != null && variables.size() > 0) {
            docWrappers = new HashMap();
        }
        if (contextNode != null) {
            dynamicContext.setContextItem((Item)this.wrap(contextNode, docWrappers));
        }
        if (docWrappers == null) {
            return;
        }
        Iterator iter = variables.entrySet().iterator();
        while (iter.hasNext()) {
            Object[] files;
            int i;
            Node[] nodes;
            Object value;
            Map.Entry entry = iter.next();
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("variable key must not be null");
            }
            String name = entry.getKey().toString();
            if (name.length() > 0 && name.charAt(0) == '$') {
                name = name.substring(1);
            }
            if ((value = entry.getValue()) instanceof CharSequence) {
                value = new UntypedAtomicValue((CharSequence)value);
            } else if (value instanceof Node) {
                value = this.wrap((Node)value, docWrappers);
            } else if (value instanceof Nodes) {
                nodes = (Node[])value;
                int size = nodes.size();
                ArrayList<NodeInfo> sources = new ArrayList<NodeInfo>(size);
                i = 0;
                while (i < size) {
                    sources.add(this.wrap(nodes.get(i), docWrappers));
                    ++i;
                }
                value = sources;
            } else if (value instanceof Node[]) {
                nodes = (Node[])value;
                int size = nodes.length;
                ArrayList<NodeInfo> sources = new ArrayList<NodeInfo>(size);
                i = 0;
                while (i < size) {
                    sources.add(this.wrap(nodes[i], docWrappers));
                    ++i;
                }
                value = sources;
            } else if (value instanceof File || value instanceof File[]) {
                if (value instanceof File) {
                    value = new File[]{(File)value};
                }
                files = (File[])value;
                ArrayList<NodeInfo> sources = new ArrayList<NodeInfo>(files.length);
                Builder builder = BuilderPool.GLOBAL_POOL.getBuilder(false);
                i = 0;
                while (i < files.length) {
                    if (!((File)files[i]).isDirectory()) {
                        Document doc;
                        try {
                            doc = builder.build((File)files[i]);
                        }
                        catch (Exception e) {
                            throw new TransformerException(e);
                        }
                        sources.add(this.wrap((Node)doc, docWrappers));
                    }
                    ++i;
                }
                value = sources;
            } else if (value instanceof InputSource || value instanceof InputSource[]) {
                if (value instanceof InputSource) {
                    value = new InputSource[]{(InputSource)value};
                }
                files = (InputSource[])value;
                ArrayList<SAXSource> sources = new ArrayList<SAXSource>(files.length);
                int i2 = 0;
                while (i2 < files.length) {
                    sources.add(new SAXSource(this.getStaticContext().getConfiguration().getSourceParser(), (InputSource)files[i2]));
                    ++i2;
                }
                value = sources;
            }
            dynamicContext.setParameter(name, value);
        }
    }

    private StaticQueryContext getStaticContext() {
        try {
            return this.getStaticContext84();
        }
        catch (Error e) {
            return this.staticContext;
        }
    }

    private StaticQueryContext getStaticContext84() {
        return this.expression.getStaticContext();
    }

    private static final class DefaultErrorListener
    implements ErrorListener {
        private static final boolean WARN = XQueryUtil.getSystemProperty("nux.xom.xquery.XQuery.warn", true);

        private DefaultErrorListener() {
        }

        public void error(TransformerException e) throws TransformerException {
            throw e;
        }

        public void fatalError(TransformerException e) throws TransformerException {
            throw e;
        }

        public void warning(TransformerException e) throws TransformerException {
            if (WARN) {
                System.err.println("Warning: " + e);
            }
        }
    }

    private static final class DefaultDocumentURIResolver
    implements DocumentURIResolver {
        private final Configuration config;

        private DefaultDocumentURIResolver(Configuration config) {
            this.config = config;
        }

        public Document resolve(String href, String baseURI) throws ParsingException, IOException, TransformerException {
            String systemID = new StandardURIResolver(this.config).resolve(href, baseURI).getSystemId();
            if (DEBUG) {
                System.err.println("href=" + href);
                System.err.println("baseURI=" + baseURI);
                System.err.println("systemID=" + systemID);
            }
            if (systemID != null && systemID.endsWith(".bnux")) {
                return new DocumentFactory().getBinaryXMLFactory().createDocument(null, URI.create(systemID));
            }
            return BuilderPool.GLOBAL_POOL.getBuilder(false).build(systemID);
        }
    }
}

