/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.aggmatcher.AggGen;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.spi.Dialect;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastBatchingCellReader
implements CellReader {
    private static final Logger LOGGER = Logger.getLogger(FastBatchingCellReader.class);
    private static boolean generateAggregateSql = MondrianProperties.instance().GenerateAggregateSql.get();
    private final RolapCube cube;
    private final Map<AggregationKey, Batch> batches;
    private int requestCount;
    final AggregationManager aggMgr = AggregationManager.instance();
    private final RolapAggregationManager.PinSet pinnedSegments = this.aggMgr.createPinSet();
    private boolean dirty;
    private static final Logger BATCH_LOGGER;

    public FastBatchingCellReader(RolapCube cube) {
        assert (cube != null);
        this.cube = cube;
        this.batches = new HashMap<AggregationKey, Batch>();
    }

    @Override
    public Object get(RolapEvaluator evaluator) {
        CellRequest request = RolapAggregationManager.makeRequest(evaluator);
        if (request == null || request.isUnsatisfiable()) {
            return Util.nullValue;
        }
        Object o = this.aggMgr.getCellFromCache(request, this.pinnedSegments);
        if (o == Boolean.TRUE) {
            return RolapUtil.valueNotReadyException;
        }
        if (o != null) {
            return o;
        }
        this.recordCellRequest(request);
        return RolapUtil.valueNotReadyException;
    }

    @Override
    public int getMissCount() {
        return this.requestCount;
    }

    public final void recordCellRequest(CellRequest request) {
        if (request.isUnsatisfiable()) {
            return;
        }
        ++this.requestCount;
        AggregationKey key = new AggregationKey(request);
        Batch batch = this.batches.get(key);
        if (batch == null) {
            batch = new Batch(request);
            this.batches.put(key, batch);
            if (LOGGER.isDebugEnabled()) {
                RolapStar.Column[] columns;
                StringBuilder buf = new StringBuilder(100);
                buf.append("FastBatchingCellReader: bitkey=");
                buf.append(request.getConstrainedColumnsBitKey());
                buf.append(Util.nl);
                for (RolapStar.Column column : columns = request.getConstrainedColumns()) {
                    buf.append("  ");
                    buf.append(column);
                    buf.append(Util.nl);
                }
                LOGGER.debug((Object)buf.toString());
            }
        }
        batch.add(request);
    }

    @Override
    public boolean isDirty() {
        return this.dirty || !this.batches.isEmpty();
    }

    boolean loadAggregations() {
        return this.loadAggregations(null);
    }

    boolean loadAggregations(Query query) {
        long t1 = System.currentTimeMillis();
        if (!this.isDirty()) {
            return false;
        }
        ArrayList<Batch> batchList = new ArrayList<Batch>(this.batches.values());
        Collections.sort(batchList, BatchComparator.instance);
        if (this.shouldUseGroupingFunction()) {
            LOGGER.debug((Object)"Using grouping sets");
            List<CompositeBatch> groupedBatches = this.groupBatches(batchList);
            for (CompositeBatch batch : groupedBatches) {
                this.loadAggregation(query, batch);
            }
        } else {
            for (Batch batch : batchList) {
                this.loadAggregation(query, batch);
            }
        }
        this.batches.clear();
        this.dirty = false;
        if (LOGGER.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            LOGGER.debug((Object)("loadAggregation (millis): " + (t2 - t1)));
        }
        return true;
    }

    private void loadAggregation(Query query, Loadable batch) {
        if (query != null) {
            query.checkCancelOrTimeout();
        }
        batch.loadAggregation();
    }

    List<CompositeBatch> groupBatches(List<Batch> batchList) {
        HashMap<AggregationKey, CompositeBatch> batchGroups = new HashMap<AggregationKey, CompositeBatch>();
        for (int i = 0; i < batchList.size(); ++i) {
            int j = i + 1;
            while (j < batchList.size() && i < batchList.size()) {
                Batch jBatch;
                Batch iBatch = batchList.get(i);
                if (iBatch.canBatch(jBatch = batchList.get(j))) {
                    batchList.remove(j);
                    this.addToCompositeBatch(batchGroups, iBatch, jBatch);
                    continue;
                }
                if (jBatch.canBatch(iBatch)) {
                    batchList.set(i, jBatch);
                    batchList.remove(j);
                    this.addToCompositeBatch(batchGroups, jBatch, iBatch);
                    j = i + 1;
                    continue;
                }
                ++j;
            }
        }
        this.wrapNonBatchedBatchesWithCompositeBatches(batchList, batchGroups);
        CompositeBatch[] compositeBatches = batchGroups.values().toArray(new CompositeBatch[batchGroups.size()]);
        Arrays.sort(compositeBatches, CompositeBatchComparator.instance);
        return Arrays.asList(compositeBatches);
    }

    private void wrapNonBatchedBatchesWithCompositeBatches(List<Batch> batchList, Map<AggregationKey, CompositeBatch> batchGroups) {
        for (Batch batch : batchList) {
            if (batchGroups.get(batch.batchKey) != null) continue;
            batchGroups.put(batch.batchKey, new CompositeBatch(batch));
        }
    }

    void addToCompositeBatch(Map<AggregationKey, CompositeBatch> batchGroups, Batch detailedBatch, Batch summaryBatch) {
        CompositeBatch compositeBatchOfSummaryBatch;
        CompositeBatch compositeBatch = batchGroups.get(detailedBatch.batchKey);
        if (compositeBatch == null) {
            compositeBatch = new CompositeBatch(detailedBatch);
            batchGroups.put(detailedBatch.batchKey, compositeBatch);
        }
        if ((compositeBatchOfSummaryBatch = batchGroups.remove(summaryBatch.batchKey)) != null) {
            compositeBatch.merge(compositeBatchOfSummaryBatch);
        } else {
            compositeBatch.add(summaryBatch);
        }
    }

    boolean shouldUseGroupingFunction() {
        return MondrianProperties.instance().EnableGroupingSets.get() && this.doesDBSupportGroupingSets();
    }

    boolean doesDBSupportGroupingSets() {
        return this.getDialect().supportsGroupingSets();
    }

    Dialect getDialect() {
        RolapStar star = this.cube.getStar();
        if (star != null) {
            return star.getSqlQueryDialect();
        }
        return this.cube.getSchema().getDialect();
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    static {
        MondrianProperties.instance().GenerateAggregateSql.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                generateAggregateSql = property.booleanValue();
            }
        });
        BATCH_LOGGER = Logger.getLogger(Batch.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueColumnConstraintComparator
    implements Comparator<ValueColumnPredicate> {
        static final ValueColumnConstraintComparator instance = new ValueColumnConstraintComparator();

        private ValueColumnConstraintComparator() {
        }

        @Override
        public int compare(ValueColumnPredicate o1, ValueColumnPredicate o2) {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1.getClass() == v2.getClass() && v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BatchComparator
    implements Comparator<Batch> {
        static final BatchComparator instance = new BatchComparator();

        private BatchComparator() {
        }

        @Override
        public int compare(Batch o1, Batch o2) {
            int c;
            int i;
            if (o1.columns.length != o2.columns.length) {
                return o1.columns.length - o2.columns.length;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = o1.columns[i].getName().compareTo(o2.columns[i].getName());
                if (c == 0) continue;
                return c;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = this.compare(o1.valueSets[i], o2.valueSets[i]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        <T> int compare(Set<T> set1, Set<T> set2) {
            if (set1.size() != set2.size()) {
                return set1.size() - set2.size();
            }
            Iterator<T> iter1 = set1.iterator();
            Iterator<T> iter2 = set2.iterator();
            while (iter1.hasNext()) {
                T v2;
                T v1 = iter1.next();
                int c = Util.compareKey(v1, v2 = iter2.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeBatchComparator
    implements Comparator<CompositeBatch> {
        static final CompositeBatchComparator instance = new CompositeBatchComparator();

        private CompositeBatchComparator() {
        }

        @Override
        public int compare(CompositeBatch o1, CompositeBatch o2) {
            return BatchComparator.instance.compare(o1.detailedBatch, o2.detailedBatch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Batch
    implements Loadable {
        final RolapStar.Column[] columns;
        final List<RolapStar.Measure> measuresList = new ArrayList<RolapStar.Measure>();
        final Set<StarColumnPredicate>[] valueSets;
        final AggregationKey batchKey;
        private String string;

        public Batch(CellRequest request) {
            this.columns = request.getConstrainedColumns();
            this.valueSets = new HashSet[this.columns.length];
            for (int i = 0; i < this.valueSets.length; ++i) {
                this.valueSets[i] = new HashSet<StarColumnPredicate>();
            }
            this.batchKey = new AggregationKey(request);
        }

        public String toString() {
            if (this.string == null) {
                StringBuilder buf = new StringBuilder();
                buf.append("Batch {\n").append("  columns={").append(Arrays.asList(this.columns)).append("}\n").append("  measures={").append(this.measuresList).append("}\n").append("  valueSets={").append(Arrays.asList(this.valueSets)).append("}\n").append("  batchKey=").append(this.batchKey).append("}\n").append("}");
                this.string = buf.toString();
            }
            return this.string;
        }

        public final void add(CellRequest request) {
            List<StarColumnPredicate> values = request.getValueList();
            for (int j = 0; j < this.columns.length; ++j) {
                this.valueSets[j].add(values.get(j));
            }
            RolapStar.Measure measure = request.getMeasure();
            if (!this.measuresList.contains(measure)) {
                assert (this.measuresList.size() == 0 || measure.getStar() == this.measuresList.get(0).getStar()) : "Measure must belong to same star as other measures";
                this.measuresList.add(measure);
            }
        }

        private RolapStar getStar() {
            RolapStar.Measure measure = this.measuresList.get(0);
            return measure.getStar();
        }

        public BitKey getConstrainedColumnsBitKey() {
            return this.batchKey.getConstrainedColumnsBitKey();
        }

        @Override
        public final void loadAggregation() {
            GroupingSetsCollector collectorWithGroupingSetsTurnedOff = new GroupingSetsCollector(false);
            this.loadAggregation(collectorWithGroupingSetsTurnedOff);
        }

        final void loadAggregation(GroupingSetsCollector groupingSetsCollector) {
            int measureCount;
            boolean tooManyDistinctMeasures;
            if (generateAggregateSql) {
                this.generateAggregateSql();
            }
            StarColumnPredicate[] predicates = this.initPredicates();
            long t1 = System.currentTimeMillis();
            AggregationManager aggmgr = AggregationManager.instance();
            Dialect dialect = FastBatchingCellReader.this.getDialect();
            int distinctMeasureCount = this.getDistinctMeasureCount(this.measuresList);
            boolean bl = tooManyDistinctMeasures = distinctMeasureCount > 0 && !dialect.allowsCountDistinct() || distinctMeasureCount > 1 && !dialect.allowsMultipleCountDistinct();
            if (tooManyDistinctMeasures) {
                this.doSpecialHandlingOfDistinctCountMeasures(aggmgr, predicates, groupingSetsCollector);
            }
            if (!dialect.allowsMultipleDistinctSqlMeasures()) {
                List<RolapStar.Measure> distinctSqlMeasureList = this.getDistinctSqlMeasures(this.measuresList);
                for (RolapStar.Measure measure : distinctSqlMeasureList) {
                    RolapStar.Measure[] measures = new RolapStar.Measure[]{measure};
                    aggmgr.loadAggregation(measures, this.columns, this.batchKey, predicates, FastBatchingCellReader.this.pinnedSegments, groupingSetsCollector);
                    this.measuresList.remove(measure);
                }
            }
            if ((measureCount = this.measuresList.size()) > 0) {
                RolapStar.Measure[] measures = this.measuresList.toArray(new RolapStar.Measure[measureCount]);
                aggmgr.loadAggregation(measures, this.columns, this.batchKey, predicates, FastBatchingCellReader.this.pinnedSegments, groupingSetsCollector);
            }
            if (BATCH_LOGGER.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                BATCH_LOGGER.debug((Object)("Batch.loadAggregation (millis) " + (t2 - t1)));
            }
        }

        private void doSpecialHandlingOfDistinctCountMeasures(AggregationManager aggmgr, StarColumnPredicate[] predicates, GroupingSetsCollector groupingSetsCollector) {
            RolapStar.Measure distinctMeasure;
            while ((distinctMeasure = this.getFirstDistinctMeasure(this.measuresList)) != null) {
                String expr = distinctMeasure.getExpression().getGenericExpression();
                ArrayList<RolapStar.Measure> distinctMeasuresList = new ArrayList<RolapStar.Measure>();
                int i = 0;
                while (i < this.measuresList.size()) {
                    RolapStar.Measure measure = this.measuresList.get(i);
                    if (measure.getAggregator().isDistinct() && measure.getExpression().getGenericExpression().equals(expr)) {
                        this.measuresList.remove(i);
                        distinctMeasuresList.add(distinctMeasure);
                        continue;
                    }
                    ++i;
                }
                RolapStar.Measure[] measures = distinctMeasuresList.toArray(new RolapStar.Measure[distinctMeasuresList.size()]);
                aggmgr.loadAggregation(measures, this.columns, this.batchKey, predicates, FastBatchingCellReader.this.pinnedSegments, groupingSetsCollector);
            }
        }

        private StarColumnPredicate[] initPredicates() {
            StarColumnPredicate[] predicates = new StarColumnPredicate[this.columns.length];
            for (int j = 0; j < this.columns.length; ++j) {
                AbstractColumnPredicate predicate;
                Set<StarColumnPredicate> valueSet = this.valueSets[j];
                if (valueSet == null) {
                    predicate = LiteralStarPredicate.FALSE;
                } else {
                    ValueColumnPredicate[] values = valueSet.toArray(new ValueColumnPredicate[valueSet.size()]);
                    Arrays.sort(values, ValueColumnConstraintComparator.instance);
                    predicate = new ListColumnPredicate(this.columns[j], Arrays.asList((StarColumnPredicate[])values));
                }
                predicates[j] = predicate;
            }
            return predicates;
        }

        private void generateAggregateSql() {
            RolapCube cube = FastBatchingCellReader.this.cube;
            if (cube == null || cube.isVirtual()) {
                StringBuilder buf = new StringBuilder(64);
                buf.append("AggGen: Sorry, can not create SQL for virtual Cube \"").append(cube.getName()).append("\", operation not currently supported");
                BATCH_LOGGER.error((Object)buf.toString());
            } else {
                AggGen aggGen = new AggGen(cube.getName(), cube.getStar(), this.columns);
                if (aggGen.isReady()) {
                    System.out.println("createLost:" + Util.nl + aggGen.createLost());
                    System.out.println("insertIntoLost:" + Util.nl + aggGen.insertIntoLost());
                    System.out.println("createCollapsed:" + Util.nl + aggGen.createCollapsed());
                    System.out.println("insertIntoCollapsed:" + Util.nl + aggGen.insertIntoCollapsed());
                } else {
                    BATCH_LOGGER.error((Object)"AggGen failed");
                }
            }
        }

        final RolapStar.Measure getFirstDistinctMeasure(List<RolapStar.Measure> measuresList) {
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct()) continue;
                return measure;
            }
            return null;
        }

        private int getDistinctMeasureCount(List<RolapStar.Measure> measuresList) {
            int count = 0;
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct()) continue;
                ++count;
            }
            return count;
        }

        private List<RolapStar.Measure> getDistinctSqlMeasures(List<RolapStar.Measure> measuresList) {
            ArrayList<RolapStar.Measure> distinctSqlMeasureList = new ArrayList<RolapStar.Measure>();
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct() || !(measure.getExpression() instanceof MondrianDef.MeasureExpression)) continue;
                MondrianDef.MeasureExpression measureExpr = (MondrianDef.MeasureExpression)measure.getExpression();
                MondrianDef.SQL measureSql = measureExpr.expressions[0];
                if (!measureSql.cdata.toUpperCase().contains("SELECT")) continue;
                distinctSqlMeasureList.add(measure);
            }
            return distinctSqlMeasureList;
        }

        boolean canBatch(Batch other) {
            return this.hasOverlappingBitKeys(other) && this.constraintsMatch(other) && this.hasSameMeasureList(other) && !this.hasDistinctCountMeasure() && !other.hasDistinctCountMeasure() && this.haveSameStarAndAggregation(other) && this.haveSameClosureColumns(other);
        }

        private boolean constraintsMatch(Batch other) {
            if (this.areBothDistinctCountBatches(other)) {
                if (this.getConstrainedColumnsBitKey().equals(other.getConstrainedColumnsBitKey())) {
                    return this.hasSameCompoundPredicate(other) && this.haveSameValues(other);
                }
                return this.hasSameCompoundPredicate(other) || (other.batchKey.getCompoundPredicateList().isEmpty() || this.equalConstraint(this.batchKey.getCompoundPredicateList(), other.batchKey.getCompoundPredicateList())) && this.haveSameValues(other);
            }
            return this.haveSameValues(other);
        }

        private boolean equalConstraint(List<StarPredicate> predList1, List<StarPredicate> predList2) {
            if (predList1.size() != predList2.size()) {
                return false;
            }
            for (int i = 0; i < predList1.size(); ++i) {
                StarPredicate pred2;
                StarPredicate pred1 = predList1.get(i);
                if (pred1.equalConstraint(pred2 = predList2.get(i))) continue;
                return false;
            }
            return true;
        }

        private boolean areBothDistinctCountBatches(Batch other) {
            return this.hasDistinctCountMeasure() && !this.hasNormalMeasures() && other.hasDistinctCountMeasure() && !other.hasNormalMeasures();
        }

        private boolean hasNormalMeasures() {
            return this.getDistinctMeasureCount(this.measuresList) != this.measuresList.size();
        }

        private boolean hasSameMeasureList(Batch other) {
            return this.measuresList.size() == other.measuresList.size() && this.measuresList.containsAll(other.measuresList);
        }

        boolean hasOverlappingBitKeys(Batch other) {
            return this.getConstrainedColumnsBitKey().isSuperSetOf(other.getConstrainedColumnsBitKey());
        }

        boolean hasDistinctCountMeasure() {
            return this.getDistinctMeasureCount(this.measuresList) > 0;
        }

        boolean hasSameCompoundPredicate(Batch other) {
            StarPredicate starPredicate = this.compoundPredicate();
            StarPredicate otherStarPredicate = other.compoundPredicate();
            if (starPredicate == null && otherStarPredicate == null) {
                return true;
            }
            if (starPredicate != null && otherStarPredicate != null) {
                return starPredicate.equalConstraint(otherStarPredicate);
            }
            return false;
        }

        private StarPredicate compoundPredicate() {
            StarPredicate predicate = null;
            for (Set<StarColumnPredicate> valueSet : this.valueSets) {
                StarPredicate orPredicate = null;
                for (StarColumnPredicate starColumnPredicate : valueSet) {
                    if (orPredicate == null) {
                        orPredicate = starColumnPredicate;
                        continue;
                    }
                    orPredicate = orPredicate.or(starColumnPredicate);
                }
                predicate = predicate == null ? orPredicate : predicate.and(orPredicate);
            }
            for (StarPredicate starPredicate : this.batchKey.getCompoundPredicateList()) {
                if (predicate == null) {
                    predicate = starPredicate;
                    continue;
                }
                predicate = predicate.and(starPredicate);
            }
            return predicate;
        }

        boolean haveSameStarAndAggregation(Batch other) {
            boolean[] rollup = new boolean[]{false};
            boolean[] otherRollup = new boolean[]{false};
            boolean hasSameAggregation = this.getAgg(rollup) == other.getAgg(otherRollup);
            boolean hasSameRollupOption = rollup[0] == otherRollup[0];
            boolean hasSameStar = this.getStar().equals(other.getStar());
            return hasSameStar && hasSameAggregation && hasSameRollupOption;
        }

        boolean haveSameClosureColumns(Batch other) {
            BitKey cubeClosureColumnBitKey = ((FastBatchingCellReader)FastBatchingCellReader.this).cube.closureColumnBitKey;
            if (cubeClosureColumnBitKey == null) {
                return true;
            }
            BitKey closureColumns = this.batchKey.getConstrainedColumnsBitKey().and(cubeClosureColumnBitKey);
            BitKey otherClosureColumns = other.batchKey.getConstrainedColumnsBitKey().and(cubeClosureColumnBitKey);
            return closureColumns.equals(otherClosureColumns);
        }

        private AggStar getAgg(boolean[] rollup) {
            AggregationManager aggregationManager = AggregationManager.instance();
            AggStar star = aggregationManager.findAgg(this.getStar(), this.getConstrainedColumnsBitKey(), this.makeMeasureBitKey(), rollup);
            return star;
        }

        private BitKey makeMeasureBitKey() {
            BitKey bitKey = this.getConstrainedColumnsBitKey().emptyCopy();
            for (RolapStar.Measure measure : this.measuresList) {
                bitKey.set(measure.getBitPosition());
            }
            return bitKey;
        }

        boolean haveSameValues(Batch other) {
            for (int j = 0; j < this.columns.length; ++j) {
                boolean isCommonColumn = false;
                for (int i = 0; i < other.columns.length; ++i) {
                    if (!this.areSameColumns(other.columns[i], this.columns[j])) continue;
                    if (this.hasSameValues(other.valueSets[i], this.valueSets[j])) {
                        isCommonColumn = true;
                        break;
                    }
                    return false;
                }
                if (isCommonColumn || this.hasAllValues(this.columns[j], this.valueSets[j])) continue;
                return false;
            }
            return true;
        }

        private boolean hasAllValues(RolapStar.Column column, Set<StarColumnPredicate> valueSet) {
            return column.getCardinality() == valueSet.size();
        }

        private boolean areSameColumns(RolapStar.Column otherColumn, RolapStar.Column thisColumn) {
            return otherColumn.equals(thisColumn);
        }

        private boolean hasSameValues(Set<StarColumnPredicate> otherValueSet, Set<StarColumnPredicate> thisValueSet) {
            return ((Object)otherValueSet).equals(thisValueSet);
        }
    }

    static interface Loadable {
        public void loadAggregation();
    }

    class CompositeBatch
    implements Loadable {
        final Batch detailedBatch;
        final List<Batch> summaryBatches = new ArrayList<Batch>();

        CompositeBatch(Batch detailedBatch) {
            this.detailedBatch = detailedBatch;
        }

        void add(Batch summaryBatch) {
            this.summaryBatches.add(summaryBatch);
        }

        void merge(CompositeBatch summaryBatch) {
            this.summaryBatches.add(summaryBatch.detailedBatch);
            this.summaryBatches.addAll(summaryBatch.summaryBatches);
        }

        public void loadAggregation() {
            GroupingSetsCollector batchCollector = new GroupingSetsCollector(true);
            this.detailedBatch.loadAggregation(batchCollector);
            for (Batch batch : this.summaryBatches) {
                batch.loadAggregation(batchCollector);
            }
            this.getSegmentLoader().load(batchCollector.getGroupingSets(), FastBatchingCellReader.this.pinnedSegments, this.detailedBatch.batchKey.getCompoundPredicateList());
        }

        SegmentLoader getSegmentLoader() {
            return new SegmentLoader();
        }
    }
}

