/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mondrian.olap.Annotation;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.LevelBase;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.MondrianDef;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapUtil;
import mondrian.spi.Dialect;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapLevel
extends LevelBase {
    private static final Logger LOGGER = Logger.getLogger(RolapLevel.class);
    protected MondrianDef.Expression keyExp;
    protected MondrianDef.Expression ordinalExp;
    protected MondrianDef.Expression captionExp;
    private final Dialect.Datatype datatype;
    private final int flags;
    static final int FLAG_ALL = 2;
    static final int FLAG_UNIQUE = 4;
    private RolapLevel closedPeerLevel;
    private final RolapProperty[] properties;
    private final RolapProperty[] inheritedProperties;
    protected MondrianDef.Expression nameExp;
    protected MondrianDef.Expression parentExp;
    private final String nullParentValue;
    private final HideMemberCondition hideMemberCondition;
    protected final MondrianDef.Closure xmlClosure;
    private final Map<String, Annotation> annotationMap;

    RolapLevel(RolapHierarchy hierarchy, String name, String caption, String description, int depth, MondrianDef.Expression keyExp, MondrianDef.Expression nameExp, MondrianDef.Expression captionExp, MondrianDef.Expression ordinalExp, MondrianDef.Expression parentExp, String nullParentValue, MondrianDef.Closure xmlClosure, RolapProperty[] properties, int flags, Dialect.Datatype datatype, HideMemberCondition hideMemberCondition, LevelType levelType, String approxRowCount, Map<String, Annotation> annotationMap) {
        super(hierarchy, name, caption, description, depth, levelType);
        assert (annotationMap != null);
        Util.assertPrecondition(properties != null, "properties != null");
        Util.assertPrecondition(hideMemberCondition != null, "hideMemberCondition != null");
        Util.assertPrecondition(levelType != null, "levelType != null");
        if (keyExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)keyExp);
        }
        this.annotationMap = annotationMap;
        this.approxRowCount = this.loadApproxRowCount(approxRowCount);
        this.flags = flags;
        this.datatype = datatype;
        this.keyExp = keyExp;
        if (nameExp != null && nameExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)nameExp);
        }
        this.nameExp = nameExp;
        if (captionExp != null && captionExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)captionExp);
        }
        this.captionExp = captionExp;
        if (ordinalExp != null) {
            if (ordinalExp instanceof MondrianDef.Column) {
                this.checkColumn((MondrianDef.Column)ordinalExp);
            }
            this.ordinalExp = ordinalExp;
        } else {
            this.ordinalExp = this.keyExp;
        }
        if (parentExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)parentExp);
        }
        this.parentExp = parentExp;
        if (parentExp != null) {
            Util.assertTrue(!this.isAll(), "'All' level '" + this + "' must not be parent-child");
            Util.assertTrue(this.isUnique(), "Parent-child level '" + this + "' must have uniqueMembers=\"true\"");
        }
        this.nullParentValue = nullParentValue;
        Util.assertPrecondition(parentExp != null || nullParentValue == null, "parentExp != null || nullParentValue == null");
        this.xmlClosure = xmlClosure;
        for (RolapProperty property : properties) {
            if (!(property.getExp() instanceof MondrianDef.Column)) continue;
            this.checkColumn((MondrianDef.Column)property.getExp());
        }
        this.properties = properties;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Level level = this; level != null; level = level.getParentLevel()) {
            Property[] levelProperties;
            for (Property levelProperty : levelProperties = level.getProperties()) {
                Property existingProperty = this.lookupProperty(list, levelProperty.getName());
                if (existingProperty == null) {
                    list.add(levelProperty);
                    continue;
                }
                if (existingProperty.getType() == levelProperty.getType()) continue;
                throw Util.newError("Property " + this.getName() + "." + levelProperty.getName() + " overrides a " + "property with the same name but different type");
            }
        }
        this.inheritedProperties = list.toArray(new RolapProperty[list.size()]);
        Dimension dim = hierarchy.getDimension();
        if (dim.getDimensionType() == DimensionType.TimeDimension) {
            if (!levelType.isTime() && !this.isAll()) {
                throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
            }
        } else if (dim.getDimensionType() != null && levelType.isTime()) {
            throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
        }
        this.hideMemberCondition = hideMemberCondition;
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return (RolapHierarchy)this.hierarchy;
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    private int loadApproxRowCount(String approxRowCount) {
        boolean notNullAndNumeric;
        boolean bl = notNullAndNumeric = approxRowCount != null && approxRowCount.matches("^\\d+$");
        if (notNullAndNumeric) {
            return Integer.parseInt(approxRowCount);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    String getTableName() {
        String tableName = null;
        MondrianDef.Expression expr = this.getKeyExp();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column mc = (MondrianDef.Column)expr;
            tableName = mc.getTableAlias();
        }
        return tableName;
    }

    public MondrianDef.Expression getKeyExp() {
        return this.keyExp;
    }

    MondrianDef.Expression getOrdinalExp() {
        return this.ordinalExp;
    }

    public MondrianDef.Expression getCaptionExp() {
        return this.captionExp;
    }

    public boolean hasCaptionColumn() {
        return this.captionExp != null;
    }

    final int getFlags() {
        return this.flags;
    }

    HideMemberCondition getHideMemberCondition() {
        return this.hideMemberCondition;
    }

    public final boolean isUnique() {
        return (this.flags & 4) != 0;
    }

    final Dialect.Datatype getDatatype() {
        return this.datatype;
    }

    final String getNullParentValue() {
        return this.nullParentValue;
    }

    public boolean isParentChild() {
        return this.parentExp != null;
    }

    MondrianDef.Expression getParentExp() {
        return this.parentExp;
    }

    public MondrianDef.Expression getNameExp() {
        return this.nameExp;
    }

    private Property lookupProperty(List<Property> list, String propertyName) {
        for (Property property : list) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, MondrianDef.Level xmlLevel) {
        this(hierarchy, xmlLevel.name, xmlLevel.caption, xmlLevel.description, depth, xmlLevel.getKeyExp(), xmlLevel.getNameExp(), xmlLevel.getCaptionExp(), xmlLevel.getOrdinalExp(), xmlLevel.getParentExp(), xmlLevel.nullParentValue, xmlLevel.closure, RolapLevel.createProperties(xmlLevel), xmlLevel.uniqueMembers != false ? 4 : 0, xmlLevel.getDatatype(), HideMemberCondition.valueOf(xmlLevel.hideMemberIf), LevelType.valueOf(xmlLevel.levelType), xmlLevel.approxRowCount, RolapHierarchy.createAnnotationMap(xmlLevel.annotations));
        if (!Util.isEmpty(xmlLevel.caption)) {
            this.setCaption(xmlLevel.caption);
        }
        if (!Util.isEmpty(xmlLevel.formatter)) {
            try {
                Class<?> clazz = Class.forName(xmlLevel.formatter);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                this.memberFormatter = (MemberFormatter)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw MondrianResource.instance().MemberFormatterLoadFailed.ex(xmlLevel.formatter, this.getUniqueName(), e);
            }
        }
    }

    private static RolapProperty[] createProperties(MondrianDef.Level xmlLevel) {
        ArrayList<RolapProperty> list = new ArrayList<RolapProperty>();
        MondrianDef.Expression nameExp = xmlLevel.getNameExp();
        if (nameExp != null) {
            list.add(new RolapProperty(Property.NAME.name, Property.Datatype.TYPE_STRING, nameExp, null, null, null, true));
        }
        for (int i = 0; i < xmlLevel.properties.length; ++i) {
            MondrianDef.Property property = xmlLevel.properties[i];
            list.add(new RolapProperty(property.name, RolapLevel.convertPropertyTypeNameToCode(property.type), xmlLevel.getPropertyExp(i), property.formatter, property.caption, xmlLevel.properties[i].dependsOnLevelValue, false));
        }
        return list.toArray(new RolapProperty[list.size()]);
    }

    private static Property.Datatype convertPropertyTypeNameToCode(String type) {
        if (type.equals("String")) {
            return Property.Datatype.TYPE_STRING;
        }
        if (type.equals("Numeric")) {
            return Property.Datatype.TYPE_NUMERIC;
        }
        if (type.equals("Boolean")) {
            return Property.Datatype.TYPE_BOOLEAN;
        }
        throw Util.newError("Unknown property type '" + type + "'");
    }

    private void checkColumn(MondrianDef.Column nameColumn) {
        RolapHierarchy rolapHierarchy = (RolapHierarchy)this.hierarchy;
        if (nameColumn.table == null) {
            MondrianDef.Relation table = rolapHierarchy.getUniqueTable();
            if (table == null) {
                throw Util.newError("must specify a table for level " + this.getUniqueName() + " because hierarchy has more than one table");
            }
            nameColumn.table = table.getAlias();
        } else if (!rolapHierarchy.tableExists(nameColumn.table)) {
            throw Util.newError("Table '" + nameColumn.table + "' not found");
        }
    }

    void init(MondrianDef.CubeDimension xmlDimension) {
        if (this.xmlClosure != null) {
            RolapDimension dimension = ((RolapHierarchy)this.hierarchy).createClosedPeerDimension(this, this.xmlClosure, xmlDimension);
            this.closedPeerLevel = (RolapLevel)dimension.getHierarchies()[0].getLevels()[1];
        }
    }

    @Override
    public final boolean isAll() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean areMembersUnique() {
        return this.depth == 0 || this.depth == 1 && this.hierarchy.hasAll();
    }

    public String getTableAlias() {
        return this.keyExp.getTableAlias();
    }

    public RolapProperty[] getProperties() {
        return this.properties;
    }

    @Override
    public Property[] getInheritedProperties() {
        return this.inheritedProperties;
    }

    @Override
    public int getApproxRowCount() {
        return this.approxRowCount;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment name) {
        return this.lookupChild(schemaReader, name, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment name, MatchType matchType) {
        List<Member> levelMembers = schemaReader.getLevelMembers((Level)this, true);
        if (levelMembers.size() > 0) {
            Member parent = levelMembers.get(0).getParentMember();
            return RolapUtil.findBestMemberMatch(levelMembers, (RolapMember)parent, this, name, matchType, false);
        }
        return null;
    }

    public boolean isSimple() {
        if (this.isTooRagged()) {
            return false;
        }
        if (this.isParentChild()) {
            return false;
        }
        return !this.isMeasure();
    }

    private boolean isTooRagged() {
        if (this.getDepth() == this.getHierarchy().getLevels().length - 1) {
            switch (this.getHideMemberCondition()) {
                case Never: 
                case IfBlankName: {
                    return false;
                }
            }
            return true;
        }
        return this.getHierarchy().isRagged();
    }

    boolean hasClosedPeer() {
        return this.closedPeerLevel != null;
    }

    public RolapLevel getClosedPeer() {
        return this.closedPeerLevel;
    }

    public static RolapLevel lookupLevel(RolapLevel[] levels, String levelName) {
        for (RolapLevel level : levels) {
            if (!level.getName().equals(levelName)) continue;
            return level;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HideMemberCondition {
        Never,
        IfBlankName,
        IfParentsName;

    }
}

