/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill;

import java.util.Comparator;
import net.sf.jasperreports.crosstabs.fill.BucketOrderer;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingData;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingServiceContext;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;

public class BucketExpressionOrderer
implements BucketOrderer {
    private final JRExpression orderByExpression;
    private final Comparator<Object> orderValueComparator;
    private BucketingData bucketingData;

    public BucketExpressionOrderer(JRExpression orderByExpression, Comparator<Object> orderValueComparator) {
        this.orderByExpression = orderByExpression;
        this.orderValueComparator = orderValueComparator;
    }

    @Override
    public void init(BucketingData bucketingData) {
        this.bucketingData = bucketingData;
    }

    @Override
    public Object getOrderValue(BucketingService.BucketMap bucketMap, BucketDefinition.Bucket bucketValue) throws JRException {
        MeasureDefinition.MeasureValue[] bucketTotals = this.bucketingData.getMeasureTotals(bucketMap, bucketValue);
        BucketingServiceContext serviceContext = this.bucketingData.getServiceContext();
        return serviceContext.evaluateMeasuresExpression(this.orderByExpression, bucketTotals);
    }

    @Override
    public int compareOrderValues(Object value1, Object value2) {
        return this.orderValueComparator.compare(value1, value2);
    }
}

