/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;

public class BlockColumnValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private int size;
    private ColumnValues[] blocks;

    public BlockColumnValues(List<ColumnValues> blocks) {
        ColumnValues[] blocksArray = new ColumnValues[blocks.size()];
        this.blocks = blocks.toArray(blocksArray);
        int totalSize = 0;
        for (ColumnValues values : this.blocks) {
            totalSize += values.size();
        }
        this.size = totalSize;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.blocks.length);
        for (int i = 0; i < this.blocks.length; ++i) {
            out.writeUnshared(this.blocks[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        int blockCount = in.readInt();
        this.blocks = new ColumnValues[blockCount];
        for (int i = 0; i < blockCount; ++i) {
            this.blocks[i] = (ColumnValues)in.readUnshared();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new ValuesIterator();
    }

    protected class ValuesIterator
    implements ColumnValuesIterator {
        private int blockIndex = -1;
        private ColumnValuesIterator blockIterator;

        @Override
        public void moveFirst() {
            this.blockIndex = -1;
            this.blockIterator = null;
        }

        @Override
        public boolean next() {
            while (true) {
                if (this.blockIterator != null) {
                    if (this.blockIterator.next()) {
                        return true;
                    }
                    this.blockIterator = null;
                }
                if (this.blockIndex + 1 >= BlockColumnValues.this.blocks.length) {
                    return false;
                }
                ++this.blockIndex;
                this.blockIterator = BlockColumnValues.this.blocks[this.blockIndex].iterator();
            }
        }

        @Override
        public Object get() {
            if (this.blockIterator == null) {
                throw new IllegalStateException();
            }
            return this.blockIterator.get();
        }
    }
}

