/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private List<Unmarshaller<AmazonServiceException, JSONObject>> unmarshallerList;

    public JsonErrorResponseHandler(List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers) {
        this.unmarshallerList = exceptionUnmarshallers;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JSONObject jsonErrorMessage;
        String streamContents = this.readStreamContents(response.getContent());
        try {
            String s = streamContents;
            if (s.length() == 0 || s.trim().length() == 0) {
                s = "{}";
            }
            jsonErrorMessage = new JSONObject(s);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to parse error response: '" + streamContents + "'", e);
        }
        AmazonServiceException ase = this.runErrorUnmarshallers(response, jsonErrorMessage);
        if (ase == null) {
            return null;
        }
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        if (response.getStatusCode() < 500) {
            ase.setErrorType(AmazonServiceException.ErrorType.Client);
        } else {
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
        }
        for (Map.Entry<String, String> headerEntry : response.getHeaders().entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("X-Amzn-RequestId")) continue;
            ase.setRequestId(headerEntry.getValue());
        }
        return ase;
    }

    protected AmazonServiceException runErrorUnmarshallers(HttpResponse errorResponse, JSONObject json) throws Exception {
        for (Unmarshaller<AmazonServiceException, JSONObject> unmarshaller : this.unmarshallerList) {
            AmazonServiceException ase = unmarshaller.unmarshall(json);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        return null;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private String readStreamContents(InputStream stream) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (Exception e) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AmazonClientException("Unable to read error response: " + e.getMessage(), e);
        }
    }
}

