/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.io.ExportOutput;
import com.jaspersoft.jasperserver.export.io.ExportOutputFactory;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import com.jaspersoft.jasperserver.export.io.PathProcessorFactory;
import com.jaspersoft.jasperserver.export.io.ZipFileOutput;
import java.util.Properties;

public class ZipFileOutputFactory
implements ExportOutputFactory {
    private String zipFileParameter;
    private int compressionLevel = -1;
    private PathProcessorFactory pathProcessorFactory;
    private String propertyPathProcessorId;

    @Override
    public boolean matches(Parameters parameters) {
        return parameters.hasParameter(this.zipFileParameter);
    }

    @Override
    public ExportOutput createOutput(Parameters parameters) {
        String zipFile = parameters.getParameterValue(this.getZipFileParameter());
        if (zipFile == null) {
            throw new JSException("jsexception.no.export.zip.file.specified");
        }
        String processorId = this.pathProcessorFactory.getDefaultOutputProcessor();
        PathProcessor processor = this.pathProcessorFactory.getProcessor(processorId);
        Properties properties = new Properties();
        properties.setProperty(this.propertyPathProcessorId, processorId);
        return new ZipFileOutput(zipFile, this.getCompressionLevel(), processor, properties);
    }

    public String getZipFileParameter() {
        return this.zipFileParameter;
    }

    public void setZipFileParameter(String exportFolderParameter) {
        this.zipFileParameter = exportFolderParameter;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public PathProcessorFactory getPathProcessorFactory() {
        return this.pathProcessorFactory;
    }

    public void setPathProcessorFactory(PathProcessorFactory pathProcessorFactory) {
        this.pathProcessorFactory = pathProcessorFactory;
    }

    public String getPropertyPathProcessorId() {
        return this.propertyPathProcessorId;
    }

    public void setPropertyPathProcessorId(String propertyPathProcessorId) {
        this.propertyPathProcessorId = propertyPathProcessorId;
    }
}

