/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;

public class JdbcDataSourceBean
extends ResourceBean {
    private String driverClass;
    private String url;
    private String username;
    private String password;
    private String timezone;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
        JdbcReportDataSource ds = (JdbcReportDataSource)res;
        this.setDriverClass(ds.getDriverClass());
        this.setConnectionUrl(ds.getConnectionUrl());
        this.setConnectionUsername(ds.getUsername());
        this.setConnectionPassword("ENC<" + importExportCipher.encode(ds.getPassword()) + ">");
        this.setTimezone(ds.getTimezone());
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        JdbcReportDataSource ds = (JdbcReportDataSource)res;
        ds.setDriverClass(this.getDriverClass());
        ds.setConnectionUrl(this.getConnectionUrl());
        ds.setUsername(this.getConnectionUsername());
        ds.setTimezone(this.getTimezone());
        String pwd = this.getConnectionPassword();
        ds.setPassword(pwd != null && pwd.startsWith("ENC<") && pwd.endsWith(">") ? importExportCipher.decode(pwd.replaceFirst("ENC<", "").replaceAll(">$", "")) : pwd);
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getConnectionUrl() {
        return this.url;
    }

    public void setConnectionUrl(String url) {
        this.url = url;
    }

    public String getConnectionUsername() {
        return this.username;
    }

    public void setConnectionUsername(String username) {
        this.username = username;
    }

    public String getConnectionPassword() {
        return this.password;
    }

    public void setConnectionPassword(String password) {
        this.password = password;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }
}

