/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling.beans;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import java.util.ArrayList;
import java.util.List;

public class ReportJobAlertBean {
    private long id;
    private int version;
    private byte recipient = ReportJobAlert.Recipient.OWNER_AND_ADMIN.getCode();
    private String[] toAddresses;
    private byte jobState = ReportJobAlert.JobState.FAIL_ONLY.getCode();
    private String messageText = null;
    private String messageTextWhenJobFails = null;
    private String subject = null;
    private boolean includingStackTrace = true;
    private boolean includingReportJobInfo = true;

    public void copyFrom(ReportJobAlert alert) {
        this.setId(alert.getId());
        this.setVersion(alert.getVersion());
        this.setRecipient(alert.getRecipient().getCode());
        this.setToAddresses(this.copyAddressesFrom(alert.getToAddresses()));
        this.setJobState(alert.getJobState().getCode());
        this.setMessageText(alert.getMessageText());
        this.setMessageTextWhenJobFails(alert.getMessageTextWhenJobFails());
        this.setSubject(alert.getSubject());
        this.setIncludingStackTrace(alert.isIncludingStackTrace());
        this.setIncludingReportJobInfo(alert.isIncludingReportJobInfo());
    }

    protected String[] copyAddressesFrom(List<String> addresses) {
        String[] addressesArray;
        if (addresses == null || addresses.isEmpty()) {
            addressesArray = null;
        } else {
            addressesArray = new String[addresses.size()];
            addressesArray = addresses.toArray(addressesArray);
        }
        return addressesArray;
    }

    public void copyTo(ReportJobAlert alert) {
        alert.setRecipient(ReportJobAlert.Recipient.fromCode((byte)this.getRecipient()));
        alert.setToAddresses(this.copyAddressesTo(this.getToAddresses()));
        alert.setJobState(ReportJobAlert.JobState.fromCode((byte)this.getJobState()));
        alert.setMessageText(this.getMessageText());
        alert.setMessageTextWhenJobFails(this.getMessageTextWhenJobFails());
        alert.setSubject(this.getSubject());
        alert.setIncludingStackTrace(this.isIncludingStackTrace());
        alert.setIncludingReportJobInfo(this.isIncludingReportJobInfo());
    }

    protected List copyAddressesTo(String[] addresses) {
        ArrayList<String> addressesList;
        if (addresses == null) {
            addressesList = null;
        } else {
            addressesList = new ArrayList<String>(addresses.length);
            for (int i = 0; i < addresses.length; ++i) {
                addressesList.add(addresses[i]);
            }
        }
        return addressesList;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte getRecipient() {
        return this.recipient;
    }

    public void setRecipient(byte recipient) {
        this.recipient = recipient;
    }

    public String[] getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(String[] toAddresses) {
        this.toAddresses = toAddresses;
    }

    public byte getJobState() {
        return this.jobState;
    }

    public void setJobState(byte jobState) {
        this.jobState = jobState;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public String getMessageTextWhenJobFails() {
        return this.messageTextWhenJobFails;
    }

    public void setMessageTextWhenJobFails(String messageTextWhenJobFails) {
        this.messageTextWhenJobFails = messageTextWhenJobFails;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean isIncludingStackTrace() {
        return this.includingStackTrace;
    }

    public void setIncludingStackTrace(boolean includingStackTrace) {
        this.includingStackTrace = includingStackTrace;
    }

    public boolean isIncludingReportJobInfo() {
        return this.includingReportJobInfo;
    }

    public void setIncludingReportJobInfo(boolean includingReportJobInfo) {
        this.includingReportJobInfo = includingReportJobInfo;
    }
}

