/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.model;

import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

class FlowRelativeResourceLoader
implements ResourceLoader {
    private Resource flowResource;

    public FlowRelativeResourceLoader(Resource resource) {
        this.flowResource = resource;
    }

    public ClassLoader getClassLoader() {
        return this.flowResource.getClass().getClassLoader();
    }

    public Resource getResource(String location) {
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        return this.createFlowRelativeResource(location);
    }

    private Resource createFlowRelativeResource(String location) {
        try {
            return this.flowResource.createRelative(location);
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Unable to access a flow relative resource at location '" + location + "'");
            iae.initCause(e);
            throw iae;
        }
    }
}

