/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.spel;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class BeanFactoryPropertyAccessor
implements PropertyAccessor {
    private static final BeanFactory EMPTY_BEAN_FACTORY = new StaticListableBeanFactory();

    public Class[] getSpecificTargetClasses() {
        return null;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return this.getBeanFactory().containsBean(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        return new TypedValue(this.getBeanFactory().getBean(name));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException("Beans in a BeanFactory are read-only");
    }

    protected BeanFactory getBeanFactory() {
        ApplicationContext beanFactory;
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        if (requestContext != null && (beanFactory = requestContext.getActiveFlow().getApplicationContext()) != null) {
            return beanFactory;
        }
        return EMPTY_BEAN_FACTORY;
    }
}

