/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.client.plan.Annotation;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.xml.QueryUtil;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.PredicateCollectorVisitor;
import org.teiid.query.sql.visitor.StaticSymbolMappingVisitor;

public class XMLQueryPlanner {
    static void prePlanQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            @Override
            public void visit(MappingBaseNode baseNode) {
                try {
                    List<String> stagingTables = baseNode.getStagingTables();
                    for (String tableName : stagingTables) {
                        XMLQueryPlanner.planStagingTable(tableName, planEnv);
                    }
                    if (baseNode instanceof MappingSourceNode) {
                        XMLQueryPlanner.planQueries((MappingSourceNode)baseNode, planEnv);
                    }
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        XMLQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    static void optimizeQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            @Override
            public void visit(MappingSourceNode sourceNode) {
                try {
                    ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
                    Query command = (Query)rsInfo.getCommand();
                    XMLQueryPlanner.prepareQuery(sourceNode, planEnv, command);
                    Command cmd = QueryUtil.rewriteQuery(command, planEnv.getGlobalMetadata(), planEnv.context);
                    ProcessorPlan queryPlan = XMLQueryPlanner.optimizePlan(cmd, planEnv);
                    rsInfo.setPlan(queryPlan);
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        XMLQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            Navigator walker = new Navigator(true, visitor);
            doc.acceptVisitor(walker);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)((Object)e.getCause());
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
    }

    static void planQueries(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
        Query rsQuery = (Query)rsInfo.getCommand();
        rsQuery.setOrderBy(rsInfo.getOrderBy());
        Criteria crit = rsInfo.getCriteria();
        try {
            if (crit != null) {
                XMLQueryPlanner.planQueryWithCriteria(sourceNode, planEnv);
            }
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30294, (Throwable)((Object)e));
        }
        if (rsInfo.getUserRowLimit() != -1) {
            int limit = rsInfo.getUserRowLimit();
            if (rsInfo.exceptionOnRowlimit()) {
                ++limit;
            }
            rsQuery.setLimit(new Limit(null, new Constant(limit)));
        }
        rsInfo.setCommand(rsQuery);
    }

    static ProcessorPlan optimizePlan(Command query, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        TempMetadataAdapter metadata = planEnv.getGlobalMetadata();
        ProcessorPlan plan = QueryOptimizer.optimizePlan(query, metadata, planEnv.idGenerator, planEnv.capFinder, planEnv.analysisRecord, planEnv.context);
        return plan;
    }

    static void prepareQuery(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv, QueryCommand rsQuery) throws TeiidComponentException, QueryResolverException {
        Collection<GroupSymbol> externalGroups = XMLQueryPlanner.getExternalGroups(sourceNode);
        rsQuery.setExternalGroupContexts(new GroupContext(null, externalGroups));
        QueryResolver.resolveCommand(rsQuery, planEnv.getGlobalMetadata());
    }

    private static Collection<GroupSymbol> getExternalGroups(MappingSourceNode sourceNode) {
        HashSet<GroupSymbol> externalGroups = new HashSet<GroupSymbol>();
        for (MappingSourceNode parentSource = sourceNode.getParentSourceNode(); parentSource != null; parentSource = parentSource.getParentSourceNode()) {
            externalGroups.add(new GroupSymbol(parentSource.getActualResultSetName()));
        }
        return externalGroups;
    }

    private static boolean getResultSets(MappingSourceNode contextNode, Set<MappingSourceNode> criteriaSourceNodes, LinkedHashSet<MappingSourceNode> allResultSets) {
        boolean singleParentage = true;
        for (MappingSourceNode node : criteriaSourceNodes) {
            LinkedList<MappingSourceNode> rsStack = XMLQueryPlanner.getResultSetStack(contextNode, node);
            if (allResultSets.containsAll(rsStack)) continue;
            if (!rsStack.containsAll(allResultSets)) {
                singleParentage = false;
            }
            allResultSets.addAll(rsStack);
        }
        return singleParentage;
    }

    private static LinkedList<MappingSourceNode> getResultSetStack(MappingSourceNode contextNode, MappingBaseNode node) {
        LinkedList<MappingSourceNode> rsStack = new LinkedList<MappingSourceNode>();
        while (node != null && node != contextNode) {
            if (node instanceof MappingSourceNode) {
                rsStack.add(0, (MappingSourceNode)node);
            }
            node = node.getParentNode();
        }
        return rsStack;
    }

    private static void planQueryWithCriteria(MappingSourceNode contextNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, TeiidComponentException, QueryMetadataException, QueryResolverException {
        HashMap symbolMap = new HashMap();
        ResultSetInfo rsInfo = contextNode.getResultSetInfo();
        LinkedHashSet<MappingSourceNode> resultSets = new LinkedHashSet<MappingSourceNode>();
        boolean singleParentage = XMLQueryPlanner.getResultSets(contextNode, rsInfo.getCriteriaResultSets(), resultSets);
        Query contextQuery = null;
        if (rsInfo.isCriteriaRaised()) {
            contextQuery = (Query)QueryUtil.getQueryFromQueryNode(rsInfo.getResultSetName(), planEnv);
            String inlineViewName = planEnv.getAliasName(rsInfo.getResultSetName());
            XMLQueryPlanner.updateSymbolMap(symbolMap, rsInfo.getResultSetName(), inlineViewName, planEnv.getGlobalMetadata());
        } else {
            contextQuery = (Query)rsInfo.getCommand();
        }
        Query currentQuery = contextQuery;
        for (MappingSourceNode rsNode : resultSets) {
            ResultSetInfo childRsInfo = rsNode.getResultSetInfo();
            QueryNode planNode = QueryUtil.getQueryNode(childRsInfo.getResultSetName(), planEnv.getGlobalMetadata());
            Command command = QueryUtil.getQuery(childRsInfo.getResultSetName(), planNode, planEnv);
            String inlineViewName = planEnv.getAliasName(childRsInfo.getResultSetName());
            XMLQueryPlanner.updateSymbolMap(symbolMap, childRsInfo.getResultSetName(), inlineViewName, planEnv.getGlobalMetadata());
            if (!rsInfo.isCritNullDependent() && childRsInfo.hasInputSet() && childRsInfo.isCriteriaRaised()) {
                Query transformationQuery = (Query)command;
                SubqueryFromClause sfc = (SubqueryFromClause)transformationQuery.getFrom().getClauses().get(0);
                Criteria joinCriteria = ((Query)childRsInfo.getCommand()).getCriteria();
                joinCriteria = (Criteria)joinCriteria.clone();
                FromClause clause = currentQuery.getFrom().getClauses().remove(0);
                JoinPredicate join = new JoinPredicate(clause, (FromClause)sfc, JoinType.JOIN_LEFT_OUTER, Criteria.separateCriteriaByAnd(joinCriteria));
                currentQuery.getFrom().addClause(join);
                currentQuery.getSelect().setDistinct(true);
                continue;
            }
            if (!singleParentage) {
                throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30295, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30295, new Object[]{rsInfo.getCriteria()}));
            }
            Query subQuery = QueryUtil.wrapQuery(new SubqueryFromClause(inlineViewName, command), inlineViewName);
            currentQuery.setCriteria(Criteria.combineCriteria(currentQuery.getCriteria(), new ExistsCriteria(subQuery)));
            currentQuery = subQuery;
        }
        Criteria userCrit = (Criteria)rsInfo.getCriteria().clone();
        currentQuery.setCriteria(Criteria.combineCriteria(currentQuery.getCriteria(), userCrit));
        StaticSymbolMappingVisitor.mapSymbols(contextQuery, symbolMap);
        if (rsInfo.isCriteriaRaised()) {
            XMLQueryPlanner.prepareQuery(contextNode, planEnv, contextQuery);
            QueryUtil.rewriteQuery(contextQuery, planEnv.getGlobalMetadata(), planEnv.context);
            List<Reference> bindings = QueryUtil.getReferences(contextQuery);
            QueryNode modifiedNode = new QueryNode(null);
            modifiedNode.setCommand(contextQuery);
            for (Reference ref : bindings) {
                modifiedNode.addBinding(ref.getExpression().toString());
            }
            GroupSymbol groupSymbol = QueryUtil.createResolvedGroup(rsInfo.getResultSetName(), (QueryMetadataInterface)planEnv.getGlobalMetadata());
            planEnv.addQueryNodeToMetadata(groupSymbol.getMetadataID(), modifiedNode);
        }
        for (Criteria crit : PredicateCollectorVisitor.getPredicates(userCrit)) {
            XMLQueryPlanner.handleXmlSubqueries(planEnv, crit);
        }
    }

    private static void handleXmlSubqueries(XMLPlannerEnvironment planEnv, Criteria userCrit) throws QueryPlannerException {
        if (!(userCrit instanceof SubqueryContainer)) {
            return;
        }
        SubqueryContainer subquery = (SubqueryContainer)((Object)userCrit);
        if (!(subquery.getCommand() instanceof Query)) {
            return;
        }
        Query q = (Query)subquery.getCommand();
        if (q.getFrom() == null || q.getCriteria() == null) {
            return;
        }
        List<GroupSymbol> groups = q.getFrom().getGroups();
        if (groups.size() != 1) {
            return;
        }
        GroupSymbol gs = groups.get(0);
        LinkedHashSet<GroupSymbol> allGroups = new LinkedHashSet<GroupSymbol>();
        allGroups.add(gs);
        if (planEnv.getGlobalMetadata().getMetadataStore().getTempGroupID(gs.getNonCorrelationName()) == null) {
            return;
        }
        MappingSourceNode parentMsn = XMLQueryPlanner.findMappingSourceNode(planEnv, gs);
        for (Criteria crit : PredicateCollectorVisitor.getPredicates(q.getCriteria())) {
            Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements((LanguageObject)crit, false);
            LinkedList<GroupSymbol> critGroups = new LinkedList<GroupSymbol>();
            for (ElementSymbol elementSymbol : elems) {
                if (elementSymbol.isExternalReference()) continue;
                critGroups.add(elementSymbol.getGroupSymbol());
            }
            for (GroupSymbol groupSymbol : critGroups) {
                if (allGroups.contains(groupSymbol)) continue;
                for (MappingSourceNode childMsn = XMLQueryPlanner.findMappingSourceNode(planEnv, groupSymbol); childMsn != parentMsn; childMsn = childMsn.getParentSourceNode()) {
                    if (childMsn == null) {
                        throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30296, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30296, new Object[]{crit, parentMsn}));
                    }
                    if (!childMsn.getResultSetInfo().isCriteriaRaised()) {
                        throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30297, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30297, new Object[]{crit, childMsn}));
                    }
                    Query parentQuery = (Query)childMsn.getResultSetInfo().getCommand();
                    if (parentQuery.getCriteria() == null || !allGroups.addAll(GroupsUsedByElementsVisitor.getGroups(parentQuery.getCriteria()))) continue;
                    q.setCriteria(Criteria.combineCriteria(q.getCriteria(), (Criteria)parentQuery.getCriteria().clone()));
                }
            }
            q.getFrom().getClauses().clear();
            for (GroupSymbol groupSymbol : allGroups) {
                q.getFrom().addClause(new UnaryFromClause(groupSymbol));
            }
            XMLQueryPlanner.handleXmlSubqueries(planEnv, crit);
        }
    }

    private static MappingSourceNode findMappingSourceNode(XMLPlannerEnvironment planEnv, GroupSymbol gs) {
        MappingSourceNodeFinder finder = new MappingSourceNodeFinder(gs);
        planEnv.mappingDoc.acceptVisitor(new Navigator(true, finder));
        return finder.msn;
    }

    static void updateSymbolMap(Map symbolMap, String oldGroup, String newGroup, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        GroupSymbol oldGroupSymbol = new GroupSymbol(oldGroup);
        ResolverUtil.resolveGroup(oldGroupSymbol, metadata);
        HashSet<ElementSymbol> projectedElements = new HashSet<ElementSymbol>(ResolverUtil.resolveElementsInGroup(oldGroupSymbol, metadata));
        symbolMap.putAll(QueryUtil.createSymbolMap(oldGroupSymbol, newGroup, projectedElements));
    }

    static void planStagingTable(String groupName, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException {
        ResultSetInfo rsInfo = planEnv.getStagingTableResultsInfo(groupName);
        UnaryFromClause fromClause = new UnaryFromClause(new GroupSymbol(groupName));
        Query query = QueryUtil.wrapQuery(fromClause, groupName);
        if (rsInfo.getCriteria() != null) {
            query.setCriteria(rsInfo.getCriteria());
        }
        XMLQueryPlanner.planStagaingQuery(false, groupName, groupName, query, planEnv);
    }

    static boolean planStagaingQuery(boolean implicit, String srcGroupName, String stageGroupName, Query query, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException {
        TempMetadataStore tempMetadata;
        GroupSymbol srcGroup = QueryUtil.createResolvedGroup(srcGroupName, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        String intoGroupName = XMLQueryPlanner.getTempTableName(stageGroupName);
        GroupSymbol intoGroupSymbol = new GroupSymbol(intoGroupName);
        query.setInto(new Into(intoGroupSymbol));
        QueryResolver.resolveCommand(query, planEnv.getGlobalMetadata());
        Command cmd = QueryUtil.rewriteQuery(query, planEnv.getGlobalMetadata(), planEnv.context);
        ProcessorPlan plan = null;
        boolean debug = planEnv.analysisRecord.recordAnnotations();
        try {
            plan = XMLQueryPlanner.optimizePlan(cmd, planEnv);
        }
        catch (QueryPlannerException e) {
            if (implicit) {
                if (debug) {
                    planEnv.analysisRecord.addAnnotation("XML Planning", "Planning failded for staging otable " + srcGroupName + " due to " + e.getMessage(), "Implicit staging table will not be used", Annotation.Priority.LOW);
                }
                return false;
            }
            throw e;
        }
        if (debug) {
            planEnv.analysisRecord.addAnnotation("XML Planning", "Planning succeeded for staging of " + srcGroupName, (implicit ? "Implicit " : "") + "staging table will be used", Annotation.Priority.MEDIUM);
        }
        int cardinality = -1;
        if (plan instanceof RelationalPlan) {
            Number planCardinality;
            RelationalPlan relationalPlan = (RelationalPlan)plan;
            RelationalNode root = relationalPlan.getRootNode();
            if (root.getChildren()[0] != null) {
                root = root.getChildren()[0];
            }
            if ((planCardinality = root.getEstimateNodeCardinality()) == null || planCardinality.floatValue() == -1.0f) {
                if (implicit && query.getCriteria() == null) {
                    return false;
                }
            } else if (planCardinality.floatValue() < (float)planEnv.context.getProcessorBatchSize()) {
                cardinality = planCardinality.intValue();
            } else if (implicit) {
                return false;
            }
        }
        if ((tempMetadata = query.getTemporaryMetadata()) != null && !tempMetadata.getData().isEmpty()) {
            planEnv.addToGlobalMetadata(tempMetadata.getData());
        }
        ResultSetInfo rsInfo = planEnv.getStagingTableResultsInfo(stageGroupName);
        rsInfo.setCommand(cmd);
        rsInfo.setPlan(plan);
        TempMetadataID intoGroupID = (TempMetadataID)intoGroupSymbol.getMetadataID();
        intoGroupID.setCardinality(cardinality);
        planEnv.addStagingTable(srcGroup.getMetadataID(), intoGroupID);
        String unloadName = planEnv.unLoadResultName(stageGroupName);
        ResultSetInfo rsUnloadInfo = planEnv.getStagingTableResultsInfo(unloadName);
        Command command = XMLQueryPlanner.wrapStagingTableUnloadQuery(intoGroupSymbol);
        QueryResolver.resolveCommand(command, planEnv.getGlobalMetadata());
        command = QueryUtil.rewriteQuery(command, planEnv.getGlobalMetadata(), planEnv.context);
        plan = XMLQueryPlanner.optimizePlan(command, planEnv);
        rsUnloadInfo.setCommand(command);
        rsUnloadInfo.setPlan(plan);
        return true;
    }

    static String getTempTableName(String stageGroupName) {
        String intoGroupName = "#" + stageGroupName.replace('.', '_');
        return intoGroupName;
    }

    private static Command wrapStagingTableUnloadQuery(GroupSymbol intoGroupSymbol) {
        Drop drop = new Drop();
        drop.setTable(intoGroupSymbol);
        return drop;
    }

    private static final class MappingSourceNodeFinder
    extends MappingVisitor {
        private final GroupSymbol gs;
        MappingSourceNode msn;

        private MappingSourceNodeFinder(GroupSymbol gs) {
            this.gs = gs;
        }

        @Override
        public void visit(MappingSourceNode element) {
            if (element.getAliasResultName() == null && element.getResultSetInfo().getResultSetName().equalsIgnoreCase(this.gs.getNonCorrelationName())) {
                this.msn = element;
                this.setAbort(true);
            }
        }
    }
}

