/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;

public class Query
extends QueryCommand {
    private Select select;
    private From from;
    private Criteria criteria;
    private GroupBy groupBy;
    private Criteria having;
    private boolean isXML;
    private Into into;
    private List<Expression> selectList;

    public Query() {
    }

    public Query(Select select, From from, Criteria criteria, OrderBy orderBy, Option option) {
        this.setSelect(select);
        this.setFrom(from);
        this.setCriteria(criteria);
        this.setOrderBy(orderBy);
        this.setOption(option);
    }

    public Query(Select select, From from, Criteria criteria, GroupBy groupBy, Criteria having, OrderBy orderBy, Option option) {
        this.setSelect(select);
        this.setFrom(from);
        this.setCriteria(criteria);
        this.setGroupBy(groupBy);
        this.setHaving(having);
        this.setOrderBy(orderBy);
        this.setOption(option);
    }

    @Override
    public int getType() {
        return 1;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean getIsXML() {
        return this.isXML;
    }

    public void setIsXML(boolean isXML) {
        this.isXML = isXML;
    }

    public From getFrom() {
        return this.from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public void clearCriteria() {
        this.criteria = null;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public Criteria getHaving() {
        return this.having;
    }

    public void setHaving(Criteria having) {
        this.having = having;
    }

    public Into getInto() {
        return this.into;
    }

    public void setInto(Into into) {
        this.into = into;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<Expression> getProjectedSymbols() {
        if (!this.getIsXML()) {
            if (this.getSelect() != null) {
                if (this.getInto() != null) {
                    return Command.getUpdateCommandSymbol();
                }
                return this.getSelect().getProjectedSymbols();
            }
            return Collections.emptyList();
        }
        if (this.selectList == null) {
            this.selectList = new ArrayList<Expression>(1);
            ElementSymbol xmlElement = new ElementSymbol("xml");
            xmlElement.setType(DataTypeManager.DefaultDataClasses.XML);
            this.selectList.add(xmlElement);
        }
        return this.selectList;
    }

    @Override
    public Object clone() {
        Query copy = new Query();
        if (this.select != null) {
            copy.setSelect(this.select.clone());
        }
        if (this.from != null) {
            copy.setFrom((From)this.from.clone());
        }
        if (this.criteria != null) {
            copy.setCriteria((Criteria)this.criteria.clone());
        }
        if (this.groupBy != null) {
            copy.setGroupBy((GroupBy)this.groupBy.clone());
        }
        if (this.having != null) {
            copy.setHaving((Criteria)this.having.clone());
        }
        if (this.getOrderBy() != null) {
            copy.setOrderBy(this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            copy.setLimit(this.getLimit().clone());
        }
        copy.setWith(LanguageObject.Util.deepClone(this.getWith(), WithQueryCommand.class));
        copy.setIsXML(this.getIsXML());
        if (this.selectList != null) {
            copy.selectList = LanguageObject.Util.deepClone(this.selectList, Expression.class);
        }
        if (this.into != null) {
            copy.into = (Into)this.into.clone();
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        return EquivalenceUtil.areEqual((Object)this.getSelect(), (Object)other.getSelect()) && EquivalenceUtil.areEqual((Object)this.getFrom(), (Object)other.getFrom()) && EquivalenceUtil.areEqual((Object)this.getCriteria(), (Object)other.getCriteria()) && EquivalenceUtil.areEqual((Object)this.getGroupBy(), (Object)other.getGroupBy()) && EquivalenceUtil.areEqual((Object)this.getHaving(), (Object)other.getHaving()) && EquivalenceUtil.areEqual((Object)this.getOrderBy(), (Object)other.getOrderBy()) && EquivalenceUtil.areEqual((Object)this.getLimit(), (Object)other.getLimit()) && EquivalenceUtil.areEqual(this.getWith(), other.getWith()) && this.getIsXML() == other.getIsXML() && this.sameOptionAndHint(other);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.select});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.criteria});
        return myHash;
    }

    @Override
    public boolean areResultsCachable() {
        if (this.getInto() != null) {
            return false;
        }
        if (this.isXML) {
            return true;
        }
        List<Expression> projectedSymbols = this.getProjectedSymbols();
        return Query.areColumnsCachable(projectedSymbols);
    }

    public static boolean areColumnsCachable(Collection<? extends Expression> projectedSymbols) {
        return true;
    }

    @Override
    public Query getProjectedQuery() {
        return this;
    }

    @Override
    public boolean returnsResultSet() {
        return this.into == null;
    }

    public boolean hasAggregates() {
        return this.getGroupBy() != null || this.getHaving() != null || !AggregateSymbolCollectorVisitor.getAggregates(this.getSelect(), false).isEmpty();
    }
}

