/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TranslatorOperationHandler;

class GetTranslator
extends TranslatorOperationHandler {
    protected GetTranslator() {
        super("get-translator");
    }

    @Override
    protected void executeOperation(OperationContext context, TranslatorRepository repo, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("translator-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("translator-name.missing")));
        }
        ModelNode result = context.getResult();
        String translatorName = operation.get("translator-name").asString();
        VDBTranslatorMetaData translator = repo.getTranslatorMetaData(translatorName);
        VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE.wrap(translator, result);
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "translator-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "translator-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "translator-name", "description"}).set(this.getParameterDescription(bundle, "translator-name"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.OBJECT);
        VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

