/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;

abstract class TeiidOperationHandler
extends BaseOperationHandler<DQPCore> {
    List<TransportService> transports = new ArrayList<TransportService>();
    protected VDBRepository vdbRepo;
    protected DQPCore engine;

    protected TeiidOperationHandler(String operationName) {
        super(operationName);
    }

    @Override
    protected DQPCore getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc;
        this.transports.clear();
        this.vdbRepo = null;
        this.engine = null;
        List services = context.getServiceRegistry(false).getServiceNames();
        for (ServiceName name : services) {
            ServiceController transport;
            if (!TeiidServiceNames.TRANSPORT_BASE.isParentOf(name) || (transport = context.getServiceRegistry(false).getService(name)) == null) continue;
            this.transports.add((TransportService)TransportService.class.cast(transport.getValue()));
        }
        ServiceController repo = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        if (repo != null) {
            this.vdbRepo = (VDBRepository)VDBRepository.class.cast(repo.getValue());
        }
        if ((sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.ENGINE)) != null) {
            this.engine = (DQPCore)DQPCore.class.cast(sc.getValue());
        }
        return this.engine;
    }
}

