/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;

class TransportRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    TransportRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceName serviceName;
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String transportName = pathAddress.getLastElement().getValue();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController controller = serviceRegistry.getService(serviceName = TeiidServiceNames.transportServiceName(transportName));
        if (controller != null) {
            context.removeService(serviceName);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("remove");
        operation.get("description").set(bundle.getString("remove.describe"));
        return operation;
    }
}

