/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;

abstract class VDBOperations
extends BaseOperationHandler<RuntimeVDB> {
    public VDBOperations(String operationName) {
        super(operationName);
    }

    @Override
    public RuntimeVDB getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        int vdbVersion;
        if (!operation.hasDefined("vdb-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-name.missing")));
        }
        if (!operation.hasDefined("vdb-version")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-version.missing")));
        }
        String vdbName = operation.get("vdb-name").asString();
        if (!this.isValidVDB(context, vdbName, vdbVersion = operation.get("vdb-version").asInt())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion})));
        }
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.vdbServiceName(vdbName, vdbVersion));
        return (RuntimeVDB)RuntimeVDB.class.cast(sc.getValue());
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-name", "description"}).set(this.getParameterDescription(bundle, "vdb-name"));
        operationNode.get(new String[]{"request-properties", "vdb-version", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-version", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-version", "description"}).set(this.getParameterDescription(bundle, "vdb-version"));
    }
}

