/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TopologyAwareConsistentHash
extends AbstractWheelConsistentHash {
    private static final Log LOG = LogFactory.getLog(DefaultConsistentHash.class);
    private SortedSet<Integer> siteIdChangeIndexes = new TreeSet<Integer>();
    private SortedSet<Integer> rackIdChangeIndexes = new TreeSet<Integer>();
    private SortedSet<Integer> machineIdChangeIndexes = new TreeSet<Integer>();

    public TopologyAwareConsistentHash() {
    }

    public TopologyAwareConsistentHash(Hash hash) {
        this.setHashFunction(hash);
    }

    @Override
    public void setCaches(Set<Address> newCaches) {
        super.setCaches(newCaches);
        this.siteIdChangeIndexes.clear();
        this.rackIdChangeIndexes.clear();
        this.machineIdChangeIndexes.clear();
        TopologyAwareAddress lastSiteAddr = (TopologyAwareAddress)this.positionValues[this.positionValues.length - 1];
        TopologyAwareAddress lastRackAddr = (TopologyAwareAddress)this.positionValues[this.positionValues.length - 1];
        TopologyAwareAddress lastMachineAddr = (TopologyAwareAddress)this.positionValues[this.positionValues.length - 1];
        for (int i = 0; i < this.positionKeys.length; ++i) {
            TopologyAwareAddress a = (TopologyAwareAddress)this.positionValues[i];
            if (!lastSiteAddr.isSameSite(a)) {
                this.siteIdChangeIndexes.add(i);
                lastSiteAddr = a;
            }
            if (!lastRackAddr.isSameRack(a)) {
                this.rackIdChangeIndexes.add(i);
                lastRackAddr = a;
            }
            if (lastMachineAddr.isSameMachine(a)) continue;
            this.machineIdChangeIndexes.add(i);
            lastMachineAddr = a;
        }
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        return this.locateInternal(key, replCount, null);
    }

    @Override
    public boolean isKeyLocalToAddress(Address target, Object key, int replCount) {
        return this.locateInternal(key, replCount, target).contains(target);
    }

    private List<Address> locateInternal(Object key, int replCount, Address target) {
        int actualReplCount = Math.min(replCount, this.caches.size());
        int keyNormalizedHash = this.getNormalizedHash(this.getGrouping(key));
        int firstOwnerIndex = this.getPositionIndex(keyNormalizedHash);
        Address firstOwner = this.positionValues[firstOwnerIndex];
        ArrayList<Address> owners = new ArrayList<Address>(actualReplCount);
        owners.add(firstOwner);
        if (owners.size() >= actualReplCount) {
            return owners;
        }
        if (this.locateOwnersForLevel(firstOwnerIndex, actualReplCount, Level.SITE, this.siteIdChangeIndexes, target, owners)) {
            return owners;
        }
        if (this.locateOwnersForLevel(firstOwnerIndex, actualReplCount, Level.RACK, this.rackIdChangeIndexes, target, owners)) {
            return owners;
        }
        if (this.locateOwnersForLevel(firstOwnerIndex, actualReplCount, Level.MACHINE, this.machineIdChangeIndexes, target, owners)) {
            return owners;
        }
        Iterator<Address> it = this.getPositionsIterator(keyNormalizedHash);
        while (it.hasNext()) {
            TopologyAwareAddress address = (TopologyAwareAddress)it.next();
            if (!this.addOwner(owners, address, replCount, target, Level.NONE)) continue;
            return owners;
        }
        return owners;
    }

    private boolean locateOwnersForLevel(int firstOwnerIndex, int replCount, Level level, SortedSet<Integer> levelIdChangeIndexes, Address target, List<Address> owners) {
        TopologyAwareAddress address;
        for (Integer addrIndex : levelIdChangeIndexes.tailSet(firstOwnerIndex)) {
            address = (TopologyAwareAddress)this.positionValues[addrIndex];
            if (!this.addOwner(owners, address, replCount, target, level)) continue;
            return true;
        }
        for (Integer addrIndex : levelIdChangeIndexes.headSet(firstOwnerIndex)) {
            address = (TopologyAwareAddress)this.positionValues[addrIndex];
            if (!this.addOwner(owners, address, replCount, target, level)) continue;
            return true;
        }
        return false;
    }

    private boolean addOwner(List<Address> owners, TopologyAwareAddress address, int replCount, Address target, Level level) {
        boolean alreadyAdded = false;
        for (Address owner : owners) {
            switch (level) {
                case SITE: {
                    alreadyAdded = ((TopologyAwareAddress)owner).isSameSite(address);
                    break;
                }
                case RACK: {
                    alreadyAdded = ((TopologyAwareAddress)owner).isSameRack(address);
                    break;
                }
                case MACHINE: {
                    alreadyAdded = ((TopologyAwareAddress)owner).isSameMachine(address);
                    break;
                }
                case NONE: {
                    boolean bl = alreadyAdded = owner == address;
                }
            }
            if (!alreadyAdded) continue;
            break;
        }
        if (!alreadyAdded) {
            owners.add(address);
            if (owners.size() >= replCount || address == target) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    public static class Externalizer
    extends AbstractWheelConsistentHash.Externalizer<TopologyAwareConsistentHash> {
        @Override
        protected TopologyAwareConsistentHash instance() {
            return new TopologyAwareConsistentHash();
        }

        @Override
        public Integer getId() {
            return 61;
        }

        @Override
        public Set<Class<? extends TopologyAwareConsistentHash>> getTypeClasses() {
            return Util.asSet(TopologyAwareConsistentHash.class);
        }
    }

    private static enum Level {
        SITE,
        RACK,
        MACHINE,
        NONE;

    }
}

