/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet;

import java.io.IOException;
import java.util.Set;
import org.mariadb.jdbc.internal.common.ServerStatus;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.mysql.MySQLServerCapabilities;

public class MySQLGreetingReadPacket {
    private String serverVersion;
    private final byte protocolVersion;
    private final long serverThreadID;
    private final Set<MySQLServerCapabilities> serverCapabilities;
    private final byte serverLanguage;
    private final Set<ServerStatus> serverStatus;
    private final byte[] seed;
    static final String MARIADB_RPL_HACK_PREFIX = "5.5.5-";

    public MySQLGreetingReadPacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        this.protocolVersion = reader.readByte();
        this.serverVersion = reader.readString("ASCII");
        this.serverThreadID = reader.readInt();
        byte[] seed1 = reader.readRawBytes(8);
        reader.skipByte();
        this.serverCapabilities = MySQLServerCapabilities.getServerCapabilitiesSet(reader.readShort());
        this.serverLanguage = reader.readByte();
        this.serverStatus = ServerStatus.getServerStatusSet(reader.readShort());
        reader.skipBytes(13);
        byte[] seed2 = reader.readRawBytes(12);
        this.seed = Utils.copyWithLength(seed1, seed1.length + seed2.length);
        System.arraycopy(seed2, 0, this.seed, seed1.length, seed2.length);
        reader.readByte();
        if (this.serverCapabilities.contains((Object)MySQLServerCapabilities.PLUGIN_AUTH) && this.serverVersion.startsWith(MARIADB_RPL_HACK_PREFIX)) {
            this.serverVersion = this.serverVersion.substring(MARIADB_RPL_HACK_PREFIX.length());
        }
    }

    public String toString() {
        return this.protocolVersion + ":" + this.serverVersion + ":" + this.serverThreadID + ":" + new String(this.seed) + ":" + this.serverCapabilities + ":" + this.serverLanguage + ":" + this.serverStatus;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getServerThreadID() {
        return this.serverThreadID;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public Set<MySQLServerCapabilities> getServerCapabilities() {
        return this.serverCapabilities;
    }

    public byte getServerLanguage() {
        return this.serverLanguage;
    }

    public Set<ServerStatus> getServerStatus() {
        return this.serverStatus;
    }
}

