/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util;

import java.io.UnsupportedEncodingException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Base64Coder {
    private static final Logger logger = LogManager.getLogger(Base64Coder.class);
    private static final String BASE64_CODE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final String BASE64_CODE_PADDING = "===";
    public static final String UNICODE_CHARSET = "UTF-16";

    public static String decode16BitBase64(String b64Str) {
        try {
            String decodedBase64 = "";
            int c = 0;
            int b = 0;
            while (c < b64Str.length()) {
                int h1 = BASE64_CODE.indexOf(b64Str.charAt(c));
                int h2 = BASE64_CODE.indexOf(b64Str.charAt(c + 1));
                int h3 = BASE64_CODE.indexOf(b64Str.charAt(c + 2));
                int h4 = BASE64_CODE.indexOf(b64Str.charAt(c + 3));
                int h5 = BASE64_CODE.indexOf(b64Str.charAt(c + 4));
                int d6 = BASE64_CODE.indexOf(b64Str.charAt(c + 5));
                int bits = h1 << 26 | h2 << 20 | h3 << 14 | h4 << 8 | h5 << 2 | d6 & 3;
                byte o1 = (byte)(bits >>> 24 & 0xFF);
                byte o2 = (byte)(bits >>> 16 & 0xFF);
                byte o3 = (byte)(bits >>> 8 & 0xFF);
                byte o4 = (byte)(bits & 0xFF);
                String partialDecodedStr = new String(new byte[]{o1, o2}, UNICODE_CHARSET);
                if (h4 != 64) {
                    partialDecodedStr = partialDecodedStr.concat(new String(new byte[]{o3, o4}, UNICODE_CHARSET));
                }
                decodedBase64 = decodedBase64.concat(partialDecodedStr);
                c += 6;
                b += 4;
            }
            return decodedBase64;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-16 is not supported: " + e.getMessage()));
            throw new RuntimeException("Unable to decode base64.");
        }
    }

    public static String encode16BitBase64(String plainStr) {
        String encodedBase64Str = "";
        String padding = "";
        int c = plainStr.length() % 2;
        if (c > 0) {
            while (c++ < 2) {
                padding = padding + BASE64_CODE_PADDING;
                plainStr = plainStr + '\u0000';
            }
        }
        for (c = 0; c < plainStr.length(); c += 2) {
            char hd1 = plainStr.charAt(c);
            char hd2 = plainStr.charAt(c + 1);
            int bits = hd1 << 16 | hd2;
            int h1 = bits >> 26 & 0x3F;
            int h2 = bits >> 20 & 0x3F;
            int h3 = bits >> 14 & 0x3F;
            int h4 = bits >> 8 & 0x3F;
            int h5 = bits >> 2 & 0x3F;
            int d6 = bits & 3;
            encodedBase64Str = encodedBase64Str.concat(new String(new char[]{BASE64_CODE.charAt(h1), BASE64_CODE.charAt(h2), BASE64_CODE.charAt(h3), BASE64_CODE.charAt(h4), BASE64_CODE.charAt(h5), BASE64_CODE.charAt(d6)}));
        }
        encodedBase64Str = encodedBase64Str.substring(0, encodedBase64Str.length() - padding.length()) + padding;
        return encodedBase64Str;
    }
}

