/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service.impl;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.util.Map;

public class XmlaConnectionDataSourceService
implements ReportDataSourceService {
    private final XMLAConnection xmlaConnection;
    private final String tenantSeparator;
    private final User contextUser;

    public XmlaConnectionDataSourceService(XMLAConnection xmlaConnection, String tenantSeparator) {
        this(xmlaConnection, tenantSeparator, null);
    }

    public XmlaConnectionDataSourceService(XMLAConnection xmlaConnection, String tenantSeparator, User contextUser) {
        this.xmlaConnection = xmlaConnection;
        this.tenantSeparator = tenantSeparator;
        this.contextUser = contextUser;
    }

    public void setReportParameterValues(Map parameterValues) {
        parameterValues.put("XMLA_URL", this.xmlaConnection.getURI());
        parameterValues.put("XMLA_CATALOG", this.xmlaConnection.getCatalog());
        String dataSource = this.xmlaConnection.getDataSource();
        String uName = null;
        String uPass = null;
        if (this.contextUser == null) {
            uName = this.xmlaConnection.getUsername();
            uPass = this.xmlaConnection.getPassword();
        } else {
            uName = this.contextUser.getUsername();
            if (this.contextUser.getTenantId() != null) {
                uName = uName + this.tenantSeparator + this.contextUser.getTenantId();
            }
            uPass = this.contextUser.getPassword();
        }
        parameterValues.put("XMLA_USER", uName);
        parameterValues.put("XMLA_PASSWORD", uPass);
        parameterValues.put("XMLA_DATASOURCE", dataSource);
    }

    public void closeConnection() {
    }
}

