/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.impl.IdedObject;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.ObjectPermissionRecipientIdentity;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ObjectPermissionServiceInternal;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HibernateObjectPermissionUserAuthorityDeleteListener
implements HibernateDeleteListener,
ApplicationContextAware {
    private String objectPermissionsServiceBeanName;
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected ObjectPermissionServiceInternal getObjectPermissionService() {
        return (ObjectPermissionServiceInternal)this.context.getBean(this.getObjectPermissionsServiceBeanName(), ObjectPermissionServiceInternal.class);
    }

    @Override
    public void onDelete(Object o) {
        if (o instanceof RepoUser) {
            this.deleteObjectPermissions((RepoUser)o);
        } else if (o instanceof RepoRole) {
            this.deleteObjectPermissions((RepoRole)o);
        }
    }

    protected void deleteObjectPermissions(IdedObject recipient) {
        ObjectPermissionRecipientIdentity recipientIdentity = new ObjectPermissionRecipientIdentity(recipient);
        this.getObjectPermissionService().deleteObjectPermissionsForRecipient(null, recipientIdentity);
    }

    public String getObjectPermissionsServiceBeanName() {
        return this.objectPermissionsServiceBeanName;
    }

    public void setObjectPermissionsServiceBeanName(String objectPermissionsServiceBeanName) {
        this.objectPermissionsServiceBeanName = objectPermissionsServiceBeanName;
    }
}

