/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.TenantAwareGrantedAuthority;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.WebAuthenticationDetails;

public class JIPortletAuthenticationProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JIPortletAuthenticationProcessingFilter.class);
    private List trustedIpAddress;
    private UserAuthorityService userService;

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String incomingIPAddress;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Trusted Host Authentication.");
        }
        if ((incomingIPAddress = request.getRemoteAddr()) == null || !this.isFromTrustedHost(incomingIPAddress)) {
            chain.doFilter(request, response);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested from Trusted Host IP:" + incomingIPAddress));
        }
        List<String> roleList = new ArrayList<String>();
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Credentials credentials = this.getUserCredentials(httpRequest);
        String userName = credentials.getUserName();
        String password = credentials.getPassword();
        if (userName == null || userName.trim().length() == 0) {
            chain.doFilter(request, response);
            return;
        }
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        if (existingAuth != null && existingAuth.getName().equals(userName) && existingAuth.isAuthenticated()) {
            request.setAttribute("fromTrustedHost", (Object)"true");
            chain.doFilter(request, response);
            return;
        }
        if (this.doesUserExist(userName)) {
            String oldPassword;
            if (this.isInternalUser(userName) && !this.haveSamePassword(oldPassword = this.getUserPaswordFromRepository(userName), password)) {
                this.updatePassword(userName, password);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updated Password for User:" + userName));
                }
            }
            roleList = this.getUserRoleList(userName);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created New User:" + userName));
            }
            roleList.add("ROLE_USER");
            roleList.add("ROLE_PORTLET");
            this.createUserWithRoles(userName, password, roleList, false);
        }
        SecurityContextHolder.getContext().setAuthentication(this.createAuthenticationObject(userName, password, roleList, request));
        request.setAttribute("fromTrustedHost", (Object)"true");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Created Authentication Object within JIPortletAuthenticationProcessingFilter");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    protected Credentials getUserCredentials(HttpServletRequest httpRequest) {
        String base64Token;
        String token;
        int delim;
        String header = httpRequest.getHeader("Authorization");
        String userName = null;
        String password = null;
        if (header != null && header.startsWith("Basic ") && (delim = (token = new String(Base64.decodeBase64((byte[])(base64Token = header.substring(6)).getBytes()))).indexOf(":")) != -1) {
            userName = token.substring(0, delim);
            password = token.substring(delim + 1);
        }
        return new Credentials(userName, password);
    }

    private boolean isFromTrustedHost(String ipAddress) {
        if (this.trustedIpAddress == null || ipAddress == null) {
            return false;
        }
        if (this.trustedIpAddress.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.trustedIpAddress.size(); ++i) {
            if (!((String)this.trustedIpAddress.get(i)).equals(ipAddress)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesUserExist(String userName) {
        return this.userService.userExists(null, userName);
    }

    protected User getUser(String username) {
        return this.userService.getUser(null, username);
    }

    private boolean isInternalUser(String userName) {
        User user = this.getUser(userName);
        return !user.isExternallyDefined();
    }

    protected void createUserWithRoles(String userName, String password, List roleList, boolean externalUser) {
        User user = this.userService.newUser(null);
        user.setExternallyDefined(externalUser);
        user.setUsername(userName);
        user.setPassword(password);
        user.setFullName(userName);
        user.setEnabled(true);
        user.setEmailAddress(userName);
        HashSet<Role> roleSet = new HashSet<Role>();
        for (int i = 0; i < roleList.size(); ++i) {
            Role role = this.userService.newRole(null);
            role.setRoleName((String)roleList.get(i));
            roleSet.add(role);
        }
        user.setRoles(roleSet);
        this.userService.putUser(null, user);
    }

    protected Authentication createAuthenticationObject(String userName, String password, List roleList, ServletRequest request) {
        GrantedAuthority[] roleListArray = new GrantedAuthority[roleList.size()];
        for (int i = 0; i < roleList.size(); ++i) {
            roleListArray[i] = new TenantAwareGrantedAuthority((String)roleList.get(i));
        }
        User user = this.getUser(userName);
        MetadataUserDetails md = new MetadataUserDetails(user);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)md, (Object)password, roleListArray);
        authRequest.setDetails((Object)new WebAuthenticationDetails((HttpServletRequest)request));
        return authRequest;
    }

    private String getUserPaswordFromRepository(String userName) {
        User user = this.getUser(userName);
        return user.getPassword();
    }

    private boolean haveSamePassword(String oldPassword, String newPassword) {
        return oldPassword.equals(newPassword);
    }

    private void updatePassword(String userName, String newPassword) {
        User user = this.getUser(userName);
        user.setPassword(newPassword);
        this.userService.putUser(null, user);
    }

    private List getUserRoleList(String userName) {
        ArrayList<String> roles = new ArrayList<String>();
        User user = this.getUser(userName);
        if (user != null) {
            Iterator iter = user.getRoles().iterator();
            while (iter.hasNext()) {
                roles.add(((Role)iter.next()).getRoleName());
            }
        }
        return roles;
    }

    public List getTrustedIpAddress() {
        return this.trustedIpAddress;
    }

    public void setTrustedIpAddress(List trustedIpAddress) {
        this.trustedIpAddress = trustedIpAddress;
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    protected class Credentials {
        private String userName;
        private String password;

        public Credentials(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

