/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserManagerService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class UserManagerServiceImpl
extends HibernateDaoImpl
implements UserManagerService {
    protected static final Log log = LogFactory.getLog(UserManagerServiceImpl.class);
    protected UserAuthorityService userService;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateUser(ExecutionContext context, String userName, User userDetails, Set<Role> assignedRoleSet, Set<Role> unassignedRoleSet) {
        User oldUser = this.userService.getUser(null, userName);
        String newPassword = userDetails.getPassword();
        String oldPassword = oldUser.getPassword();
        if (newPassword == null) {
            userDetails.setPassword(oldPassword);
        } else if (!newPassword.equals(oldPassword)) {
            userDetails.setPreviousPasswordChangeTime(new Date());
        }
        Set roles = oldUser.getRoles();
        FilterCriteria filter = FilterCriteria.createFilter(Role.class);
        List allRoles = this.userService.getRoles(null, filter);
        if (allRoles != null) {
            for (Role assignedRole : unassignedRoleSet) {
                roles.remove(this.getRole(assignedRole, allRoles));
            }
            for (Role assignedRole : assignedRoleSet) {
                roles.add(this.getRole(assignedRole, allRoles));
            }
        }
        userDetails.setRoles(roles);
        this.userService.updateUser(null, userName, userDetails);
    }

    private Role getRole(Role roleDetails, List<Role> list) {
        for (Role role : list) {
            if (!role.equals(roleDetails)) continue;
            return role;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void enableAll(ExecutionContext context, List<String> users) {
        if (users != null) {
            for (String userName : users) {
                if (userName == null || userName.length() <= 0) continue;
                this.enableOrDisableUser(context, userName, true);
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void disableAll(ExecutionContext context, List<String> users) {
        if (users != null) {
            for (String userName : users) {
                if (userName == null || userName.length() <= 0) continue;
                this.enableOrDisableUser(context, userName, false);
            }
        }
    }

    protected void enableOrDisableUser(ExecutionContext context, String userName, boolean enable) {
        User user = this.getUser(context, userName);
        if (user != null && user.isEnabled() != enable) {
            user.setEnabled(enable);
            this.userService.updateUser(context, userName, user);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteAll(ExecutionContext context, List<String> users) {
        if (users != null) {
            for (String userName : users) {
                if (userName == null || userName.length() <= 0) continue;
                this.userService.deleteUser(context, userName);
            }
        }
    }

    protected User getUser(ExecutionContext context, String userName) {
        return this.userService.getUser(context, userName);
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }
}

