/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class IPadSupportFilter
implements Filter,
InitializingBean {
    public static final String IS_IPAD = "isIPad";
    private String redirectUrl;
    private List<String> notSupportedUrls;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setNotSupportedUrls(List<String> notSupportedUrls) {
        this.notSupportedUrls = notSupportedUrls;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.redirectUrl, (String)"redirectUrl must be specified");
        Assert.notEmpty(this.notSupportedUrls, (String)"notSupportedUrls must be specified");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isIPad(httpRequest)) {
            httpRequest.setAttribute(IS_IPAD, (Object)true);
        }
        if (this.isSupported(httpRequest)) {
            chain.doFilter(request, response);
        } else {
            httpResponse.sendRedirect(this.createRedirectUrl(httpRequest, httpResponse));
        }
    }

    private boolean isSupported(HttpServletRequest request) {
        return !this.isIPad(request) || this.isRequestUrlSupported(request);
    }

    private boolean isIPad(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return userAgent != null && userAgent.indexOf("iPad") > -1;
    }

    private boolean isRequestUrlSupported(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().append("?").append(request.getQueryString()).toString();
        for (String url : this.notSupportedUrls) {
            if (requestUrl.indexOf(url) <= -1) continue;
            return false;
        }
        return true;
    }

    private String createRedirectUrl(HttpServletRequest request, HttpServletResponse response) {
        return response.encodeRedirectURL(request.getContextPath() + this.redirectUrl);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

