/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.encryption;

import com.jaspersoft.jasperserver.api.security.SecurityConfiguration;
import com.jaspersoft.jasperserver.api.security.encryption.EncryptionManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.KeyPair;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class GetEncryptionKey
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(GetEncryptionKey.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out = null;
        try {
            out = res.getWriter();
            if (SecurityConfiguration.isEncryptionOn()) {
                KeyPair keyPair = (KeyPair)req.getSession().getAttribute("KEYPAIR_SESSION_KEY");
                boolean dynamicKeyGeneration = SecurityConfiguration.isEncryptionDynamicKeyGeneration();
                if (dynamicKeyGeneration || keyPair == null) {
                    keyPair = EncryptionManager.generateKeys(dynamicKeyGeneration);
                    req.getSession().setAttribute("KEYPAIR_SESSION_KEY", (Object)keyPair);
                }
                JSONObject jsonObj = EncryptionManager.buildPublicKeyJSON(keyPair.getPublic());
                out.print(jsonObj.toString());
            } else {
                out.print("{Error: Key generation is off}");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to generate keys.", (Throwable)e);
            out.print("{Error: Exception during key generation: " + e.getMessage() + "}");
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }
}

