/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.common;

import com.jaspersoft.jasperserver.dto.common.PatchItem;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="patchItems")
public class PatchDescriptor {
    private List<PatchItem> items;
    private int version;

    public PatchDescriptor() {
    }

    public PatchDescriptor(int version) {
        this.version = version;
    }

    public PatchDescriptor(List<PatchItem> items, int version) {
        this.items = items;
        this.version = version;
    }

    @XmlElement(name="version")
    public int getVersion() {
        return this.version;
    }

    public PatchDescriptor setVersion(int version) {
        this.version = version;
        return this;
    }

    @XmlElement(name="patch")
    public List<PatchItem> getItems() {
        return this.items;
    }

    public PatchDescriptor setItems(List<PatchItem> items) {
        this.items = items;
        return this;
    }

    public PatchDescriptor field(String name, String value) {
        if (this.items == null) {
            this.items = new LinkedList<PatchItem>();
        }
        PatchItem item = new PatchItem();
        item.setField(name);
        item.setValue(value);
        this.items.add(item);
        return this;
    }

    public PatchDescriptor expression(String expression) {
        if (this.items == null) {
            this.items = new LinkedList<PatchItem>();
        }
        PatchItem item = new PatchItem();
        item.setExpression(expression);
        this.items.add(item);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchDescriptor that = (PatchDescriptor)o;
        return !(this.items != null ? !((Object)this.items).equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return this.items != null ? ((Object)this.items).hashCode() : 0;
    }

    public String toString() {
        return "PatchDescriptor{items=" + this.items + '}';
    }
}

