/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jboss.as.cli.gui.CommandBuilderTree;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.as.cli.gui.OperationMenu;

public class ManagementModel
extends JPanel {
    private JTextField cmdText = GuiMain.getCommandText();
    private CommandExecutor executor = GuiMain.getExecutor();

    public ManagementModel() {
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)new JLabel("Right-click a node to choose an operation.  Close/Open a folder to refresh.  Hover for help."), "North");
        this.add((Component)this.makeTree(), "Center");
    }

    private JTree makeTree() {
        ManagementModelNode root = new ManagementModelNode();
        root.explore();
        CommandBuilderTree tree = new CommandBuilderTree(new DefaultTreeModel(root));
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeExpansionListener(new ManagementTreeExpansionListener((DefaultTreeModel)tree.getModel()));
        tree.addTreeSelectionListener(new ManagementTreeSelectionListener());
        tree.addMouseListener(new ManagementTreeMouseListener(tree));
        return tree;
    }

    private class ManagementTreeMouseListener
    extends MouseAdapter {
        private JTree tree;
        private OperationMenu popup;

        public ManagementTreeMouseListener(JTree tree) {
            this.tree = tree;
            this.popup = new OperationMenu(ManagementModel.this.executor, tree, ManagementModel.this.cmdText);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            this.showPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1) {
                return;
            }
            TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
            this.tree.setSelectionPath(selPath);
            ManagementModelNode node = (ManagementModelNode)selPath.getLastPathComponent();
            this.popup.show(node, e.getX(), e.getY());
        }
    }

    private class ManagementTreeSelectionListener
    implements TreeSelectionListener {
        private ManagementTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            ManagementModelNode selected = (ManagementModelNode)tse.getPath().getLastPathComponent();
            ManagementModel.this.cmdText.setText(selected.addressPath());
        }
    }

    private class ManagementTreeExpansionListener
    implements TreeExpansionListener {
        private DefaultTreeModel treeModel;

        public ManagementTreeExpansionListener(DefaultTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent tee) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent tee) {
            ManagementModelNode node = (ManagementModelNode)tee.getPath().getLastPathComponent();
            node.explore();
            this.treeModel.nodeStructureChanged(node);
        }
    }
}

