/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.util;

import com.jaspersoft.jasperserver.api.JSException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.WeakHashMap;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileBufferedOutputStream
extends OutputStream {
    private static final Log log = LogFactory.getLog(FileBufferedOutputStream.class);
    public static final String PROPERTY_MEMORY_THRESHOLD = "net.sf.jasperreports.file.buffer.os.memory.threshold";
    public static final int INFINIT_MEMORY_THRESHOLD = -1;
    public static final int DEFAULT_INITIAL_MEMORY_BUFFER_SIZE = 65536;
    public static final int DEFAULT_INPUT_BUFFER_LENGTH = 16384;
    private final int memoryThreshold;
    private final int initialMemoryBufferSize;
    private final int inputBufferLength;
    private final ByteArrayOutputStream memoryOutput;
    private int size;
    private File file;
    private BufferedOutputStream fileOutput;
    private boolean closed;
    private boolean disposed;
    private final WeakHashMap<DataStream, Boolean> inputStreams;

    public FileBufferedOutputStream() {
        this(JRProperties.getIntegerProperty((String)PROPERTY_MEMORY_THRESHOLD, (int)-1), 65536, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold) {
        this(memoryThreshold, 65536, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold, int initialMemoryBufferSize) {
        this(memoryThreshold, initialMemoryBufferSize, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold, int initialMemoryBufferSize, int inputBufferLength) {
        this.memoryThreshold = memoryThreshold;
        this.initialMemoryBufferSize = initialMemoryBufferSize;
        this.inputBufferLength = inputBufferLength;
        this.size = 0;
        if (this.memoryThreshold == 0) {
            this.memoryOutput = null;
        } else {
            int initialSize = this.initialMemoryBufferSize;
            if (initialSize > this.memoryThreshold) {
                initialSize = this.memoryThreshold;
            }
            this.memoryOutput = new ByteArrayOutputStream(initialSize);
        }
        this.inputStreams = new WeakHashMap();
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.availableMemorySpace() > 0) {
            this.memoryOutput.write(b);
        } else {
            this.ensureFileOutput().write(b);
        }
        ++this.size;
    }

    protected int availableMemorySpace() {
        int availableMemorySpace = this.memoryOutput != null && (this.memoryThreshold < 0 || this.memoryOutput.size() < this.memoryThreshold) ? this.memoryThreshold - this.memoryOutput.size() : 0;
        return availableMemorySpace;
    }

    protected BufferedOutputStream ensureFileOutput() throws IOException, FileNotFoundException {
        if (this.fileOutput == null) {
            this.file = File.createTempFile("file.buff.os.", ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            this.fileOutput = new BufferedOutputStream(fileOutputStream);
        }
        return this.fileOutput;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        int memoryLen = this.availableMemorySpace();
        if (len < memoryLen) {
            memoryLen = len;
        }
        if (memoryLen > 0) {
            this.memoryOutput.write(b, off, memoryLen);
        }
        if (memoryLen < len) {
            this.ensureFileOutput().write(b, off + memoryLen, len - memoryLen);
        }
        this.size += len;
    }

    public void checkClosed() {
        if (this.closed) {
            throw new JSException("Output stream already closed.");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed && this.fileOutput != null) {
            this.fileOutput.flush();
            this.fileOutput.close();
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.fileOutput != null) {
            this.fileOutput.flush();
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(OutputStream out) throws IOException {
        if (!this.closed) {
            this.close();
        }
        if (this.memoryOutput != null) {
            this.memoryOutput.writeTo(out);
        }
        if (this.file != null) {
            FileInputStream fileInput = new FileInputStream(this.file);
            boolean inputClosed = false;
            try {
                int read;
                byte[] buffer = new byte[this.inputBufferLength];
                while ((read = fileInput.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                fileInput.close();
                inputClosed = true;
            }
            finally {
                if (!inputClosed) {
                    try {
                        fileInput.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Could not close file input stream", (Throwable)e);
                    }
                }
            }
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        boolean success = true;
        if (!this.closed && this.fileOutput != null) {
            try {
                this.fileOutput.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error while closing the temporary file output stream", (Throwable)e);
                success = false;
            }
        }
        for (DataStream dataStream : this.inputStreams.keySet()) {
            try {
                dataStream.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error while closing temporary file input stream", (Throwable)e);
                success = false;
            }
        }
        if (this.file != null && !this.file.delete()) {
            log.warn((Object)"Error while deleting the temporary file");
            success = false;
        }
        this.disposed = success;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public InputStream getDataInputStream() throws IOException {
        if (!this.closed) {
            this.close();
        }
        DataStream dataStream = new DataStream();
        this.inputStreams.put(dataStream, Boolean.TRUE);
        return dataStream;
    }

    protected class DataStream
    extends InputStream {
        private int memoryIdx = 0;
        private int memoryLength;
        private final InputStream byteInputStream;
        private final InputStream fileInput;

        public DataStream() throws FileNotFoundException, IOException {
            byte[] memoryData = FileBufferedOutputStream.this.memoryOutput == null ? new byte[]{} : FileBufferedOutputStream.this.memoryOutput.toByteArray();
            this.memoryLength = memoryData.length;
            this.byteInputStream = new ByteArrayInputStream(memoryData);
            this.fileInput = FileBufferedOutputStream.this.file == null ? null : new BufferedInputStream(new FileInputStream(FileBufferedOutputStream.this.file));
        }

        @Override
        public synchronized int read() throws IOException {
            int read;
            if (this.memoryIdx < this.memoryLength) {
                read = this.byteInputStream.read();
                ++this.memoryIdx;
            } else {
                read = this.fileInput != null ? this.fileInput.read() : -1;
            }
            return read;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int readFile;
            int read;
            if (len <= 0) {
                return 0;
            }
            if (this.memoryIdx < this.memoryLength) {
                read = len;
                if (read > this.memoryLength - this.memoryIdx) {
                    read = this.memoryLength - this.memoryIdx;
                }
                this.byteInputStream.read(b, off, read);
                this.memoryIdx += read;
            } else {
                read = 0;
            }
            if (read < len && this.fileInput != null && (readFile = this.fileInput.read(b, off + read, len - read)) > 0) {
                read += readFile;
            }
            return read == 0 ? -1 : read;
        }

        @Override
        public void close() throws IOException {
            if (this.fileInput != null) {
                this.fileInput.close();
            }
        }

        @Override
        public synchronized int available() throws IOException {
            int available = this.byteInputStream.available();
            if (this.fileInput != null) {
                available += this.fileInput.available();
            }
            return available;
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            long skipped;
            if (n <= 0L) {
                return 0L;
            }
            if (this.memoryIdx < this.memoryLength) {
                skipped = n;
                if (skipped > (long)(this.memoryLength - this.memoryIdx)) {
                    skipped = this.memoryLength - this.memoryIdx;
                }
                skipped = this.byteInputStream.skip(skipped);
                this.memoryIdx = (int)((long)this.memoryIdx + skipped);
            } else {
                skipped = 0L;
            }
            if (skipped < n && this.fileInput != null) {
                skipped += this.fileInput.skip(n - skipped);
            }
            return skipped;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

