/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.component;

import com.tonbeller.wcf.controller.RequestContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RendererParameters {
    private static final String WEBKEY = RendererParameters.class.getName();
    public static final String MODE = "mode";
    public static final String EXCEL = "excel";
    public static final String PRINT = "print";

    public static boolean isRenderActions(RequestContext context) {
        return RendererParameters.isRenderActions(context.getRequest());
    }

    public static boolean isExcelMode(RequestContext context) {
        return RendererParameters.isExcelMode(context.getRequest());
    }

    public static boolean isPrintMode(RequestContext context) {
        return RendererParameters.isPrintMode(context.getRequest());
    }

    public static boolean isRenderActions(HttpServletRequest request) {
        return RendererParameters.getParameterMap(request).get(MODE) == null;
    }

    public static boolean isExcelMode(HttpServletRequest request) {
        return EXCEL.equals(RendererParameters.getParameterMap(request).get(MODE));
    }

    public static boolean isPrintMode(HttpServletRequest request) {
        return PRINT.equals(RendererParameters.getParameterMap(request).get(MODE));
    }

    public static void setParameter(HttpServletRequest req, String name, Object value, String scope) {
        Map map = RendererParameters.getMap(req, scope, true);
        map.put(name, value);
    }

    public static void removeParameter(HttpServletRequest req, String name, Object value, String scope) {
        Map map = RendererParameters.getMap(req, scope, false);
        if (map != null) {
            map.remove(name);
        }
    }

    private static Map getMap(HttpServletRequest req, String scope, boolean create) {
        if ("request".equals(scope)) {
            return RendererParameters.getRequestMap(req, create);
        }
        if ("session".equals(scope)) {
            return RendererParameters.getSessionMap(req, create);
        }
        if ("application".equals(scope)) {
            return RendererParameters.getContextMap(req, create);
        }
        throw new IllegalArgumentException("scope must be one of 'request', 'session', 'application'");
    }

    private static Map getRequestMap(HttpServletRequest req, boolean create) {
        HashMap map = (HashMap)req.getAttribute(WEBKEY);
        if (map != null || !create) {
            return map;
        }
        map = new HashMap();
        req.setAttribute(WEBKEY, map);
        return map;
    }

    private static Map getSessionMap(HttpServletRequest req, boolean create) {
        HttpSession session = req.getSession(true);
        HashMap map = (HashMap)session.getAttribute(WEBKEY);
        if (map != null || !create) {
            return map;
        }
        map = new HashMap();
        session.setAttribute(WEBKEY, map);
        return map;
    }

    private static Map getContextMap(HttpServletRequest req, boolean create) {
        ServletContext context = req.getSession(true).getServletContext();
        HashMap map = (HashMap)context.getAttribute(WEBKEY);
        if (map != null || !create) {
            return map;
        }
        map = new HashMap();
        context.setAttribute(WEBKEY, map);
        return map;
    }

    public static Map getParameterMap(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        ServletContext context = session.getServletContext();
        HashMap map = new HashMap();
        Map m = (Map)context.getAttribute(WEBKEY);
        if (m != null) {
            map.putAll(m);
        }
        if ((m = (Map)session.getAttribute(WEBKEY)) != null) {
            map.putAll(m);
        }
        if ((m = (Map)request.getAttribute(WEBKEY)) != null) {
            map.putAll(m);
        }
        return Collections.unmodifiableMap(map);
    }
}

