/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import com.tonbeller.wcf.tree.TreeModelDecorator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CachingTreeModelDecorator
extends TreeModelDecorator {
    Object[] roots = null;
    Map getParentMap;
    Map getChildrenMap;
    Map hasChildrenMap;
    private static Logger logger = Logger.getLogger(CachingTreeModelDecorator.class);
    TreeModelChangeListener listener = new TreeModelChangeListener(){

        public void treeModelChanged(TreeModelChangeEvent e) {
            logger.info((Object)"invalidating TreeModelCache");
            CachingTreeModelDecorator.this.roots = null;
            CachingTreeModelDecorator.this.getParentMap.clear();
            CachingTreeModelDecorator.this.getChildrenMap.clear();
            CachingTreeModelDecorator.this.hasChildrenMap.clear();
        }
    };

    public CachingTreeModelDecorator(TreeModel decoree) {
        super(decoree);
        this.getParentMap = new HashMap();
        this.getChildrenMap = new HashMap();
        this.hasChildrenMap = new HashMap();
        decoree.addTreeModelChangeListener(this.listener);
    }

    public CachingTreeModelDecorator(TreeModel decoree, Comparator nodeComparator) {
        super(decoree);
        this.getParentMap = new TreeMap(nodeComparator);
        this.getChildrenMap = new TreeMap(nodeComparator);
        this.hasChildrenMap = new TreeMap(nodeComparator);
        decoree.addTreeModelChangeListener(this.listener);
    }

    public Object[] getRoots() {
        if (this.roots == null) {
            this.roots = super.getRoots();
        }
        return this.roots;
    }

    public boolean hasChildren(Object node) {
        Boolean b = (Boolean)this.hasChildrenMap.get(node);
        if (b == null) {
            b = new Boolean(super.hasChildren(node));
            this.hasChildrenMap.put(node, b);
        }
        return b;
    }

    public Object[] getChildren(Object node) {
        Object[] children = (Object[])this.getChildrenMap.get(node);
        if (children == null) {
            children = super.getChildren(node);
            if (children == null) {
                children = new Object[]{};
            }
            this.getChildrenMap.put(node, children);
            for (int i = 0; i < children.length; ++i) {
                this.getParentMap.put(children[i], node);
            }
        }
        return children;
    }

    public Object getParent(Object node) {
        Object parent = this.getParentMap.get(node);
        if (parent == null && !this.getParentMap.containsKey(node)) {
            parent = super.getParent(node);
            this.getParentMap.put(node, parent);
        }
        return parent;
    }
}

