/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers;

import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.dto.common.validations.DateTimeFormatValidationRule;
import com.jaspersoft.jasperserver.dto.common.validations.MandatoryValidationRule;
import com.jaspersoft.jasperserver.dto.common.validations.ValidationRule;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.InputControlState;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.ReportInputControl;
import com.jaspersoft.jasperserver.war.cascade.CachedRepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.GenericTypeProcessorRegistry;
import com.jaspersoft.jasperserver.war.cascade.handlers.InputControlHandler;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverterService;
import com.jaspersoft.jasperserver.war.cascade.handlers.validators.InputControlValueValidator;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class BasicInputControlHandler
implements InputControlHandler {
    public static final String MULTI_DATA_TYPE_UI_TYPE = "singleValue";
    @Resource
    private Map<String, String> multyDataTypeMapping;
    @Resource
    protected CachedRepositoryService cachedRepositoryService;
    @Resource
    private GenericTypeProcessorRegistry genericTypeProcessorRegistry;
    @Resource
    protected DataConverterService dataConverterService;
    @Resource
    protected MessageSource messageSource;
    @Resource(name="messagesCalendarFormatProvider")
    protected CalendarFormatProvider calendarFormatProvider;

    @Override
    public void applyNothingSelected(String controlName, Map<String, Object> parameters) {
        parameters.remove(controlName);
    }

    @Override
    public boolean isNothingSelected(String[] rawData) {
        Boolean result = false;
        if (rawData != null) {
            List<String> rawDataList = Arrays.asList(rawData);
            result = rawDataList.contains("~NOTHING~");
        }
        return result;
    }

    @Override
    public Set<String> getMasterDependencies(InputControl control, ResourceReference dataSource) throws CascadeResourceNotFoundException {
        return new HashSet<String>();
    }

    @Override
    public ReportInputControl buildReportInputControl(InputControl inputControl, String uiType, ResourceReference dataSource) throws CascadeResourceNotFoundException {
        ReportInputControl control = new ReportInputControl();
        control.setId(inputControl.getName());
        control.setLabel(inputControl.getLabel());
        control.setDescription(inputControl.getDescription());
        control.setUri(inputControl.getURI());
        control.setMandatory(Boolean.valueOf(inputControl.isMandatory()));
        control.setReadOnly(Boolean.valueOf(inputControl.isReadOnly()));
        control.setVisible(Boolean.valueOf(inputControl.isVisible()));
        control.setType(this.getType(inputControl, uiType));
        List<ValidationRule> validationRules = this.getValidationRules(inputControl);
        if (validationRules != null && !validationRules.isEmpty()) {
            control.setValidationRules(validationRules);
        }
        return control;
    }

    protected String getType(InputControl inputControl, String uiType) throws CascadeResourceNotFoundException {
        String type = uiType;
        if (MULTI_DATA_TYPE_UI_TYPE.equals(uiType)) {
            byte dataType = this.cachedRepositoryService.getResource(DataType.class, inputControl.getDataType()).getType();
            type = this.multyDataTypeMapping.get(String.valueOf(dataType));
        }
        return type;
    }

    @Override
    public final InputControlState getState(InputControl inputControl, ResourceReference dataSource, Map<String, Object> parameters, Map<String, Class<?>> parameterTypes, ReportInputControlInformation info) throws CascadeResourceNotFoundException {
        InputControlState state = new InputControlState();
        state.setUri(inputControl.getURIString());
        state.setId(inputControl.getName());
        this.fillStateValue(state, inputControl, dataSource, parameters, info, parameterTypes);
        return state;
    }

    protected List<ValidationRule> getValidationRules(InputControl inputControl) throws CascadeResourceNotFoundException {
        DataType dataType;
        ArrayList<ValidationRule> validationRules = new ArrayList<ValidationRule>();
        if (inputControl.isMandatory()) {
            MandatoryValidationRule mandatoryValidationRule = new MandatoryValidationRule();
            mandatoryValidationRule.setErrorMessage(this.getMessage("fillParameters.error.mandatoryField", new Object[0]));
            validationRules.add((ValidationRule)mandatoryValidationRule);
        }
        DataType dataType2 = dataType = inputControl.getDataType() != null ? this.cachedRepositoryService.getResource(DataType.class, inputControl.getDataType()) : null;
        if (dataType != null) {
            switch (dataType.getType()) {
                case 3: {
                    DateTimeFormatValidationRule dateFormatValidationRule = new DateTimeFormatValidationRule();
                    dateFormatValidationRule.setFormat(this.calendarFormatProvider.getDatePattern());
                    dateFormatValidationRule.setErrorMessage(this.getMessage("fillParameters.error.invalidDate", new Object[0]));
                    validationRules.add((ValidationRule)dateFormatValidationRule);
                    break;
                }
                case 4: {
                    DateTimeFormatValidationRule dateTimeFormatValidationRule = new DateTimeFormatValidationRule();
                    dateTimeFormatValidationRule.setFormat(this.calendarFormatProvider.getDatetimePattern());
                    dateTimeFormatValidationRule.setErrorMessage(this.getMessage("fillParameters.error.invalidDateTime", new Object[0]));
                    validationRules.add((ValidationRule)dateTimeFormatValidationRule);
                    break;
                }
                case 5: {
                    DateTimeFormatValidationRule dateTimeFormatValidationRule = new DateTimeFormatValidationRule();
                    dateTimeFormatValidationRule.setFormat(this.calendarFormatProvider.getTimePattern());
                    dateTimeFormatValidationRule.setErrorMessage(this.getMessage("fillParameters.error.invalidTime", new Object[0]));
                    validationRules.add((ValidationRule)dateTimeFormatValidationRule);
                }
            }
        }
        return validationRules;
    }

    protected void fillStateValue(InputControlState state, InputControl inputControl, ResourceReference dataSource, Map<String, Object> parameters, ReportInputControlInformation info, Map<String, Class<?>> parameterTypes) throws CascadeResourceNotFoundException {
        if (parameters.containsKey(inputControl.getName())) {
            Object typedValue = parameters.get(inputControl.getName());
            if (inputControl.isMandatory()) {
                this.doMandatoryValidation(typedValue, state);
            }
            state.setValue(this.dataConverterService.formatSingleValue(typedValue, inputControl, info));
        } else {
            this.internalApplyNothingSubstitution(inputControl.getName(), parameters);
        }
    }

    protected void internalApplyNothingSubstitution(String controlName, Map<String, Object> parameters) {
        parameters.put(controlName, null);
    }

    protected void doMandatoryValidation(Object typedValue, InputControlState state) {
        if (state.getError() == null && !this.hasValue(typedValue).booleanValue()) {
            state.setError(this.getMessage("fillParameters.error.mandatoryField", new Object[0]));
        }
    }

    @Override
    public final Object convertParameterValueFromRawData(String[] rawData, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException, InputControlValidationException {
        Object value = rawData != null ? this.internalConvertParameterValueFromRawData(rawData, inputControl, info) : info.getDefaultValue();
        this.internalValidateValue(value, inputControl, info);
        return value;
    }

    protected Boolean hasValue(Object value) {
        return value != null;
    }

    protected Object internalConvertParameterValueFromRawData(String[] rawData, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException, InputControlValidationException {
        return rawData != null && rawData.length > 0 ? this.dataConverterService.convertSingleValue(rawData[0], inputControl, info) : null;
    }

    protected void internalValidateValue(Object value, InputControl inputControl, ReportInputControlInformation info) throws InputControlValidationException, CascadeResourceNotFoundException {
        DataType dataType = inputControl.getDataType() != null ? this.cachedRepositoryService.getResource(DataType.class, inputControl.getDataType()) : null;
        try {
            this.validateSingleValue(value, dataType);
        }
        catch (InputControlValidationException e) {
            e.getValidationError().setInvalidValue(this.dataConverterService.formatSingleValue(value, inputControl, info));
            throw e;
        }
    }

    protected void validateSingleValue(Object value, DataType dataType) throws InputControlValidationException {
        if (value != null && dataType != null) {
            InputControlValueValidator validator = this.genericTypeProcessorRegistry.getTypeProcessor(value.getClass(), InputControlValueValidator.class, (Boolean)false);
            if (validator == null && value instanceof Comparable) {
                validator = this.genericTypeProcessorRegistry.getTypeProcessor(Comparable.class, InputControlValueValidator.class, (Boolean)false);
            }
            if (validator != null) {
                validator.validateSingleValue(value, dataType);
            }
        }
    }

    @Override
    public String[] formatValue(Object typedValue, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException {
        return new String[]{this.dataConverterService.formatSingleValue(typedValue, inputControl, info)};
    }

    protected String getMessage(String messageKey, Object ... arguments) {
        return this.messageSource.getMessage(messageKey, arguments, LocaleContextHolder.getLocale());
    }
}

