/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.api.common.util.rd.DateRangeFactory;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverter;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.DateRangeExpression;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DateRangeDataConverter
implements DataConverter<DateRange> {
    @Resource(name="messagesCalendarFormatProvider")
    protected CalendarFormatProvider calendarFormatProvider;

    @Override
    public DateRange stringToValue(String rawData) throws Exception {
        if (StringUtils.isEmpty((String)rawData)) {
            return null;
        }
        return DateRangeFactory.getInstance((String)rawData, Date.class, (String)DateRangeDataConverter.getStringDatePattern(this.calendarFormatProvider.getDateFormat()));
    }

    @Override
    public String valueToString(DateRange value) {
        if (value == null) {
            return "";
        }
        if (value instanceof DateRangeExpression) {
            return ((DateRangeExpression)value).getExpression();
        }
        return this.calendarFormatProvider.getDateFormat().format(value.getStart());
    }

    public static String getStringDatePattern(DateFormat dateFormat) {
        return ((SimpleDateFormat)dateFormat).toPattern();
    }
}

