/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverter;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.TimestampDataConverter;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TimeDataConverter
implements DataConverter<Time> {
    @Resource(name="messagesCalendarFormatProvider")
    protected CalendarFormatProvider calendarFormatProvider;

    @Override
    public Time stringToValue(String rawData) throws ParseException {
        return StringUtils.isNotEmpty((String)rawData) ? new Time(this.getFormatter().parse(rawData).getTime()) : null;
    }

    @Override
    public String valueToString(Time value) {
        return value != null ? this.getFormatter().format(value) : "";
    }

    private DateFormat getFormatter() {
        return TimestampDataConverter.getDateFormatWithTimeZone(this.calendarFormatProvider.getTimeFormat());
    }
}

