/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.TimeZonesList;
import com.jaspersoft.jasperserver.war.dto.StringOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.collections.ReferenceMap;
import org.springframework.beans.factory.InitializingBean;

public class JdkTimeZonesList
implements TimeZonesList,
InitializingBean {
    private List timeZonesIds;
    private final Map userTimeZonesLists = Collections.synchronizedMap(new ReferenceMap(0, 1));

    public void afterPropertiesSet() throws Exception {
        if (this.timeZonesIds == null) {
            String[] availableIDs = TimeZone.getAvailableIDs();
            this.timeZonesIds = Arrays.asList(availableIDs);
        }
    }

    public List getTimeZones(Locale userLocale) {
        List timeZones = (List)this.userTimeZonesLists.get(userLocale);
        if (timeZones == null) {
            timeZones = this.createTimeZones(userLocale);
            this.userTimeZonesLists.put(userLocale, timeZones);
        }
        return timeZones;
    }

    protected List createTimeZones(Locale userLocale) {
        ArrayList<StringOption> timeZones = new ArrayList<StringOption>(this.timeZonesIds.size() + 1);
        if (this.findExistingDefaultTZ() == null) {
            TimeZone defaultTz = this.getSystemDefault();
            timeZones.add(this.createOption(userLocale, defaultTz));
        }
        for (String id : this.timeZonesIds) {
            TimeZone timeZone = this.loadTimeZone(id);
            timeZones.add(this.createOption(userLocale, timeZone));
        }
        return timeZones;
    }

    protected TimeZone loadTimeZone(String id) {
        TimeZone timeZone = TimeZone.getTimeZone(id);
        if (timeZone == null) {
            String quotedTimezone = "\"" + id + "\"";
            throw new JSException("jsexception.unknown.timezone", new Object[]{quotedTimezone});
        }
        return timeZone;
    }

    public String getDefaultTimeZoneID() {
        TimeZone existingTz = this.findExistingDefaultTZ();
        if (existingTz == null) {
            existingTz = this.getSystemDefault();
        }
        return existingTz.getID();
    }

    protected TimeZone findExistingDefaultTZ() {
        TimeZone defaultTz = this.getSystemDefault();
        TimeZone existingTz = null;
        for (String id : this.timeZonesIds) {
            TimeZone timeZone;
            if (id.equals(defaultTz.getID())) {
                existingTz = defaultTz;
                break;
            }
            if (existingTz != null || !defaultTz.hasSameRules(timeZone = this.loadTimeZone(id))) continue;
            existingTz = timeZone;
        }
        return existingTz;
    }

    protected TimeZone getSystemDefault() {
        TimeZone defaultTz = TimeZone.getDefault();
        return defaultTz;
    }

    protected StringOption createOption(Locale userLocale, TimeZone tz) {
        String description = this.getTimeZoneDescription(tz, userLocale);
        StringOption option = new StringOption(tz.getID(), description);
        return option;
    }

    protected String getTimeZoneDescription(TimeZone timeZone, Locale userLocale) {
        return timeZone.getDisplayName(userLocale);
    }

    public List getTimeZonesIds() {
        return this.timeZonesIds;
    }

    public void setTimeZonesIds(List timeZonesIds) {
        this.timeZonesIds = timeZonesIds;
        this.userTimeZonesLists.clear();
    }
}

