/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.common.util.TimeZonesList;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityServiceImpl;
import com.jaspersoft.jasperserver.api.security.SecurityConfiguration;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalAuthProperties;
import com.jaspersoft.jasperserver.war.common.HeartbeatBean;
import com.jaspersoft.jasperserver.war.common.HeartbeatClientInfo;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.LocalesList;
import com.jaspersoft.jasperserver.war.control.JRBaseMultiActionController;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public class JSCommonController
extends JRBaseMultiActionController {
    public static final String JSP_REQUEST_HANDLING_PREFIX = "jsp:";
    public static final String IS_DEVELOPMENT_ENVIRONMENT_TYPE = "isDevelopmentEnvironmentType";
    public static final String USERS_EXCEEDED = "usersExceeded";
    public static final String BAN_USER = "banUser";
    protected HeartbeatBean heartbeat;
    private ExternalAuthProperties externalAuthPropertiesBean;
    private LocalesList locales;
    private TimeZonesList timezones;
    private String allowUserPasswordChange;
    private String passwordExpirationInDays;
    private String autoCompleteLoginForm;
    private String externalAuthPropertiesBeanName = "externalAuthProperties";
    private static final Log log = LogFactory.getLog(JSCommonController.class);

    public ModelAndView homePage(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        return new ModelAndView("modules/home");
    }

    public ModelAndView login(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        this.setupLoginPage(req);
        return new ModelAndView("modules/login/login");
    }

    public ModelAndView externalLogin(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        req.setAttribute("externalAuthPropertiesBean", (Object)this.getExternalAuthPropertiesBean());
        return new ModelAndView("modules/login/externalLogin");
    }

    protected void setupLoginPage(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        String locale = null;
        String preferredTz = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals(JasperServerConstImpl.getUserLocaleSessionAttr())) {
                    locale = cookie.getValue();
                }
                if (!cookie.getName().equals(JasperServerConstImpl.getUserTimezoneSessionAttr())) continue;
                preferredTz = cookie.getValue();
            }
        }
        Locale displayLocale = req.getLocale();
        String preferredLocale = locale == null || locale.length() == 0 ? displayLocale.toString() : locale;
        if (preferredTz == null) {
            preferredTz = this.timezones.getDefaultTimeZoneID();
        }
        req.setAttribute("preferredLocale", (Object)preferredLocale);
        req.setAttribute("userLocales", (Object)this.locales.getUserLocales(displayLocale));
        req.setAttribute("preferredTimezone", (Object)preferredTz);
        req.setAttribute("userTimezones", (Object)this.timezones.getTimeZones(displayLocale));
        try {
            if (Integer.parseInt(this.passwordExpirationInDays) > 0) {
                this.allowUserPasswordChange = "true";
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        req.setAttribute("allowUserPasswordChange", (Object)this.allowUserPasswordChange);
        req.setAttribute("passwordExpirationInDays", (Object)this.passwordExpirationInDays);
        req.setAttribute("passwordPattern", (Object)this.userAuthService.getAllowedPasswordPattern().replace("\\", "\\\\"));
        req.setAttribute("autoCompleteLoginForm", (Object)this.autoCompleteLoginForm);
        req.setAttribute(IS_DEVELOPMENT_ENVIRONMENT_TYPE, (Object)false);
        req.setAttribute(USERS_EXCEEDED, (Object)false);
        req.setAttribute(BAN_USER, (Object)false);
        req.setAttribute("isEncryptionOn", (Object)SecurityConfiguration.isEncryptionOn());
    }

    public ModelAndView heartbeat(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        boolean isCallPermitted = false;
        String permit = req.getParameter("permit");
        if (permit != null) {
            isCallPermitted = Boolean.valueOf(permit);
        }
        this.heartbeat.permitCall(isCallPermitted);
        return new ModelAndView("ajax/ajaxresponse");
    }

    public ModelAndView heartbeatInfo(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        final HeartbeatClientInfo info = new HeartbeatClientInfo();
        info.setNavigatorAppName(req.getParameter("navAppName"));
        info.setNavigatorAppVersion(req.getParameter("navAppVersion"));
        info.setNavigatorLocale(req.getLocale());
        info.setUserLocale(LocaleContextHolder.getLocale());
        if (req.getParameter("scrWidth") != null) {
            info.setScreenWidth(new Integer(req.getParameter("scrWidth")));
        }
        if (req.getParameter("scrHeight") != null) {
            info.setScreenHeight(new Integer(req.getParameter("scrHeight")));
        }
        if (req.getParameter("scrColorDepth") != null) {
            info.setScreenColorDepth(new Integer(req.getParameter("scrColorDepth")));
        }
        info.setUserAgent(req.getHeader("user-agent"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSCommonController.this.heartbeat.updateClientInfo(info);
            }
        }).start();
        return new ModelAndView("ajax/ajaxresponse");
    }

    public ModelAndView exitUser(HttpServletRequest req, HttpServletResponse res) {
        String redirectURL = "/logout.html?showPasswordChange=" + req.getParameter("showPasswordChange");
        if (UserAuthorityServiceImpl.isUserSwitched()) {
            redirectURL = "/j_acegi_exit_user";
        }
        return new ModelAndView("redirect:" + redirectURL);
    }

    public ModelAndView logout(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        String externalLogoutUrl;
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        boolean loggedinUserIsExternal = false;
        Authentication authObj = SecurityContextHolder.getContext().getAuthentication();
        Object principal = authObj.getPrincipal();
        if (principal instanceof MetadataUserDetails) {
            loggedinUserIsExternal = ((MetadataUserDetails)principal).isExternallyDefined();
        }
        SecurityContextHolder.clearContext();
        ExternalAuthProperties externalAuthProperties = this.getExternalAuthPropertiesBean();
        String string = externalLogoutUrl = externalAuthProperties != null ? externalAuthProperties.getLogoutUrl() : null;
        if (loggedinUserIsExternal && externalLogoutUrl != null && externalLogoutUrl.length() > 0) {
            return new ModelAndView("redirect:" + externalLogoutUrl);
        }
        return new ModelAndView("redirect:/login.html?showPasswordChange=" + req.getParameter("showPasswordChange"));
    }

    protected ExternalAuthProperties getExternalAuthPropertiesBean() {
        try {
            if (this.externalAuthPropertiesBean == null) {
                this.externalAuthPropertiesBean = (ExternalAuthProperties)this.getApplicationContext().getBean(this.externalAuthPropertiesBeanName);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Could not find " + ExternalAuthProperties.class + " bean in the context (using default).  Check that external " + "authentication context xml is in the path."));
        }
        return this.externalAuthPropertiesBean;
    }

    public ModelAndView loginError(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        log.warn((Object)"There was a login error");
        return new ModelAndView("modules/loginError");
    }

    public ModelAndView securityError(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        log.warn((Object)"There was a security error");
        return new ModelAndView("modules/system/errorPage");
    }

    public ModelAndView menuTest(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        return new ModelAndView("menutest");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String methodName = this.getMethodNameResolver().getHandlerMethodName(request);
            if (methodName.startsWith(JSP_REQUEST_HANDLING_PREFIX)) {
                return new ModelAndView(methodName.substring(JSP_REQUEST_HANDLING_PREFIX.length()));
            }
            return this.invokeNamedMethod(methodName, request, response);
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            return this.handleNoSuchRequestHandlingMethod(ex, request, response);
        }
    }

    public LocalesList getLocales() {
        return this.locales;
    }

    public void setLocales(LocalesList locales) {
        this.locales = locales;
    }

    public TimeZonesList getTimezones() {
        return this.timezones;
    }

    public void setTimezones(TimeZonesList timezones) {
        this.timezones = timezones;
    }

    public String getAllowUserPasswordChange() {
        return this.allowUserPasswordChange;
    }

    public void setAllowUserPasswordChange(String changePassword) {
        this.allowUserPasswordChange = changePassword;
    }

    public String getPasswordExpirationInDays() {
        return this.passwordExpirationInDays;
    }

    public void setPasswordExpirationInDays(String passwordExpirationInDays) {
        this.passwordExpirationInDays = passwordExpirationInDays;
    }

    public HeartbeatBean getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(HeartbeatBean heartbeat) {
        this.heartbeat = heartbeat;
    }

    public String getAutoCompleteLoginForm() {
        return this.autoCompleteLoginForm;
    }

    public void setAutoCompleteLoginForm(String autoCompleteLoginForm) {
        this.autoCompleteLoginForm = autoCompleteLoginForm;
    }

    public String getExternalAuthPropertiesBeanName() {
        return this.externalAuthPropertiesBeanName;
    }

    public void setExternalAuthPropertiesBeanName(String externalAuthPropertiesBeanName) {
        this.externalAuthPropertiesBeanName = externalAuthPropertiesBeanName;
    }

    public ModelAndView encryptionPage(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        return new ModelAndView("modules/encrypt");
    }
}

