/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.common.util.TimeZoneContextHolder;
import com.jaspersoft.jasperserver.api.common.util.TimeZonesList;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class SchedulerController
extends MultiActionController {
    private static final Log log = LogFactory.getLog(SchedulerController.class);
    private TimeZonesList timezones;
    private ReportSchedulingService scheduler;
    @Autowired(required=true)
    private HttpServletRequest request;
    private boolean enableSaveToHostFS;
    private static final String LICENSE_MANAGER = "com.jaspersoft.ji.license.LicenseManager";
    private String enableDataSnapshot;

    public ModelAndView main(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("modules/reportScheduling/main");
        mav.addObject("timezone", (Object)TimeZoneContextHolder.getTimeZone().getID());
        mav.addObject("isPro", (Object)this.isProVersion());
        mav.addObject("userTimezones", (Object)this.timezones.getTimeZones(request.getLocale()));
        mav.addObject("enableSaveToHostFS", (Object)this.getEnableSaveToHostFS());
        mav.addObject("enableDataSnapshot", (Object)this.getEnableDataSnapshot());
        return mav;
    }

    public ModelAndView jobsummary(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info((Object)("scheduler req with uri: " + this.getReportUri(request)));
        ModelAndView mav = new ModelAndView();
        mav.setViewName("modules/reportScheduling/jobsSummary");
        List jobsSummaryList = this.getScheduler().getScheduledJobSummaries(null, this.getReportUri(request));
        mav.addObject("jobsSummaryList", (Object)jobsSummaryList);
        log.debug((Object)("returned jobs: " + jobsSummaryList.size()));
        if (jobsSummaryList.size() > 0) {
            mav.addObject("reportUnitURI", (Object)((ReportJobSummary)jobsSummaryList.get(0)).getReportUnitURI());
        }
        mav.addObject("timezone", (Object)TimeZoneContextHolder.getTimeZone().getID());
        return mav;
    }

    public ModelAndView jobdetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("modules/reportScheduling/jobDetails");
        if (request.getParameter("id") != null) {
            long jobId = Long.parseLong(request.getParameter("id"));
            log.info((Object)("jobdetails for job " + jobId));
            ReportJob job = this.getScheduler().getScheduledJob(null, jobId);
            mav.addObject("job", (Object)job);
        }
        return mav;
    }

    private String getReportUri(HttpServletRequest request) {
        String reportUnitURI = request.getParameter("reportUnitURI");
        if (reportUnitURI != null && !reportUnitURI.isEmpty()) {
            return request.getParameter("reportUnitURI");
        }
        throw new IllegalArgumentException("Could not retrieve report uri");
    }

    public ReportSchedulingService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ReportSchedulingService scheduler) {
        this.scheduler = scheduler;
    }

    public boolean isProVersion() {
        boolean isPro;
        block3: {
            isPro = false;
            try {
                Class<?> clazz = Class.forName(LICENSE_MANAGER);
                if (clazz != null) {
                    isPro = true;
                }
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.info((Object)"This is not a pro version. Access is denied");
            }
        }
        return isPro;
    }

    public TimeZonesList getTimezones() {
        return this.timezones;
    }

    public void setTimezones(TimeZonesList timezones) {
        this.timezones = timezones;
    }

    public String getEnableSaveToHostFS() {
        return Boolean.toString(this.isEnableSaveToHostFS());
    }

    public boolean isEnableSaveToHostFS() {
        return this.enableSaveToHostFS;
    }

    public void setEnableSaveToHostFS(boolean enableSaveToHostFS) {
        this.enableSaveToHostFS = enableSaveToHostFS;
    }

    public void setEnableDataSnapshot(String enableDataSnapshot) {
        this.enableDataSnapshot = enableDataSnapshot;
    }

    public String getEnableDataSnapshot() {
        return this.enableDataSnapshot;
    }
}

