/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.core.util.validators.InputValidator;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.UserWrapper;
import javax.annotation.Resource;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class CRUDUserValidator
implements Validator {
    private UserAuthorityService userService;
    @Resource(name="emailInputValidator")
    private InputValidator emailValidator;

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public InputValidator getEmailValidator() {
        return this.emailValidator;
    }

    public void setEmailValidator(InputValidator emailValidator) {
        this.emailValidator = emailValidator;
    }

    public boolean supports(Class clazz) {
        return UserWrapper.class.isAssignableFrom(clazz);
    }

    public void validate(Object bean, Errors errors) {
        UserWrapper wrapper = (UserWrapper)bean;
        User user = wrapper.getUser();
        if (user.getUsername() == null || user.getUsername().trim().length() == 0) {
            errors.rejectValue("user.username", "CRUDUserValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateName(user.getUsername())) {
                errors.rejectValue("user.username", "CRUDUserValidator.error.invalid.chars");
            }
            if (wrapper.isNewMode() && this.userService.userExists(null, user.getUsername())) {
                errors.rejectValue("user.username", "CRUDUserValidator.error.duplicate");
            }
        }
        if (user.getFullName() == null || user.getFullName().trim().length() == 0) {
            errors.rejectValue("user.fullName", "CRUDUserValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateLabel(user.getFullName())) {
            errors.rejectValue("user.fullName", "CRUDUserValidator.error.invalid.chars");
        }
        if (!user.isExternallyDefined()) {
            if (user.getPassword() == null || user.getPassword().trim().length() == 0) {
                errors.rejectValue("user.password", "CRUDUserValidator.error.not.empty");
            } else if (wrapper.getConfirmedPassword() == null || !wrapper.getConfirmedPassword().equals(user.getPassword())) {
                errors.rejectValue("confirmedPassword", "CRUDUserValidator.error.password.not.matches");
            }
        }
        if (user.getEmailAddress() != null) {
            if (user.getEmailAddress().trim().length() > 0) {
                if (!this.emailValidator.isValid((Object)user.getEmailAddress())) {
                    errors.rejectValue("user.emailAddress", "CRUDUserValidator.error.invalid.format");
                }
            } else if (user.getEmailAddress().trim().length() != user.getEmailAddress().length()) {
                errors.rejectValue("user.emailAddress", "CRUDUserValidator.error.contains.spaces");
            }
        }
    }
}

