/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.dto.ResourceReferenceDTO;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ResourceQueryValidator
implements Validator {
    private RepositoryService repository;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public RepositorySecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    public boolean supports(Class clazz) {
        return ResourceReferenceDTO.class.isAssignableFrom(clazz);
    }

    public void validate(Object o, Errors errors) {
    }

    public void validateQueryExists(ResourceReferenceDTO dto, Errors errors) {
        if (dto.getSource() != null && dto.getSource().equals(JasperServerConstImpl.getFieldChoiceRepo()) && (dto.getReferenceURI() == null || dto.getReferenceURI().trim().length() == 0 || !this.repository.resourceExists(null, dto.getReferenceURI()))) {
            errors.rejectValue("referenceURI", "ResourceQueryValidator.error.no");
        } else if (dto.getSource() != null && dto.getSource().equals(JasperServerConstImpl.getFieldChoiceLocal()) && (dto.getLocalResource() == null || dto.getLocalResource().getName() == null || ((Query)dto.getLocalResource()).getSql() == null)) {
            errors.rejectValue("source", "ResourceQueryValidator.error.no");
        }
    }
}

